/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.sqlparser.mappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.wso2.carbon.dataservices.core.sqlparser.DataManipulator;

public class SelectMapper {
    private Queue<String> processedTokens;
    private List<String> concatData;
    private List<String> columns;
    private DataManipulator dataManipulator;
    private boolean tableRefOn = false;

    public SelectMapper(Queue<String> processedTokens) {
        this.processedTokens = processedTokens;
        this.columns = new ArrayList<String>();
        this.dataManipulator = new DataManipulator();
        this.processSyntaxQueue();
    }

    private void processSyntaxQueue() {
        while (this.processedTokens != null && !this.processedTokens.isEmpty()) {
            if (this.processedTokens.peek().equals("STRINGFUNC")) {
                this.processStringFunction(this.processedTokens.peek());
                continue;
            }
            if (this.processedTokens.peek().equals("AGGREGATEFUNC")) {
                this.processAggregateFunction(this.processedTokens.peek());
                continue;
            }
            this.processOrdinaryFunction(this.processedTokens.peek());
        }
    }

    private void processOrdinaryFunction(String processedToken) {
        if (processedToken.equals("COLUMN")) {
            this.processedTokens.poll();
            if (!this.processedTokens.peek().equals("*")) {
                this.columns.add(this.processedTokens.poll());
            } else {
                this.processedTokens.poll();
                this.columns.add("ALL");
            }
        } else if (processedToken.equals("TABLE")) {
            this.tableRefOn = true;
            this.processedTokens.poll();
            this.processedTokens.poll();
            this.processOrdinaryFunction(this.processedTokens.peek());
        } else if (processedToken.equals(".") && this.tableRefOn) {
            this.processedTokens.poll();
            this.processOrdinaryFunction(this.processedTokens.peek());
        } else if (processedToken.equals("COLUMN")) {
            this.tableRefOn = false;
            this.processedTokens.poll();
            this.columns.add("COLUMN");
            this.columns.add(this.processedTokens.poll());
            if (!this.processedTokens.isEmpty()) {
                this.processOrdinaryFunction(this.processedTokens.peek());
            }
        }
    }

    private void processAggregateFunction(String processedToken) {
        if (processedToken.equals("COUNT")) {
            this.dataManipulator.processCount(this.processedTokens);
        } else if (processedToken.equals("SUM")) {
            this.dataManipulator.processSum(this.processedTokens);
        } else if (processedToken.equals("AVG")) {
            this.dataManipulator.processAvg(this.processedTokens);
        } else if (processedToken.equals("MIN")) {
            this.dataManipulator.processMin(this.processedTokens);
        } else if (processedToken.equals("MAX")) {
            this.dataManipulator.processMax(this.processedTokens);
        }
    }

    private void processStringFunction(String processedToken) {
        this.processedTokens.poll();
        if (this.processedTokens.peek().equals("CONCAT")) {
            this.processedTokens.poll();
            do {
                if (!this.processedTokens.peek().equals("COLUMN")) continue;
                this.processedTokens.poll();
                List<String> columnData = this.dataManipulator.retrieveColumnData(this.processedTokens.poll());
                if (this.processedTokens.peek().equals("OPVALUE")) {
                    this.processedTokens.poll();
                    String concatOperator = this.processedTokens.poll();
                    this.concatData = this.dataManipulator.concatDataFunction(columnData, concatOperator, this.concatData);
                    continue;
                }
                this.concatData = this.dataManipulator.concatDataFunction(columnData, null, this.concatData);
            } while (!this.processedTokens.peek().equals("START_OF_RBRACKET"));
        }
    }

    public List<String> getColumns() {
        return this.columns;
    }
}

