/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.config;

import java.util.Map;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.odata.ODataDataHandler;

public abstract class Config {
    private String configId;
    private String type;
    private Map<String, String> properties;
    private DataService dataService;
    private boolean oDataEnabled;

    public Config(DataService dataService, String configId, String type, Map<String, String> properties, boolean oDataEnabled) {
        this.dataService = dataService;
        this.configId = configId;
        this.type = type;
        this.properties = properties;
        this.oDataEnabled = oDataEnabled;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return "Type:" + this.getType() + this.properties.toString();
    }

    public abstract boolean isActive();

    public abstract void close();

    public abstract ODataDataHandler createODataHandler() throws DataServiceFault;

    public boolean isODataEnabled() {
        return this.oDataEnabled;
    }

    public abstract boolean isResultSetFieldsCaseSensitive();
}

