/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.config;

import com.google.gdata.client.spreadsheet.SpreadsheetService;
import com.google.gdata.data.IFeed;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.Config;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.odata.ODataDataHandler;
import org.wso2.carbon.dataservices.core.odata.ODataServiceFault;
import org.wso2.carbon.dataservices.sql.driver.util.GSpreadFeedProcessor;

public class GSpreadConfig
extends Config {
    private static final Log log = LogFactory.getLog(GSpreadConfig.class);
    public static final String BASE_WORKSHEET_URL = "https://spreadsheets.google.com/feeds/worksheets/";
    public static final String BASE_REGISTRY_AUTH_TOKEN_PATH = "/repository/components/org.wso2.carbon.dataservices.core/services/";
    private String key = GSpreadConfig.extractKey(this.getProperty("gspread_datasource"));
    private GSpreadFeedProcessor feedProcessor;

    public GSpreadConfig(DataService dataService, String configId, Map<String, String> properties, boolean odataEnable) throws DataServiceFault {
        super(dataService, configId, "GDATA_SPREADSHEET", properties, odataEnable);
        String clientId = DBUtils.resolvePasswordValue(this.getDataService(), this.getProperty("gspread_client_id"));
        String clientSecret = DBUtils.resolvePasswordValue(this.getDataService(), this.getProperty("gspread_client_secret"));
        String refreshToken = DBUtils.resolvePasswordValue(this.getDataService(), this.getProperty("gspread_refresh_token"));
        String visibility = this.getProperty("gspread_visibility");
        try {
            this.feedProcessor = new GSpreadFeedProcessor(clientId, clientSecret, refreshToken, visibility, BASE_REGISTRY_AUTH_TOKEN_PATH);
        }
        catch (SQLException e) {
            throw new DataServiceFault(e, "Error initialising GSpread feed Processor, " + e.getMessage());
        }
        if (!dataService.isServiceInactive()) {
            this.feedProcessor.setService(new SpreadsheetService(this.getDataService().getName() + ":" + this.getConfigId()));
        }
    }

    public static String extractKey(String documentURL) throws DataServiceFault {
        URI documentURI;
        try {
            documentURI = new URI(documentURL);
        }
        catch (URISyntaxException e) {
            String message = "Document URL Syntax error:" + documentURL;
            log.warn((Object)message, (Throwable)e);
            throw new DataServiceFault(e, message);
        }
        String extractedQuery = documentURI.getQuery();
        if (extractedQuery == null) {
            return GSpreadConfig.getKeyForNewSpreadsheetURLFormat(documentURL);
        }
        int i1 = extractedQuery.lastIndexOf("key=");
        int i2 = extractedQuery.indexOf("&", i1);
        if (i1 == -1) {
            return GSpreadConfig.getKeyForNewSpreadsheetURLFormat(documentURL);
        }
        if (i2 < 0) {
            return extractedQuery.substring(i1 + 4);
        }
        return extractedQuery.substring(i1 + 4, i2);
    }

    private static String getKeyForNewSpreadsheetURLFormat(String documentURI) throws DataServiceFault {
        String[] params = documentURI.split("/");
        String resultKey = null;
        for (int i = 0; i < params.length; ++i) {
            if (!"d".equals(params[i])) continue;
            resultKey = params[i + 1];
        }
        if (resultKey == null) {
            throw new DataServiceFault("Invalid URL format");
        }
        return resultKey;
    }

    public URL generateWorksheetFeedURL() throws MalformedURLException {
        return this.feedProcessor.generateWorksheetFeedURL(this.key);
    }

    public String getKey() {
        return this.key;
    }

    public <F extends IFeed> F getFeed(URL feedUrl, Class<F> feedClass) throws Exception {
        return (F)this.feedProcessor.getFeed(feedUrl, feedClass);
    }

    @Override
    public boolean isActive() {
        return this.feedProcessor.getService() != null;
    }

    @Override
    public void close() {
    }

    @Override
    public ODataDataHandler createODataHandler() throws ODataServiceFault {
        throw new ODataServiceFault("Expose as OData Service feature doesn't support for the " + this.getConfigId() + " Datasource.");
    }

    @Override
    public boolean isResultSetFieldsCaseSensitive() {
        return false;
    }
}

