/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.event;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.event.EventTrigger;
import org.wso2.carbon.dataservices.core.description.event.XPathEventTrigger;
import org.wso2.carbon.dataservices.core.engine.DataService;

public class EventTriggerFactory {
    private EventTriggerFactory() {
    }

    public static EventTrigger createEventTrigger(DataService dataService, OMElement eventEl) throws DataServiceFault {
        String language = eventEl.getAttributeValue(new QName("language"));
        if (language == null || language.equals("XPath")) {
            return EventTriggerFactory.createXPathEventTrigger(dataService, eventEl);
        }
        return null;
    }

    private static XPathEventTrigger createXPathEventTrigger(DataService dataService, OMElement xpathEventEl) throws DataServiceFault {
        try {
            String id = xpathEventEl.getAttributeValue(new QName("id"));
            String expression = xpathEventEl.getFirstChildWithName(new QName("expression")).getText();
            String targetTopic = xpathEventEl.getFirstChildWithName(new QName("target-topic")).getText();
            OMElement subsEl = xpathEventEl.getFirstChildWithName(new QName("subscriptions"));
            Iterator subElItr = subsEl.getChildrenWithName(new QName("subscription"));
            ArrayList<String> endpointUrls = new ArrayList<String>();
            while (subElItr.hasNext()) {
                OMElement subEl = (OMElement)subElItr.next();
                endpointUrls.add(subEl.getText());
            }
            return new XPathEventTrigger(dataService, id, expression, targetTopic, endpointUrls);
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in create XPathEventTrigger");
        }
    }
}

