/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.query;

import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;
import org.jongo.Jongo;
import org.jongo.MongoCollection;
import org.jongo.ResultHandler;
import org.jongo.Update;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.carbon.dataservices.common.DBConstants;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.custom.datasource.DataColumn;
import org.wso2.carbon.dataservices.core.custom.datasource.DataRow;
import org.wso2.carbon.dataservices.core.custom.datasource.FixedDataRow;
import org.wso2.carbon.dataservices.core.custom.datasource.QueryResult;
import org.wso2.carbon.dataservices.core.description.config.MongoConfig;
import org.wso2.carbon.dataservices.core.description.event.EventTrigger;
import org.wso2.carbon.dataservices.core.description.query.Query;
import org.wso2.carbon.dataservices.core.engine.DataEntry;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.InternalParam;
import org.wso2.carbon.dataservices.core.engine.InternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.OutputElement;
import org.wso2.carbon.dataservices.core.engine.OutputElementGroup;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.engine.QueryParam;
import org.wso2.carbon.dataservices.core.engine.Result;
import org.wso2.carbon.dataservices.core.engine.StaticOutputElement;

public class MongoQuery
extends Query {
    private MongoConfig config;
    private String expression;

    public MongoQuery(DataService dataService, String queryId, String configId, String expression, List<QueryParam> queryParams, Result result, EventTrigger inputEventTrigger, EventTrigger outputEventTrigger, Map<String, String> advancedProperties, String inputNamespace) throws DataServiceFault {
        super(dataService, queryId, queryParams, result, configId, inputEventTrigger, outputEventTrigger, advancedProperties, inputNamespace);
        try {
            this.expression = expression;
            this.config = (MongoConfig)this.getDataService().getConfig(this.getConfigId());
        }
        catch (ClassCastException e) {
            throw new DataServiceFault(e, "Configuration is not a Mongo config:" + this.getConfigId());
        }
    }

    @Override
    public Object runPreQuery(InternalParamCollection params, int queryLevel) throws DataServiceFault {
        try {
            return new MongoQueryResult(this.getExpression(), new ArrayList<InternalParam>(params.getParams()));
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in MongoQuery.runQuery: " + e.getMessage());
        }
    }

    @Override
    public void runPostQuery(Object result, XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault {
        QueryResult queryResult = (QueryResult)result;
        while (queryResult != null && queryResult.hasNext()) {
            DataRow currentRow = queryResult.next();
            String tmpVal = currentRow.getValueAt("Document");
            List<OutputElement> elements = this.getResult().getDefaultElementGroup().getAllElements();
            ArrayList<String> totalParamList = new ArrayList<String>();
            for (OutputElement element : elements) {
                this.addInnerElements(element, totalParamList);
            }
            DataEntry dataEntry = this.wrapMongoRow(tmpVal, totalParamList);
            this.writeResultEntry(xmlWriter, dataEntry, params, queryLevel);
        }
    }

    private void addInnerElements(OutputElement outputElement, List<String> paramList) {
        if (outputElement instanceof StaticOutputElement) {
            paramList.add(outputElement.getParam());
        } else if (outputElement instanceof OutputElementGroup) {
            List<OutputElement> outputElements = ((OutputElementGroup)outputElement).getAllElements();
            for (OutputElement element : outputElements) {
                this.addInnerElements(element, paramList);
            }
        }
    }

    private DataEntry wrapMongoRow(String jsonString, List<String> keyList) throws DataServiceFault {
        DataEntry dataEntry = new DataEntry();
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            for (String key : keyList) {
                dataEntry.addValue(key, new ParamValue(this.getElementValueFromJson(jsonString, jsonObject, key)));
            }
        }
        catch (JSONException e) {
            try {
                if (Integer.parseInt(jsonString) >= 0) {
                    dataEntry.addValue("Document".toLowerCase(), new ParamValue(jsonString));
                }
            }
            catch (NumberFormatException e1) {
                throw new DataServiceFault("Error occurred when retrieving data. :" + e.getMessage());
            }
        }
        return dataEntry;
    }

    private String getElementValueFromJson(String jsonString, JSONObject object, String jsonPath) throws JSONException {
        String value = null;
        JSONObject tempObject = object;
        String[] tokens = jsonPath.split("\\.");
        if (tokens[0].equals("Document".toLowerCase())) {
            if (tokens.length == 1) {
                value = jsonString;
            } else {
                for (int i = 1; i < tokens.length; ++i) {
                    JSONArray tempArray;
                    Object[] arrayObjects;
                    if (i == tokens.length - 1) {
                        if (tokens[i].contains("[")) {
                            arrayObjects = this.getArrayElementKeys(tokens[i]);
                            tempArray = tempObject.getJSONArray(arrayObjects[0].toString());
                            value = tempArray.getString(((Integer)arrayObjects[1]).intValue());
                            continue;
                        }
                        value = tempObject.getString(tokens[i]);
                        continue;
                    }
                    if (tokens[i].contains("[")) {
                        arrayObjects = this.getArrayElementKeys(tokens[i]);
                        tempArray = tempObject.getJSONArray(arrayObjects[0].toString());
                        tempObject = tempArray.getJSONObject(((Integer)arrayObjects[1]).intValue());
                        continue;
                    }
                    tempObject = tempObject.getJSONObject(tokens[i]);
                }
            }
            return value;
        }
        return null;
    }

    private Object[] getArrayElementKeys(String element) {
        String arrayName = element.substring(0, element.indexOf(91));
        int keyIndex = Integer.parseInt(element.substring(element.indexOf(91) + 1, element.indexOf(93)));
        return new Object[]{arrayName, keyIndex};
    }

    public MongoConfig getConfig() {
        return this.config;
    }

    public String getExpression() {
        return this.expression;
    }

    private Object[] decodeQuery(String query) throws DataServiceFault {
        DBConstants.MongoDB.MongoOperation mongoOp;
        int i1 = query.indexOf(46);
        if (i1 == -1) {
            throw new DataServiceFault("The MongoDB Collection not specified in the query '" + query + "'");
        }
        String collection = query.substring(0, i1).trim();
        int i2 = query.indexOf(40, i1);
        if (i2 == -1 || i2 - i1 <= 1) {
            throw new DataServiceFault("Invalid MongoDB operation in the query '" + query + "'");
        }
        String operation = query.substring(i1 + 1, i2).trim();
        int i3 = query.lastIndexOf(41);
        if (i3 == -1) {
            throw new DataServiceFault("Invalid MongoDB operation in the query '" + query + "'");
        }
        String opQuery = null;
        if (i3 - i2 > 1) {
            opQuery = query.substring(i2 + 1, i3).trim();
        }
        if ((mongoOp = this.convertToMongoOp(operation)) == DBConstants.MongoDB.MongoOperation.UPDATE) {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(collection);
            result.add(mongoOp);
            result.addAll(this.parseInsertQuery(opQuery));
            return result.toArray();
        }
        return new Object[]{collection, mongoOp, this.checkAndCleanOpQuery(opQuery)};
    }

    private String checkAndCleanOpQuery(String opQuery) throws DataServiceFault {
        if (opQuery == null) {
            return null;
        }
        int a = 0;
        int b = 0;
        if (opQuery.startsWith("'") || opQuery.startsWith("\"")) {
            a = 1;
        }
        if (opQuery.endsWith("'") || opQuery.endsWith("\"")) {
            b = 1;
        }
        return opQuery.substring(a, opQuery.length() - b);
    }

    private List<Object> parseInsertQuery(String opQuery) throws DataServiceFault {
        ArrayList<Object> tokens = new ArrayList<Object>();
        int bracketCount = 0;
        StringBuilder buff = new StringBuilder(100);
        for (char ch : opQuery.toCharArray()) {
            if (ch == ',' && bracketCount == 0) {
                tokens.add(this.checkAndCleanOpQuery(buff.toString().trim()));
                buff.delete(0, buff.length());
                continue;
            }
            buff.append(ch);
            if (ch == '{') {
                ++bracketCount;
                continue;
            }
            if (ch != '}') continue;
            --bracketCount;
        }
        String lastToken = buff.toString().trim();
        if (lastToken.length() > 0) {
            tokens.add(this.checkAndCleanOpQuery(lastToken));
        }
        return tokens;
    }

    private DBConstants.MongoDB.MongoOperation convertToMongoOp(String operation) throws DataServiceFault {
        if ("count".equals(operation)) {
            return DBConstants.MongoDB.MongoOperation.COUNT;
        }
        if ("drop".equals(operation)) {
            return DBConstants.MongoDB.MongoOperation.DROP;
        }
        if ("find".equals(operation)) {
            return DBConstants.MongoDB.MongoOperation.FIND;
        }
        if ("findOne".equals(operation)) {
            return DBConstants.MongoDB.MongoOperation.FIND_ONE;
        }
        if ("insert".equals(operation)) {
            return DBConstants.MongoDB.MongoOperation.INSERT;
        }
        if ("remove".equals(operation)) {
            return DBConstants.MongoDB.MongoOperation.REMOVE;
        }
        if ("update".equals(operation)) {
            return DBConstants.MongoDB.MongoOperation.UPDATE;
        }
        throw new DataServiceFault("Unknown MongoDB operation '" + operation + "'");
    }

    private Jongo getJongo() {
        return this.config.getJongo();
    }

    public class MongoQueryResult
    implements QueryResult {
        private Iterator<?> dataIterator;

        public MongoQueryResult(String query, List<InternalParam> params) throws DataServiceFault {
            Object[] request = MongoQuery.this.decodeQuery(query);
            MongoCollection collection = MongoQuery.this.getJongo().getCollection((String)request[0]);
            String opQuery = (String)request[2];
            Object[] mongoParams = DBUtils.convertInputParamValues(params);
            switch ((DBConstants.MongoDB.MongoOperation)request[1]) {
                case COUNT: {
                    this.dataIterator = this.doCount(collection, opQuery, mongoParams);
                    break;
                }
                case FIND: {
                    this.dataIterator = this.doFind(collection, opQuery, mongoParams);
                    break;
                }
                case FIND_ONE: {
                    this.dataIterator = this.doFindOne(collection, opQuery, mongoParams);
                    break;
                }
                case DROP: {
                    this.doDrop(collection);
                    break;
                }
                case INSERT: {
                    this.doInsert(collection, opQuery, mongoParams);
                    break;
                }
                case REMOVE: {
                    this.doRemove(collection, opQuery, mongoParams);
                    break;
                }
                case UPDATE: {
                    if (request.length < 4) {
                        throw new DataServiceFault("An MongoDB update statement must contain a modifier");
                    }
                    String modifier = (String)request[3];
                    boolean upsert = false;
                    if (request.length > 4) {
                        upsert = Boolean.parseBoolean((String)request[4]);
                    }
                    boolean multi = false;
                    if (request.length > 5) {
                        multi = Boolean.parseBoolean((String)request[5]);
                    }
                    this.doUpdate(collection, opQuery, mongoParams, modifier, upsert, multi);
                }
            }
        }

        private Iterator<Long> doCount(MongoCollection collection, String opQuery, Object[] parameters) {
            long count = opQuery != null ? (parameters.length > 0 ? collection.count(opQuery, parameters) : collection.count(opQuery)) : collection.count();
            ArrayList<Long> countResult = new ArrayList<Long>();
            countResult.add(count);
            return countResult.iterator();
        }

        private Iterator<String> doFind(MongoCollection collection, String opQuery, Object[] parameters) {
            if (opQuery != null) {
                if (parameters.length > 0) {
                    return collection.find(opQuery, parameters).map((ResultHandler)MongoResultMapper.getInstance()).iterator();
                }
                return collection.find(opQuery).map((ResultHandler)MongoResultMapper.getInstance()).iterator();
            }
            return collection.find().map((ResultHandler)MongoResultMapper.getInstance()).iterator();
        }

        private Iterator<String> doFindOne(MongoCollection collection, String opQuery, Object[] parameters) {
            String value = opQuery != null ? (parameters.length > 0 ? (String)collection.findOne(opQuery, parameters).map((ResultHandler)MongoResultMapper.getInstance()) : (String)collection.findOne(opQuery).map((ResultHandler)MongoResultMapper.getInstance())) : (String)collection.findOne().map((ResultHandler)MongoResultMapper.getInstance());
            ArrayList<String> result = new ArrayList<String>();
            result.add(value);
            return result.iterator();
        }

        private void doInsert(MongoCollection collection, String opQuery, Object[] parameters) throws DataServiceFault {
            if (opQuery != null) {
                if (parameters.length > 0) {
                    if (opQuery.equals("#")) {
                        collection.save(JSON.parse((String)parameters[0].toString()));
                    } else {
                        collection.insert(opQuery, parameters);
                    }
                } else {
                    collection.insert(opQuery);
                }
            } else {
                throw new DataServiceFault("Mongo insert statements must contain a query");
            }
        }

        private void doRemove(MongoCollection collection, String opQuery, Object[] parameters) throws DataServiceFault {
            if (opQuery != null) {
                if (parameters.length > 0) {
                    collection.remove(opQuery, parameters);
                } else {
                    collection.remove(opQuery);
                }
            } else {
                throw new DataServiceFault("Mongo remove statements must contain a query");
            }
        }

        private void doUpdate(MongoCollection collection, String opQuery, Object[] parameters, String modifier, boolean upsert, boolean multi) throws DataServiceFault {
            if (opQuery != null) {
                if (parameters.length > 0) {
                    Stack<Object> parameterStack = this.putParametersToStack(parameters);
                    Update update = null;
                    if (!opQuery.contains("#")) {
                        update = collection.update(opQuery);
                    } else {
                        Object[] opQueryParameters = this.getParameters(opQuery, parameterStack).toArray();
                        update = collection.update(opQuery, opQueryParameters);
                    }
                    if (upsert) {
                        update = update.upsert();
                    }
                    if (multi) {
                        update = update.multi();
                    }
                    Object[] modifierParameters = this.getParameters(modifier, parameterStack).toArray();
                    update.with(modifier, modifierParameters);
                } else {
                    Update update = collection.update(opQuery);
                    if (upsert) {
                        update = update.upsert();
                    }
                    if (multi) {
                        update = update.multi();
                    }
                    update.with(modifier);
                }
            } else {
                throw new DataServiceFault("Mongo update statements must contain a query");
            }
        }

        private Stack<Object> putParametersToStack(Object[] parameters) {
            Stack<Object> parameterStack = new Stack<Object>();
            for (int index = parameters.length - 1; index >= 0; --index) {
                parameterStack.push(parameters[index]);
            }
            return parameterStack;
        }

        private ArrayList getParameters(String value, Stack<Object> parameterStack) {
            ArrayList<Object> parameters = new ArrayList<Object>();
            int noOfParameters = StringUtils.countMatches((String)value, (String)"#");
            for (int i = 0; i < noOfParameters; ++i) {
                parameters.add(parameterStack.pop());
            }
            return parameters;
        }

        private void doDrop(MongoCollection collection) {
            collection.drop();
        }

        @Override
        public List<DataColumn> getDataColumns() throws DataServiceFault {
            ArrayList<DataColumn> result = new ArrayList<DataColumn>();
            result.add(new DataColumn("Document"));
            return result;
        }

        @Override
        public boolean hasNext() throws DataServiceFault {
            return this.dataIterator != null && this.dataIterator.hasNext();
        }

        @Override
        public DataRow next() throws DataServiceFault {
            if (this.dataIterator == null) {
                throw new DataServiceFault("No Mongo data result available");
            }
            Object data = this.dataIterator.next();
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("Document", data.toString());
            return new FixedDataRow(values);
        }
    }

    public static final class MongoResultMapper
    implements ResultHandler<String> {
        private static final MongoResultMapper instance = new MongoResultMapper();

        private MongoResultMapper() {
        }

        public static MongoResultMapper getInstance() {
            return instance;
        }

        public String map(DBObject dbo) {
            return dbo.toString();
        }
    }
}

