/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.engine;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.engine.ExternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.engine.Result;

public class XMLWriterHelper {
    private String namespace;

    public XMLWriterHelper(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void startRowElement(XMLStreamWriter xmlWriter, String name, int resultType, Result result, ExternalParamCollection params) throws XMLStreamException {
        if (xmlWriter == null) {
            return;
        }
        switch (resultType) {
            case 2: {
                xmlWriter.writeStartElement(this.getNamespace(), name);
                break;
            }
            case 1: {
                try {
                    String rdfBaseURI = result.getRDFBaseURI();
                    String value = DBUtils.evaluateString(rdfBaseURI, params);
                    xmlWriter.writeStartElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
                    xmlWriter.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", value);
                    break;
                }
                catch (DataServiceFault e) {
                    throw new XMLStreamException("Error in writing start row using RDF", e);
                }
            }
        }
    }

    public void startWrapperElement(XMLStreamWriter xmlWriter, String namespace, String name, int resultType) throws XMLStreamException {
        if (xmlWriter == null) {
            return;
        }
        switch (resultType) {
            case 2: {
                boolean writeNS;
                if (name == null) break;
                xmlWriter.writeStartElement(name);
                String nsPrefix = xmlWriter.getNamespaceContext().getPrefix(this.getNamespace());
                boolean bl = writeNS = nsPrefix == null || !"".equals(nsPrefix);
                if (!writeNS) break;
                xmlWriter.setDefaultNamespace(namespace);
                xmlWriter.writeDefaultNamespace(namespace);
                break;
            }
            case 1: {
                xmlWriter.setDefaultNamespace(namespace);
                xmlWriter.writeStartElement("rdf", "RDF", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
                xmlWriter.writeNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
                xmlWriter.writeDefaultNamespace(namespace);
            }
        }
    }

    public void endElement(XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (xmlWriter == null) {
            return;
        }
        xmlWriter.writeEndElement();
    }

    private void writeElementValue(XMLStreamWriter xmlWriter, ParamValue value) throws XMLStreamException {
        if (xmlWriter == null) {
            return;
        }
        if (value.getArrayValue() == null && value.getScalarValue() == null && value.getUdt() == null) {
            xmlWriter.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            xmlWriter.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
        } else if (value.getValueType() == 2) {
            for (ParamValue val : value.getArrayValue()) {
                xmlWriter.writeCharacters(val.toString());
            }
        } else {
            xmlWriter.writeCharacters(value.toString());
        }
    }

    public void writeResultElement(XMLStreamWriter xmlWriter, String name, ParamValue value, QName xsdType, int categoryType, int resultType, ExternalParamCollection params) throws XMLStreamException {
        if (xmlWriter == null) {
            return;
        }
        block1 : switch (resultType) {
            case 2: {
                boolean writeNS;
                xmlWriter.writeStartElement(name);
                String nsPrefix = xmlWriter.getNamespaceContext().getPrefix(this.getNamespace());
                boolean bl = writeNS = nsPrefix == null || !"".equals(nsPrefix);
                if (writeNS) {
                    xmlWriter.setDefaultNamespace(this.namespace);
                    xmlWriter.writeDefaultNamespace(this.namespace);
                }
                if (value != null) {
                    this.writeElementValue(xmlWriter, value);
                }
                xmlWriter.writeEndElement();
                break;
            }
            case 1: {
                switch (categoryType) {
                    case 1: {
                        xmlWriter.writeStartElement(this.getNamespace(), name);
                        String dataTypeString = xsdType.getNamespaceURI() + "#" + xsdType.getLocalPart();
                        xmlWriter.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype", dataTypeString);
                        this.writeElementValue(xmlWriter, value);
                        xmlWriter.writeEndElement();
                        break block1;
                    }
                    case 2: {
                        try {
                            xmlWriter.writeStartElement(this.getNamespace(), name);
                            String evalValue = DBUtils.evaluateString(value.toString(), params);
                            xmlWriter.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", evalValue);
                            xmlWriter.writeEndElement();
                            break block1;
                        }
                        catch (DataServiceFault e) {
                            throw new XMLStreamException("Error in writing result element using RDF", e);
                        }
                    }
                }
            }
        }
    }

    public void addAttribute(XMLStreamWriter xmlWriter, String name, ParamValue value, QName xsdType, int resultType) throws XMLStreamException {
        if (xmlWriter == null) {
            return;
        }
        switch (resultType) {
            case 2: {
                if (value == null || value.toString() == null) break;
                xmlWriter.writeAttribute(name, value.toString());
            }
        }
    }
}

