/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.odata;

import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.jongo.Jongo;
import org.jongo.ResultHandler;
import org.json.JSONObject;
import org.wso2.carbon.dataservices.core.description.query.MongoQuery;
import org.wso2.carbon.dataservices.core.odata.DataColumn;
import org.wso2.carbon.dataservices.core.odata.NavigationTable;
import org.wso2.carbon.dataservices.core.odata.ODataDataHandler;
import org.wso2.carbon.dataservices.core.odata.ODataEntry;
import org.wso2.carbon.dataservices.core.odata.ODataServiceFault;
import org.wso2.carbon.dataservices.core.odata.ODataUtils;

public class MongoDataHandler
implements ODataDataHandler {
    private final String configId;
    private Map<String, List<String>> primaryKeys;
    private List<String> tableList;
    private Map<String, Map<String, DataColumn>> tableMetaData;
    private Jongo jongo;
    private static final String ETAG = "ETag";
    private static final String DOCUMENT_ID = "_id";
    private ThreadLocal<Boolean> transactionAvailable = new ThreadLocal<Boolean>(){

        @Override
        protected synchronized Boolean initialValue() {
            return false;
        }
    };

    public MongoDataHandler(String configId, Jongo jongo) {
        this.configId = configId;
        this.jongo = jongo;
        this.tableList = this.generateTableList();
        this.tableMetaData = this.generateTableMetaData();
        this.primaryKeys = this.generatePrimaryKeys();
    }

    @Override
    public Map<String, Map<String, DataColumn>> getTableMetadata() {
        return this.tableMetaData;
    }

    private Map<String, Map<String, DataColumn>> generateTableMetaData() {
        int ordinalPosition = 1;
        HashMap<String, Map<String, DataColumn>> metaData = new HashMap<String, Map<String, DataColumn>>();
        HashMap<String, DataColumn> column = new HashMap<String, DataColumn>();
        for (String tableName : this.tableList) {
            DBCollection readResult = this.jongo.getDatabase().getCollection(tableName);
            DBCursor cursor = readResult.find();
            while (cursor.hasNext()) {
                DBObject doumentData = (DBObject)cursor.next();
                String tempValue = doumentData.toString();
                Iterator keys = new JSONObject(tempValue).keys();
                while (keys.hasNext()) {
                    String columnName = (String)keys.next();
                    DataColumn dataColumn = new DataColumn(columnName, DataColumn.ODataDataType.STRING, ordinalPosition, true, 100, columnName.equals(DOCUMENT_ID));
                    column.put(columnName, dataColumn);
                    ++ordinalPosition;
                }
                metaData.put(tableName, column);
            }
        }
        return metaData;
    }

    @Override
    public List<String> getTableList() {
        return this.tableList;
    }

    private List<String> generateTableList() {
        return new ArrayList<String>(this.jongo.getDatabase().getCollectionNames());
    }

    @Override
    public Map<String, List<String>> getPrimaryKeys() {
        return this.primaryKeys;
    }

    private Map<String, List<String>> generatePrimaryKeys() {
        HashMap<String, List<String>> primaryKeyList = new HashMap<String, List<String>>();
        List<String> tableNames = this.tableList;
        ArrayList<String> primaryKey = new ArrayList<String>();
        primaryKey.add(DOCUMENT_ID);
        for (String tname : tableNames) {
            primaryKeyList.put(tname, primaryKey);
        }
        return primaryKeyList;
    }

    @Override
    public List<ODataEntry> readTable(String tableName) {
        ArrayList<ODataEntry> entryList = new ArrayList<ODataEntry>();
        DBCollection readResult = this.jongo.getDatabase().getCollection(tableName);
        DBCursor cursor = readResult.find();
        while (cursor.hasNext()) {
            DBObject documentData = (DBObject)cursor.next();
            String tempValue = documentData.toString();
            Iterator keys = new JSONObject(tempValue).keys();
            ODataEntry dataEntry = this.createDataEntryFromResult(tempValue, keys);
            dataEntry.addValue(ETAG, ODataUtils.generateETag(this.configId, tableName, dataEntry));
            entryList.add(dataEntry);
        }
        return entryList;
    }

    @Override
    public List<ODataEntry> readTableWithKeys(String tableName, ODataEntry keys) throws ODataServiceFault {
        ArrayList<ODataEntry> entryList = new ArrayList<ODataEntry>();
        for (String keyName : keys.getData().keySet()) {
            String keyValue = keys.getValue(keyName);
            String projectionResult = (String)this.jongo.getCollection(tableName).findOne(new ObjectId(keyValue)).map((ResultHandler)MongoQuery.MongoResultMapper.getInstance());
            if (projectionResult == null) {
                throw new ODataServiceFault(DOCUMENT_ID + keyValue + " does not exist in collection: " + tableName + " .");
            }
            Iterator key = new JSONObject(projectionResult).keys();
            ODataEntry dataEntry = this.createDataEntryFromResult(projectionResult, key);
            dataEntry.addValue(ETAG, ODataUtils.generateETag(this.configId, tableName, dataEntry));
            entryList.add(dataEntry);
        }
        return entryList;
    }

    private ODataEntry createDataEntryFromResult(String readResult, Iterator<?> keys) {
        ODataEntry dataEntry = new ODataEntry();
        while (keys.hasNext()) {
            String columnName = (String)keys.next();
            String columnValue = new JSONObject(readResult).get(columnName).toString();
            if (columnName.equals(DOCUMENT_ID)) {
                Iterator idField = new JSONObject(columnValue).keys();
                while (idField.hasNext()) {
                    String idName = idField.next().toString();
                    String idValue = new JSONObject(columnValue).get(idName).toString();
                    dataEntry.addValue(columnName, idValue);
                }
                continue;
            }
            dataEntry.addValue(columnName, columnValue);
        }
        return dataEntry;
    }

    @Override
    public ODataEntry insertEntityToTable(String tableName, ODataEntry entity) {
        ODataEntry createdEntry = new ODataEntry();
        Document document = new Document();
        for (String columnName : entity.getData().keySet()) {
            String columnValue = entity.getValue(columnName);
            document.put(columnName, (Object)columnValue);
            entity.addValue(columnName, columnValue);
        }
        ObjectId objectId = new ObjectId();
        document.put(DOCUMENT_ID, (Object)objectId);
        this.jongo.getCollection(tableName).insert((Object)document);
        String documentIdValue = objectId.toString();
        createdEntry.addValue(DOCUMENT_ID, documentIdValue);
        createdEntry.addValue("E_TAG", ODataUtils.generateETag(this.configId, tableName, entity));
        return createdEntry;
    }

    @Override
    public boolean deleteEntityInTable(String tableName, ODataEntry entity) throws ODataServiceFault {
        String documentId = entity.getValue(DOCUMENT_ID);
        WriteResult delete = this.jongo.getCollection(tableName).remove(new ObjectId(documentId));
        int wasDeleted = delete.getN();
        if (wasDeleted == 1) {
            return delete.wasAcknowledged();
        }
        throw new ODataServiceFault("Document ID: " + documentId + " does not exist in collection: " + tableName + ".");
    }

    @Override
    public boolean updateEntityInTable(String tableName, ODataEntry newProperties) throws ODataServiceFault {
        List<String> primaryKeyList = this.primaryKeys.get(tableName);
        String newPropertyObjectKeyValue = newProperties.getValue(DOCUMENT_ID);
        StringBuilder mongoUpdate = new StringBuilder();
        mongoUpdate.append("{$set: {");
        boolean propertyMatch = false;
        for (String column : newProperties.getData().keySet()) {
            if (primaryKeyList.contains(column)) continue;
            if (propertyMatch) {
                mongoUpdate.append("', ");
            }
            String propertyValue = newProperties.getValue(column);
            mongoUpdate.append(column).append(": '").append(propertyValue);
            propertyMatch = true;
        }
        mongoUpdate.append("'}}");
        String query = mongoUpdate.toString();
        WriteResult update = this.jongo.getCollection(tableName).update(new ObjectId(newPropertyObjectKeyValue)).with(query);
        int wasUpdated = update.getN();
        if (wasUpdated == 1) {
            return update.wasAcknowledged();
        }
        throw new ODataServiceFault("Document ID: " + newPropertyObjectKeyValue + " does not exist in collection: " + tableName + ".");
    }

    @Override
    public boolean updateEntityInTableTransactional(String tableName, ODataEntry oldProperties, ODataEntry newProperties) throws ODataServiceFault {
        String oldPropertyObjectKeyValue = oldProperties.getValue(DOCUMENT_ID);
        StringBuilder updateNewProperties = new StringBuilder();
        updateNewProperties.append("{$set: {");
        boolean propertyMatch = false;
        for (String column : newProperties.getData().keySet()) {
            if (propertyMatch) {
                updateNewProperties.append("', ");
            }
            String propertyValue = newProperties.getValue(column);
            updateNewProperties.append(column).append(": '").append(propertyValue);
            propertyMatch = true;
        }
        updateNewProperties.append("'}}");
        String query = updateNewProperties.toString();
        WriteResult update = this.jongo.getCollection(tableName).update(new ObjectId(oldPropertyObjectKeyValue)).with(query);
        int wasUpdated = update.getN();
        if (wasUpdated == 1) {
            return update.wasAcknowledged();
        }
        throw new ODataServiceFault("Error occured while updating the entity to collection :" + tableName + ".");
    }

    @Override
    public Map<String, NavigationTable> getNavigationProperties() {
        return null;
    }

    @Override
    public void openTransaction() {
        this.transactionAvailable.set(true);
    }

    @Override
    public void commitTransaction() {
        this.transactionAvailable.set(false);
    }

    @Override
    public void rollbackTransaction() {
        this.transactionAvailable.set(false);
    }

    @Override
    public void updateReference(String rootTableName, ODataEntry rootTableKeys, String navigationTable, ODataEntry navigationTableKeys) throws ODataServiceFault {
        throw new ODataServiceFault("MongoDB datasources do not support references.");
    }

    @Override
    public void deleteReference(String rootTableName, ODataEntry rootTableKeys, String navigationTable, ODataEntry navigationTableKeys) throws ODataServiceFault {
        throw new ODataServiceFault("MongoDB datasources do not support references.");
    }
}

