/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.odata;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.axis2.databinding.types.Time;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.odata.DataColumn;
import org.wso2.carbon.dataservices.core.odata.NavigationKeys;
import org.wso2.carbon.dataservices.core.odata.NavigationTable;
import org.wso2.carbon.dataservices.core.odata.ODataDataHandler;
import org.wso2.carbon.dataservices.core.odata.ODataEntry;
import org.wso2.carbon.dataservices.core.odata.ODataServiceFault;
import org.wso2.carbon.dataservices.core.odata.ODataUtils;

public class RDBMSDataHandler
implements ODataDataHandler {
    private static final Log log = LogFactory.getLog(RDBMSDataHandler.class);
    private Map<String, Map<String, Integer>> rdbmsDataTypes;
    private Map<String, Map<String, DataColumn>> tableMetaData;
    private Map<String, List<String>> primaryKeys;
    private final String configID;
    private final DataSource dataSource;
    private List<String> tableList;
    public static final String TABLE_NAME = "TABLE_NAME";
    public static final String TABLE = "TABLE";
    public static final String VIEW = "VIEW";
    public static final String ORACLE_SERVER = "oracle";
    public static final String MSSQL_SERVER = "microsoft sql server";
    private ThreadLocal<Connection> transactionalConnection = new ThreadLocal<Connection>(){

        @Override
        protected synchronized Connection initialValue() {
            return null;
        }
    };
    private boolean defaultAutoCommit;
    private int defaultTransactionalIsolation;
    private Map<String, NavigationTable> navigationProperties;

    public RDBMSDataHandler(DataSource dataSource, String configId) throws ODataServiceFault {
        this.dataSource = dataSource;
        this.tableList = this.generateTableList();
        this.configID = configId;
        this.rdbmsDataTypes = new HashMap<String, Map<String, Integer>>(this.tableList.size());
        this.initializeMetaData();
    }

    @Override
    public Map<String, NavigationTable> getNavigationProperties() {
        return this.navigationProperties;
    }

    @Override
    public void openTransaction() throws ODataServiceFault {
        block4: {
            try {
                if (this.getTransactionalConnection() != null) break block4;
                Connection connection = this.dataSource.getConnection();
                this.defaultAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
                this.defaultTransactionalIsolation = connection.getTransactionIsolation();
                try {
                    connection.setTransactionIsolation(4);
                }
                catch (SQLException e) {
                    connection.setTransactionIsolation(8);
                }
                this.transactionalConnection.set(connection);
            }
            catch (SQLException e) {
                throw new ODataServiceFault(e, "Connection Error occurred. :" + e.getMessage());
            }
        }
    }

    @Override
    public void commitTransaction() throws ODataServiceFault {
        Connection connection = this.getTransactionalConnection();
        try {
            connection.commit();
            connection.setTransactionIsolation(this.defaultTransactionalIsolation);
            connection.setAutoCommit(this.defaultAutoCommit);
        }
        catch (SQLException e) {
            throw new ODataServiceFault(e, "Connection Error occurred while committing. :" + e.getMessage());
        }
        finally {
            try {
                connection.close();
                this.transactionalConnection.set(null);
            }
            catch (Exception exception) {}
        }
    }

    private Connection getTransactionalConnection() {
        return this.transactionalConnection.get();
    }

    @Override
    public void rollbackTransaction() throws ODataServiceFault {
        Connection connection = this.getTransactionalConnection();
        try {
            connection.rollback();
            connection.setTransactionIsolation(this.defaultTransactionalIsolation);
            connection.setAutoCommit(this.defaultAutoCommit);
        }
        catch (SQLException e) {
            throw new ODataServiceFault(e, "Connection Error occurred while rollback. :" + e.getMessage());
        }
        finally {
            try {
                connection.close();
                this.transactionalConnection.set(null);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void updateReference(String rootTable, ODataEntry rootTableKeys, String navigationTable, ODataEntry navigationTableKeys) throws ODataServiceFault {
        ODataEntry importedTableKeys;
        ODataEntry exportedTableKeys;
        String importedTable;
        String exportedTable;
        NavigationTable navigation = this.navigationProperties.get(rootTable);
        boolean rootTableExportedColumns = false;
        if (navigation != null && navigation.getTables().contains(navigationTable)) {
            rootTableExportedColumns = true;
        }
        if (rootTableExportedColumns) {
            exportedTable = rootTable;
            importedTable = navigationTable;
            exportedTableKeys = rootTableKeys;
            importedTableKeys = navigationTableKeys;
        } else {
            exportedTable = navigationTable;
            importedTable = rootTable;
            exportedTableKeys = navigationTableKeys;
            importedTableKeys = rootTableKeys;
        }
        List<NavigationKeys> keys = this.navigationProperties.get(exportedTable).getNavigationKeys(importedTable);
        ODataEntry exportedKeyValues = this.getForeignKeysValues(exportedTable, exportedTableKeys, keys);
        this.modifyReferences(keys, importedTable, exportedTable, exportedKeyValues, importedTableKeys);
    }

    @Override
    public void deleteReference(String rootTable, ODataEntry rootTableKeys, String navigationTable, ODataEntry navigationTableKeys) throws ODataServiceFault {
        ODataEntry importedTableKeys;
        String importedTable;
        String exportedTable;
        NavigationTable navigation = this.navigationProperties.get(rootTable);
        boolean rootTableExportedColumns = false;
        if (navigation != null && navigation.getTables().contains(navigationTable)) {
            rootTableExportedColumns = true;
        }
        if (rootTableExportedColumns) {
            exportedTable = rootTable;
            importedTable = navigationTable;
            importedTableKeys = navigationTableKeys;
        } else {
            exportedTable = navigationTable;
            importedTable = rootTable;
            importedTableKeys = rootTableKeys;
        }
        List<NavigationKeys> keys = this.navigationProperties.get(exportedTable).getNavigationKeys(importedTable);
        ODataEntry nullReferenceValues = new ODataEntry();
        for (NavigationKeys key : keys) {
            nullReferenceValues.addValue(key.getForeignKey(), null);
        }
        this.modifyReferences(keys, importedTable, exportedTable, nullReferenceValues, importedTableKeys);
    }

    private void modifyReferences(List<NavigationKeys> keys, String importedTable, String exportedTable, ODataEntry modifyValues, ODataEntry primaryKeys) throws ODataServiceFault {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            String value;
            connection = this.initializeConnection();
            String query = this.createAddReferenceSQL(importedTable, keys);
            statement = connection.prepareStatement(query);
            int index = 1;
            for (String column : modifyValues.getNames()) {
                value = modifyValues.getValue(column);
                this.bindValuesToPreparedStatement(this.rdbmsDataTypes.get(exportedTable).get(column), value, index, statement);
                ++index;
            }
            for (String column : primaryKeys.getNames()) {
                value = primaryKeys.getValue(column);
                this.bindValuesToPreparedStatement(this.rdbmsDataTypes.get(importedTable).get(column), value, index, statement);
                ++index;
            }
            statement.execute();
            this.commitExecution(connection);
            this.releaseResources(null, statement);
            this.releaseConnection(connection);
        }
        catch (SQLException | ParseException e) {
            try {
                log.warn((Object)("modify value count - " + modifyValues.getNames().size() + ", primary keys size - " + primaryKeys.getNames().size() + ", Error - " + e.getMessage()), (Throwable)e);
                throw new ODataServiceFault(e, "Error occurred while updating foreign key values. :" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.releaseResources(null, statement);
                this.releaseConnection(connection);
                throw throwable;
            }
        }
    }

    private ODataEntry getForeignKeysValues(String tableName, ODataEntry keys, List<NavigationKeys> columns) throws ODataServiceFault {
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            connection = this.initializeConnection();
            String query = this.createSelectReferenceKeyFromExportedTable(tableName, keys, columns);
            statement = connection.prepareStatement(query);
            int index = 1;
            for (String column : keys.getNames()) {
                String value = keys.getValue(column);
                this.bindValuesToPreparedStatement(this.rdbmsDataTypes.get(tableName).get(column), value, index, statement);
                ++index;
            }
            resultSet = statement.executeQuery();
            ODataEntry values = new ODataEntry();
            for (NavigationKeys column : columns) {
                String columnName = column.getPrimaryKey();
                while (resultSet.next()) {
                    String value = this.getValueFromResultSet(this.rdbmsDataTypes.get(tableName).get(columnName), columnName, resultSet);
                    values.addValue(columnName, value);
                }
            }
            ODataEntry oDataEntry = values;
            this.releaseResources(resultSet, statement);
            this.releaseConnection(connection);
            return oDataEntry;
        }
        catch (SQLException | ParseException e) {
            try {
                throw new ODataServiceFault(e, "Error occurred while retrieving foreign key values. :" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.releaseResources(resultSet, statement);
                this.releaseConnection(connection);
                throw throwable;
            }
        }
    }

    private String createSelectReferenceKeyFromExportedTable(String tableName, ODataEntry keys, List<NavigationKeys> columns) {
        StringBuilder sql = new StringBuilder();
        boolean propertyMatch = false;
        sql.append("SELECT ");
        for (NavigationKeys navigationKeys : columns) {
            if (propertyMatch) {
                sql.append(" , ");
            }
            sql.append(navigationKeys.getPrimaryKey());
            propertyMatch = true;
        }
        sql.append(" FROM ").append(tableName).append(" WHERE ");
        propertyMatch = false;
        for (String string : this.rdbmsDataTypes.get(tableName).keySet()) {
            if (keys.getValue(string) == null) continue;
            if (propertyMatch) {
                sql.append(" AND ");
            }
            sql.append(string).append(" = ").append(" ? ");
            propertyMatch = true;
        }
        return sql.toString();
    }

    private String createAddReferenceSQL(String tableName, List<NavigationKeys> keys) {
        List<String> pKeys = this.primaryKeys.get(tableName);
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(tableName).append(" SET ");
        boolean propertyMatch = false;
        for (NavigationKeys column : keys) {
            if (propertyMatch) {
                sql.append(",");
            }
            sql.append(column.getForeignKey()).append(" = ").append(" ? ");
            propertyMatch = true;
        }
        sql.append(" WHERE ");
        propertyMatch = false;
        for (String key : pKeys) {
            if (propertyMatch) {
                sql.append(" AND ");
            }
            sql.append(key).append(" = ").append(" ? ");
            propertyMatch = true;
        }
        return sql.toString();
    }

    @Override
    public List<ODataEntry> readTable(String tableName) throws ODataServiceFault {
        ResultSet resultSet = null;
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.initializeConnection();
            String query = "select * from " + tableName;
            statement = connection.prepareStatement(query);
            resultSet = statement.executeQuery();
            List<ODataEntry> list = this.createDataEntryCollectionFromRS(tableName, resultSet);
            this.releaseResources(resultSet, statement);
            this.releaseConnection(connection);
            return list;
        }
        catch (SQLException e) {
            try {
                throw new ODataServiceFault(e, "Error occurred while reading entities from " + tableName + " table. :" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.releaseResources(resultSet, statement);
                this.releaseConnection(connection);
                throw throwable;
            }
        }
    }

    @Override
    public List<String> getTableList() {
        return this.tableList;
    }

    @Override
    public Map<String, List<String>> getPrimaryKeys() {
        return this.primaryKeys;
    }

    private String convertToTimeString(java.sql.Time sqlTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(sqlTime.getTime());
        return new Time(cal).toString();
    }

    private String convertToTimestampString(Timestamp sqlTimestamp) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(sqlTimestamp.getTime());
        return ConverterUtil.convertToString((Calendar)cal);
    }

    @Override
    public ODataEntry insertEntityToTable(String tableName, ODataEntry entry) throws ODataServiceFault {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.initializeConnection();
            String query = this.createInsertSQL(tableName, entry);
            boolean isAvailableAutoIncrementColumns = this.isAvailableAutoIncrementColumns(tableName);
            statement = isAvailableAutoIncrementColumns ? connection.prepareStatement(query, 1) : connection.prepareStatement(query);
            int index = 1;
            for (String column : entry.getNames()) {
                if (!this.rdbmsDataTypes.get(tableName).keySet().contains(column)) continue;
                String value = entry.getValue(column);
                this.bindValuesToPreparedStatement(this.rdbmsDataTypes.get(tableName).get(column), value, index, statement);
                ++index;
            }
            ODataEntry createdEntry = new ODataEntry();
            if (this.isAvailableAutoIncrementColumns(tableName)) {
                statement.executeUpdate();
                ResultSet resultSet = statement.getGeneratedKeys();
                int i = 1;
                while (resultSet.next()) {
                    for (DataColumn column : this.tableMetaData.get(tableName).values()) {
                        if (!column.isAutoIncrement()) continue;
                        String resultSetColumnName = resultSet.getMetaData().getColumnName(i);
                        String columnName = column.getColumnName();
                        int columnType = this.rdbmsDataTypes.get(tableName).get(columnName);
                        String paramValue = this.getValueFromResultSet(columnType, resultSetColumnName, resultSet);
                        createdEntry.addValue(columnName, paramValue);
                        entry.addValue(columnName, paramValue);
                    }
                    ++i;
                }
            } else {
                statement.execute();
            }
            this.commitExecution(connection);
            createdEntry.addValue("E_TAG", ODataUtils.generateETag(this.configID, tableName, entry));
            ODataEntry oDataEntry = createdEntry;
            this.releaseResources(null, statement);
            this.releaseConnection(connection);
            return oDataEntry;
        }
        catch (SQLException | ParseException e) {
            try {
                throw new ODataServiceFault(e, "Error occurred while writing entities to " + tableName + " table. :" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.releaseResources(null, statement);
                this.releaseConnection(connection);
                throw throwable;
            }
        }
    }

    private boolean isAvailableAutoIncrementColumns(String table) {
        for (DataColumn column : this.tableMetaData.get(table).values()) {
            if (!column.isAutoIncrement()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ODataEntry> readTableWithKeys(String tableName, ODataEntry keys) throws ODataServiceFault {
        ResultSet resultSet = null;
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.initializeConnection();
            String query = this.createReadSqlWithKeys(tableName, keys);
            statement = connection.prepareStatement(query);
            int index = 1;
            for (String column : keys.getNames()) {
                if (!this.rdbmsDataTypes.get(tableName).keySet().contains(column)) continue;
                String value = keys.getValue(column);
                this.bindValuesToPreparedStatement(this.rdbmsDataTypes.get(tableName).get(column), value, index, statement);
                ++index;
            }
            resultSet = statement.executeQuery();
            List<ODataEntry> list = this.createDataEntryCollectionFromRS(tableName, resultSet);
            this.releaseResources(resultSet, statement);
            this.releaseConnection(connection);
            return list;
        }
        catch (SQLException | ParseException e) {
            try {
                throw new ODataServiceFault(e, "Error occurred while reading entities from " + tableName + " table. :" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.releaseResources(resultSet, statement);
                this.releaseConnection(connection);
                throw throwable;
            }
        }
    }

    private void bindValuesToPreparedStatement(int type, String value, int ordinalPosition, PreparedStatement sqlStatement) throws SQLException, ParseException, ODataServiceFault {
        try {
            switch (type) {
                case 4: {
                    if (value == null) {
                        sqlStatement.setNull(ordinalPosition, type);
                        break;
                    }
                    sqlStatement.setInt(ordinalPosition, ConverterUtil.convertToInt((String)value));
                    break;
                }
                case -6: {
                    if (value == null) {
                        sqlStatement.setNull(ordinalPosition, type);
                        break;
                    }
                    sqlStatement.setByte(ordinalPosition, ConverterUtil.convertToByte((String)value));
                    break;
                }
                case 5: {
                    if (value == null) {
                        sqlStatement.setNull(ordinalPosition, type);
                        break;
                    }
                    sqlStatement.setShort(ordinalPosition, ConverterUtil.convertToShort((String)value));
                    break;
                }
                case 8: {
                    if (value == null) {
                        sqlStatement.setNull(ordinalPosition, type);
                        break;
                    }
                    sqlStatement.setDouble(ordinalPosition, ConverterUtil.convertToDouble((String)value));
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    if (value == null) {
                        sqlStatement.setNull(ordinalPosition, type);
                        break;
                    }
                    sqlStatement.setString(ordinalPosition, value);
                    break;
                }
                case 2005: {
                    if (value == null) {
                        sqlStatement.setNull(ordinalPosition, type);
                        break;
                    }
                    sqlStatement.setClob(ordinalPosition, new BufferedReader(new StringReader(value)), value.length());
                    break;
                }
                case -7: 
                case 16: {
                    if (value == null) {
                        sqlStatement.setNull(ordinalPosition, type);
                        break;
                    }
                    sqlStatement.setBoolean(ordinalPosition, ConverterUtil.convertToBoolean((String)value));
                    break;
                }
                case -4: 
                case 2004: {
                    if (value == null) {
                        sqlStatement.setNull(ordinalPosition, type);
                        break;
                    }
                    byte[] data = this.getBytesFromBase64String(value);
                    sqlStatement.setBlob(ordinalPosition, new ByteArrayInputStream(data), data.length);
                    break;
                }
                case -3: 
                case -2: {
                    if (value == null) {
                        sqlStatement.setNull(ordinalPosition, type);
                        break;
                    }
                    byte[] data = this.getBytesFromBase64String(value);
                    sqlStatement.setBinaryStream(ordinalPosition, (InputStream)new ByteArrayInputStream(data), data.length);
                    break;
                }
                case 91: {
                    if (value == null) {
                        sqlStatement.setNull(ordinalPosition, type);
                        break;
                    }
                    sqlStatement.setDate(ordinalPosition, DBUtils.getDate(value));
                    break;
                }
                case 2: 
                case 3: {
                    if (value == null) {
                        sqlStatement.setNull(ordinalPosition, type);
                        break;
                    }
                    sqlStatement.setBigDecimal(ordinalPosition, ConverterUtil.convertToBigDecimal((String)value));
                    break;
                }
                case 6: 
                case 7: {
                    if (value == null) {
                        sqlStatement.setNull(ordinalPosition, type);
                        break;
                    }
                    sqlStatement.setFloat(ordinalPosition, ConverterUtil.convertToFloat((String)value));
                    break;
                }
                case 92: {
                    if (value == null) {
                        sqlStatement.setNull(ordinalPosition, type);
                        break;
                    }
                    sqlStatement.setTime(ordinalPosition, DBUtils.getTime(value));
                    break;
                }
                case -16: 
                case -15: 
                case -9: {
                    if (value == null) {
                        sqlStatement.setNull(ordinalPosition, type);
                        break;
                    }
                    sqlStatement.setNString(ordinalPosition, value);
                    break;
                }
                case 2011: {
                    if (value == null) {
                        sqlStatement.setNull(ordinalPosition, type);
                        break;
                    }
                    sqlStatement.setNClob(ordinalPosition, new BufferedReader(new StringReader(value)), value.length());
                    break;
                }
                case -5: {
                    if (value == null) {
                        sqlStatement.setNull(ordinalPosition, type);
                        break;
                    }
                    sqlStatement.setLong(ordinalPosition, ConverterUtil.convertToLong((String)value));
                    break;
                }
                case 93: {
                    if (value == null) {
                        sqlStatement.setNull(ordinalPosition, type);
                        break;
                    }
                    sqlStatement.setTimestamp(ordinalPosition, DBUtils.getTimestamp(value));
                    break;
                }
                default: {
                    if (value == null) {
                        sqlStatement.setNull(ordinalPosition, type);
                        break;
                    }
                    sqlStatement.setString(ordinalPosition, value);
                    break;
                }
            }
        }
        catch (DataServiceFault e) {
            throw new ODataServiceFault(e, "Error occurred while binding values. :" + e.getMessage());
        }
    }

    private byte[] getBytesFromBase64String(String base64Str) throws SQLException {
        try {
            return Base64.decodeBase64((byte[])base64Str.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public boolean updateEntityInTable(String tableName, ODataEntry newProperties) throws ODataServiceFault {
        List<String> pKeys = this.primaryKeys.get(tableName);
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            String value;
            connection = this.initializeConnection();
            String query = this.createUpdateEntitySQL(tableName, newProperties);
            statement = connection.prepareStatement(query);
            int index = 1;
            for (String column : newProperties.getNames()) {
                if (pKeys.contains(column)) continue;
                value = newProperties.getValue(column);
                this.bindValuesToPreparedStatement(this.rdbmsDataTypes.get(tableName).get(column), value, index, statement);
                ++index;
            }
            for (String column : newProperties.getNames()) {
                if (!pKeys.isEmpty()) {
                    if (!pKeys.contains(column)) continue;
                    value = newProperties.getValue(column);
                    this.bindValuesToPreparedStatement(this.rdbmsDataTypes.get(tableName).get(column), value, index, statement);
                    ++index;
                    continue;
                }
                throw new ODataServiceFault("Error occurred while updating the entity to " + tableName + " table. couldn't find keys in the table.");
            }
            statement.execute();
            this.commitExecution(connection);
            boolean bl = true;
            this.releaseResources(null, statement);
            this.releaseConnection(connection);
            return bl;
        }
        catch (SQLException | ParseException e) {
            try {
                throw new ODataServiceFault(e, "Error occurred while updating the entity to " + tableName + " table. :" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.releaseResources(null, statement);
                this.releaseConnection(connection);
                throw throwable;
            }
        }
    }

    @Override
    public boolean updateEntityInTableTransactional(String tableName, ODataEntry oldProperties, ODataEntry newProperties) throws ODataServiceFault {
        List<String> pKeys = this.primaryKeys.get(tableName);
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            String value;
            connection = this.initializeConnection();
            String query = this.createUpdateEntitySQL(tableName, newProperties);
            statement = connection.prepareStatement(query);
            int index = 1;
            for (String column : newProperties.getNames()) {
                if (pKeys.contains(column)) continue;
                value = newProperties.getValue(column);
                this.bindValuesToPreparedStatement(this.rdbmsDataTypes.get(tableName).get(column), value, index, statement);
                ++index;
            }
            for (String column : oldProperties.getNames()) {
                if (!pKeys.isEmpty()) {
                    if (!pKeys.contains(column)) continue;
                    value = oldProperties.getValue(column);
                    this.bindValuesToPreparedStatement(this.rdbmsDataTypes.get(tableName).get(column), value, index, statement);
                    ++index;
                    continue;
                }
                throw new ODataServiceFault("Error occurred while updating the entity to " + tableName + " table. couldn't find keys in the table.");
            }
            statement.execute();
            this.commitExecution(connection);
            boolean bl = true;
            this.releaseResources(null, statement);
            this.releaseConnection(connection);
            return bl;
        }
        catch (SQLException | ParseException e) {
            try {
                throw new ODataServiceFault(e, "Error occurred while updating the entity to " + tableName + " table. :" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.releaseResources(null, statement);
                this.releaseConnection(connection);
                throw throwable;
            }
        }
    }

    @Override
    public boolean deleteEntityInTable(String tableName, ODataEntry entry) throws ODataServiceFault {
        List<String> pKeys = this.primaryKeys.get(tableName);
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.initializeConnection();
            String query = this.createDeleteSQL(tableName);
            statement = connection.prepareStatement(query);
            int index = 1;
            for (String column : pKeys) {
                if (!this.rdbmsDataTypes.get(tableName).keySet().contains(column)) continue;
                String value = entry.getValue(column);
                this.bindValuesToPreparedStatement(this.rdbmsDataTypes.get(tableName).get(column), value, index, statement);
                ++index;
            }
            statement.execute();
            int rowCount = statement.getUpdateCount();
            this.commitExecution(connection);
            boolean bl = rowCount > 0;
            this.releaseResources(null, statement);
            this.releaseConnection(connection);
            return bl;
        }
        catch (SQLException | ParseException e) {
            try {
                throw new ODataServiceFault(e, "Error occurred while deleting the entity from " + tableName + " table. :" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.releaseResources(null, statement);
                this.releaseConnection(connection);
                throw throwable;
            }
        }
    }

    private void addDataType(String tableName, String columnName, int dataType) {
        Map<String, Integer> tableMap = this.rdbmsDataTypes.get(tableName);
        if (tableMap == null) {
            tableMap = new HashMap<String, Integer>();
            this.rdbmsDataTypes.put(tableName, tableMap);
        }
        tableMap.put(columnName, dataType);
    }

    private List<ODataEntry> createDataEntryCollectionFromRS(String tableName, ResultSet resultSet) throws ODataServiceFault {
        ArrayList<ODataEntry> entitySet = new ArrayList<ODataEntry>();
        try {
            while (resultSet.next()) {
                ODataEntry entry = new ODataEntry();
                for (String column : this.rdbmsDataTypes.get(tableName).keySet()) {
                    int columnType = this.rdbmsDataTypes.get(tableName).get(column);
                    String paramValue = this.getValueFromResultSet(columnType, column, resultSet);
                    entry.addValue(column, paramValue);
                }
                entry.addValue("ETag", ODataUtils.generateETag(this.configID, tableName, entry));
                entitySet.add(entry);
            }
            return entitySet;
        }
        catch (SQLException e) {
            throw new ODataServiceFault(e, "Error in writing the entities to table. :" + e.getMessage());
        }
    }

    private String getValueFromResultSet(int columnType, String column, ResultSet resultSet) throws SQLException {
        String paramValue;
        switch (columnType) {
            case -6: 
            case 4: 
            case 5: {
                paramValue = ConverterUtil.convertToString((int)resultSet.getInt(column));
                paramValue = resultSet.wasNull() ? null : paramValue;
                break;
            }
            case 8: {
                paramValue = ConverterUtil.convertToString((double)resultSet.getDouble(column));
                paramValue = resultSet.wasNull() ? null : paramValue;
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                paramValue = resultSet.getString(column);
                break;
            }
            case -7: 
            case 16: {
                paramValue = ConverterUtil.convertToString((boolean)resultSet.getBoolean(column));
                paramValue = resultSet.wasNull() ? null : paramValue;
                break;
            }
            case 2004: {
                Blob sqlBlob = resultSet.getBlob(column);
                paramValue = sqlBlob != null ? this.getBase64StringFromInputStream(sqlBlob.getBinaryStream()) : null;
                paramValue = resultSet.wasNull() ? null : paramValue;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                InputStream binInStream = resultSet.getBinaryStream(column);
                if (binInStream != null) {
                    paramValue = this.getBase64StringFromInputStream(binInStream);
                    break;
                }
                paramValue = null;
                break;
            }
            case 91: {
                Date sqlDate = resultSet.getDate(column);
                if (sqlDate != null) {
                    paramValue = ConverterUtil.convertToString((java.util.Date)sqlDate);
                    break;
                }
                paramValue = null;
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = resultSet.getBigDecimal(column);
                paramValue = bigDecimal != null ? ConverterUtil.convertToString((BigDecimal)bigDecimal) : null;
                paramValue = resultSet.wasNull() ? null : paramValue;
                break;
            }
            case 6: {
                paramValue = ConverterUtil.convertToString((float)resultSet.getFloat(column));
                paramValue = resultSet.wasNull() ? null : paramValue;
                break;
            }
            case 92: {
                java.sql.Time sqlTime = resultSet.getTime(column);
                if (sqlTime != null) {
                    paramValue = this.convertToTimeString(sqlTime);
                    break;
                }
                paramValue = null;
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case 2011: {
                paramValue = resultSet.getNString(column);
                break;
            }
            case -5: {
                paramValue = ConverterUtil.convertToString((long)resultSet.getLong(column));
                paramValue = resultSet.wasNull() ? null : paramValue;
                break;
            }
            case 93: {
                Timestamp sqlTimestamp = resultSet.getTimestamp(column);
                paramValue = sqlTimestamp != null ? this.convertToTimestampString(sqlTimestamp) : null;
                paramValue = resultSet.wasNull() ? null : paramValue;
                break;
            }
            default: {
                paramValue = resultSet.getString(column);
                paramValue = resultSet.wasNull() ? null : paramValue;
            }
        }
        return paramValue;
    }

    private void releaseResources(ResultSet resultSet, Statement statement) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getBase64StringFromInputStream(InputStream in) throws SQLException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            int i;
            byte[] buff = new byte[512];
            while ((i = in.read(buff)) > 0) {
                byteOut.write(buff, 0, i);
            }
            in.close();
            byte[] base64Data = Base64.encodeBase64((byte[])byteOut.toByteArray());
            String strData = base64Data != null ? new String(base64Data, "UTF-8") : null;
            return strData;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    private Map<String, DataColumn> readTableColumnMetaData(String tableName, DatabaseMetaData meta) throws ODataServiceFault {
        ResultSet resultSet = null;
        HashMap<String, DataColumn> columnMap = new HashMap<String, DataColumn>();
        try {
            if (meta.getDatabaseProductName().toLowerCase().contains(ORACLE_SERVER)) {
                resultSet = meta.getColumns(null, meta.getUserName(), tableName, null);
                if (meta.getConnection().getSchema() != null && !meta.getConnection().getSchema().equals(meta.getUserName())) {
                    resultSet = meta.getColumns(null, meta.getConnection().getSchema(), tableName, null);
                }
            } else {
                resultSet = meta.getColumns(null, null, tableName, null);
            }
            int i = 1;
            while (resultSet.next()) {
                String columnName = resultSet.getString("COLUMN_NAME");
                int columnType = resultSet.getInt("DATA_TYPE");
                int size = resultSet.getInt("COLUMN_SIZE");
                boolean nullable = resultSet.getBoolean("NULLABLE");
                String columnDefaultVal = resultSet.getString("COLUMN_DEF");
                String autoIncrement = resultSet.getString("IS_AUTOINCREMENT").toLowerCase();
                boolean isAutoIncrement = false;
                if (autoIncrement.contains("yes") || autoIncrement.contains("true")) {
                    isAutoIncrement = true;
                }
                DataColumn column = new DataColumn(columnName, this.getODataDataType(columnType), i, nullable, size, isAutoIncrement);
                if (null != columnDefaultVal) {
                    column.setDefaultValue(columnDefaultVal);
                }
                if (8 == columnType || 6 == columnType || 3 == columnType || 2 == columnType || 7 == columnType) {
                    int scale = resultSet.getInt("DECIMAL_DIGITS");
                    column.setPrecision(size);
                    if (scale == 0) {
                        scale = 5;
                        column.setScale(scale);
                    } else {
                        column.setScale(scale);
                    }
                }
                columnMap.put(columnName, column);
                this.addDataType(tableName, columnName, columnType);
                ++i;
            }
            HashMap<String, DataColumn> hashMap = columnMap;
            this.releaseResources(resultSet, null);
            return hashMap;
        }
        catch (SQLException e) {
            try {
                throw new ODataServiceFault(e, "Error in reading table meta data in " + tableName + " table. :" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.releaseResources(resultSet, null);
                throw throwable;
            }
        }
    }

    private void initializeMetaData() throws ODataServiceFault {
        this.tableMetaData = new HashMap<String, Map<String, DataColumn>>();
        this.primaryKeys = new HashMap<String, List<String>>();
        this.navigationProperties = new HashMap<String, NavigationTable>();
        Connection connection = null;
        try {
            connection = this.initializeConnection();
            DatabaseMetaData metadata = connection.getMetaData();
            String catalog = connection.getCatalog();
            for (String tableName : this.tableList) {
                this.tableMetaData.put(tableName, this.readTableColumnMetaData(tableName, metadata));
                this.navigationProperties.put(tableName, this.readForeignKeys(tableName, metadata, catalog));
                this.primaryKeys.put(tableName, this.readTablePrimaryKeys(tableName, metadata, catalog));
            }
        }
        catch (SQLException e) {
            throw new ODataServiceFault(e, "Error in reading tables from the database. :" + e.getMessage());
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    private List<String> generateTableList() throws ODataServiceFault {
        ArrayList<String> tableList = new ArrayList<String>();
        Connection connection = null;
        ResultSet rs = null;
        try {
            String tableName;
            connection = this.initializeConnection();
            DatabaseMetaData meta = connection.getMetaData();
            rs = meta.getDatabaseProductName().toLowerCase().contains(ORACLE_SERVER) ? meta.getTables(null, meta.getUserName(), null, new String[]{TABLE, VIEW}) : (meta.getDatabaseProductName().toLowerCase().contains(MSSQL_SERVER) ? meta.getTables(null, connection.getSchema(), null, new String[]{TABLE, VIEW}) : meta.getTables(null, null, null, new String[]{TABLE, VIEW}));
            while (rs.next()) {
                tableName = rs.getString(TABLE_NAME);
                tableList.add(tableName);
            }
            if (meta.getDatabaseProductName().toLowerCase().contains(ORACLE_SERVER) && connection.getSchema() != null && !connection.getSchema().equals(meta.getUserName())) {
                rs = meta.getTables(null, connection.getSchema(), null, new String[]{TABLE, VIEW});
                while (rs.next()) {
                    tableName = rs.getString(TABLE_NAME);
                    tableList.add(tableName);
                }
            }
            ArrayList<String> arrayList = tableList;
            this.releaseResources(rs, null);
            this.releaseConnection(connection);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                throw new ODataServiceFault(e, "Error in reading tables from the database. :" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.releaseResources(rs, null);
                this.releaseConnection(connection);
                throw throwable;
            }
        }
    }

    private List<String> readTablePrimaryKeys(String tableName, DatabaseMetaData metaData, String catalog) throws ODataServiceFault {
        ResultSet resultSet = null;
        ArrayList<Object> keys = new ArrayList<Object>();
        try {
            Object primaryKey;
            resultSet = metaData.getDatabaseProductName().toLowerCase().contains(ORACLE_SERVER) ? metaData.getPrimaryKeys(catalog, metaData.getUserName(), tableName) : metaData.getPrimaryKeys(catalog, null, tableName);
            while (resultSet.next()) {
                primaryKey = resultSet.getString("COLUMN_NAME");
                keys.add(primaryKey);
            }
            primaryKey = keys;
            this.releaseResources(resultSet, null);
            return primaryKey;
        }
        catch (SQLException e) {
            try {
                throw new ODataServiceFault(e, "Error in reading table primary keys in " + tableName + " table. :" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.releaseResources(resultSet, null);
                throw throwable;
            }
        }
    }

    private NavigationTable readForeignKeys(String tableName, DatabaseMetaData metaData, String catalog) throws ODataServiceFault {
        ResultSet resultSet = null;
        try {
            resultSet = metaData.getExportedKeys(catalog, null, tableName);
            NavigationTable navigationLinks = new NavigationTable();
            while (resultSet.next()) {
                String primaryKeyColumnName = resultSet.getString("PKCOLUMN_NAME");
                String foreignKeyTableName = resultSet.getString("FKTABLE_NAME");
                String foreignKeyColumnName = resultSet.getString("FKCOLUMN_NAME");
                List<NavigationKeys> columnList = navigationLinks.getNavigationKeys(foreignKeyTableName);
                if (columnList == null) {
                    columnList = new ArrayList<NavigationKeys>();
                    navigationLinks.addNavigationKeys(foreignKeyTableName, columnList);
                }
                columnList.add(new NavigationKeys(primaryKeyColumnName, foreignKeyColumnName));
            }
            NavigationTable navigationTable = navigationLinks;
            return navigationTable;
        }
        catch (SQLException e) {
            throw new ODataServiceFault(e, "Error in reading " + tableName + " table meta data. :" + e.getMessage());
        }
        finally {
            this.releaseResources(resultSet, null);
        }
    }

    @Override
    public Map<String, Map<String, DataColumn>> getTableMetadata() {
        return this.tableMetaData;
    }

    private String createUpdateEntitySQL(String tableName, ODataEntry properties) {
        List<String> pKeys = this.primaryKeys.get(tableName);
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(tableName).append(" SET ");
        boolean propertyMatch = false;
        for (String column : properties.getNames()) {
            if (pKeys.contains(column)) continue;
            if (propertyMatch) {
                sql.append(",");
            }
            sql.append(column).append(" = ").append(" ? ");
            propertyMatch = true;
        }
        sql.append(" WHERE ");
        propertyMatch = false;
        for (String key : pKeys) {
            if (propertyMatch) {
                sql.append(" AND ");
            }
            sql.append(key).append(" = ").append(" ? ");
            propertyMatch = true;
        }
        return sql.toString();
    }

    private String createInsertSQL(String tableName, ODataEntry entry) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(tableName).append(" (");
        boolean propertyMatch = false;
        for (String column : entry.getNames()) {
            if (!this.rdbmsDataTypes.get(tableName).keySet().contains(column)) continue;
            if (propertyMatch) {
                sql.append(",");
            }
            sql.append(column);
            propertyMatch = true;
        }
        sql.append(" ) VALUES ( ");
        propertyMatch = false;
        for (String column : entry.getNames()) {
            if (!this.rdbmsDataTypes.get(tableName).keySet().contains(column)) continue;
            if (propertyMatch) {
                sql.append(",");
            }
            sql.append("?");
            propertyMatch = true;
        }
        sql.append(" ) ");
        return sql.toString();
    }

    private String createReadSqlWithKeys(String tableName, ODataEntry keys) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM ").append(tableName).append(" WHERE ");
        boolean propertyMatch = false;
        for (String column : this.rdbmsDataTypes.get(tableName).keySet()) {
            if (!keys.getNames().contains(column)) continue;
            if (propertyMatch) {
                sql.append(" AND ");
            }
            sql.append(column).append(" = ").append(" ? ");
            propertyMatch = true;
        }
        return sql.toString();
    }

    private String createDeleteSQL(String tableName) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ").append(tableName).append(" WHERE ");
        List<String> pKeys = this.primaryKeys.get(tableName);
        boolean propertyMatch = false;
        for (String key : pKeys) {
            if (propertyMatch) {
                sql.append(" AND ");
            }
            sql.append(key).append(" = ").append(" ? ");
            propertyMatch = true;
        }
        return sql.toString();
    }

    private DataColumn.ODataDataType getODataDataType(int columnType) {
        DataColumn.ODataDataType dataType;
        switch (columnType) {
            case 4: {
                dataType = DataColumn.ODataDataType.INT32;
                break;
            }
            case -6: 
            case 5: {
                dataType = DataColumn.ODataDataType.INT16;
                break;
            }
            case 8: {
                dataType = DataColumn.ODataDataType.DOUBLE;
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2009: 
            case 2011: {
                dataType = DataColumn.ODataDataType.STRING;
                break;
            }
            case -7: 
            case 16: {
                dataType = DataColumn.ODataDataType.BOOLEAN;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                dataType = DataColumn.ODataDataType.BINARY;
                break;
            }
            case 91: {
                dataType = DataColumn.ODataDataType.DATE;
                break;
            }
            case 2: 
            case 3: {
                dataType = DataColumn.ODataDataType.DECIMAL;
                break;
            }
            case 6: 
            case 7: {
                dataType = DataColumn.ODataDataType.SINGLE;
                break;
            }
            case 92: {
                dataType = DataColumn.ODataDataType.TIMEOFDAY;
                break;
            }
            case -5: {
                dataType = DataColumn.ODataDataType.INT64;
                break;
            }
            case 93: {
                dataType = DataColumn.ODataDataType.DATE_TIMEOFFSET;
                break;
            }
            default: {
                dataType = DataColumn.ODataDataType.STRING;
            }
        }
        return dataType;
    }

    private Connection initializeConnection() throws SQLException {
        if (this.getTransactionalConnection() == null) {
            return this.dataSource.getConnection();
        }
        return this.getTransactionalConnection();
    }

    private void commitExecution(Connection connection) throws SQLException {
        if (this.getTransactionalConnection() == null && !connection.getAutoCommit()) {
            connection.commit();
        }
    }

    private void releaseConnection(Connection connection) {
        if (this.getTransactionalConnection() == null) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

