/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.receivers.RawXMLINOutMessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceProcessor;

public class DBInOutMessageReceiver
extends RawXMLINOutMessageReceiver {
    private static final Log log = LogFactory.getLog(DBInOutMessageReceiver.class);

    public void invokeBusinessLogic(MessageContext msgContext, MessageContext newMsgContext) throws AxisFault {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Request received to DSS:  Data Service - " + msgContext.getServiceContext().getName() + ", Operation - " + msgContext.getSoapAction() + ", Request body - " + msgContext.getEnvelope().getText() + ", ThreadID - " + Thread.currentThread().getId()));
            }
            OMElement result = DataServiceProcessor.dispatch(msgContext);
            SOAPFactory fac = this.getSOAPFactory(msgContext);
            SOAPEnvelope envelope = fac.getDefaultEnvelope();
            if (result != null) {
                envelope.getBody().addChild((OMNode)result);
            }
            newMsgContext.setEnvelope(envelope);
        }
        catch (Exception e) {
            log.error((Object)"Error in in-out message receiver", (Throwable)e);
            msgContext.setProperty("faultName", (Object)"org.wso2.carbon.dataservices.core.DataServiceFault");
            throw DBUtils.createAxisFault(e);
        }
        finally {
            if (log.isDebugEnabled()) {
                String response = msgContext.getProperty("faultName") != null && msgContext.getProperty("faultName").equals("org.wso2.carbon.dataservices.core.DataServiceFault") ? "Error in Response" : newMsgContext.getEnvelope().getText();
                log.debug((Object)("Response send from DSS:  Data Service - " + msgContext.getServiceContext().getName() + ", Operation - " + msgContext.getSoapAction() + ", Response body - " + response + ", ThreadID - " + Thread.currentThread().getId()));
            }
        }
    }
}

