/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.wso2.carbon.dataservices.core.boxcarring.RequestBox;

public class DSSessionManager {
    private static final String DS_SESSION_REQUEST_BOX_NAME = "DS_SESSION_REQUEST_BOX";
    private static final String DS_BOX_CARRING_FLAG_NAME = "DS_BOX_CARRING_FLAG";
    private static ThreadLocal<Map<String, Object>> threadLocalSession = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected synchronized Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };

    private static Object getSessionObject(String name) {
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        if (messageContext != null) {
            ServiceContext serviceContext = messageContext.getServiceContext();
            if (serviceContext != null) {
                return serviceContext.getProperty(name);
            }
        } else {
            return threadLocalSession.get().get(name);
        }
        return null;
    }

    private static void setSessionObject(String name, Object obj) {
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        if (messageContext != null) {
            ServiceContext serviceContext = messageContext.getServiceContext();
            if (serviceContext != null) {
                serviceContext.setProperty(name, obj);
            }
        } else {
            threadLocalSession.get().put(name, obj);
        }
    }

    private static void initBoxCarObject() {
        RequestBox requestBox = new RequestBox();
        DSSessionManager.setSessionObject(DS_SESSION_REQUEST_BOX_NAME, requestBox);
    }

    public static RequestBox getCurrentRequestBox() {
        RequestBox requestBox = (RequestBox)DSSessionManager.getSessionObject(DS_SESSION_REQUEST_BOX_NAME);
        if (requestBox == null) {
            DSSessionManager.initBoxCarObject();
            requestBox = (RequestBox)DSSessionManager.getSessionObject(DS_SESSION_REQUEST_BOX_NAME);
        }
        return requestBox;
    }

    public static boolean isBoxcarring() {
        Boolean boxCarring = (Boolean)DSSessionManager.getSessionObject(DS_BOX_CARRING_FLAG_NAME);
        if (boxCarring == null) {
            return false;
        }
        return boxCarring;
    }

    public static void setBoxcarring(boolean boxcarring) {
        DSSessionManager.setSessionObject(DS_BOX_CARRING_FLAG_NAME, boxcarring);
    }
}

