/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.wso2.carbon.dataservices.common.RDBMSUtils;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.SQLConfig;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.odata.ODataDataHandler;
import org.wso2.carbon.dataservices.core.odata.ODataServiceFault;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.rdbms.RDBMSConfiguration;
import org.wso2.carbon.ndatasource.rdbms.RDBMSDataSource;
import org.wso2.carbon.ndatasource.rdbms.utils.RDBMSDataSourceUtils;

public class JDBCPoolSQLConfig
extends SQLConfig {
    private DataSource dataSource;

    public JDBCPoolSQLConfig(DataService dataService, String configId, String type, Map<String, String> properties, boolean odataEnable) throws DataServiceFault {
        super(dataService, configId, type, RDBMSUtils.convertConfigPropsFromV2toV3(properties), odataEnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource getDataSource() throws DataServiceFault {
        if (this.dataSource == null) {
            JDBCPoolSQLConfig jDBCPoolSQLConfig = this;
            synchronized (jDBCPoolSQLConfig) {
                if (this.dataSource == null) {
                    try {
                        RDBMSDataSource rdbmsDS = new RDBMSDataSource(this.createConfigFromProps(this.getProperties()));
                        this.dataSource = rdbmsDS.getDataSource();
                    }
                    catch (Exception e) {
                        throw new DataServiceFault(e, "Error creating JDBC Pool SQL Config: " + e.getMessage());
                    }
                }
            }
        }
        return this.dataSource;
    }

    @Override
    public boolean isStatsAvailable() {
        return true;
    }

    @Override
    public int getActiveConnectionCount() throws DataServiceFault {
        return this.getDataSource().getActive();
    }

    @Override
    public int getIdleConnectionCount() throws DataServiceFault {
        return this.getDataSource().getIdle();
    }

    @Override
    public void close() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }

    private RDBMSConfiguration createConfigFromProps(Map<String, String> props) throws DataSourceException, XMLStreamException {
        props = new HashMap<String, String>(props);
        RDBMSConfiguration config = new RDBMSConfiguration();
        this.handleExternalDataSource(config, props);
        this.filterJDBCPoolProps(props);
        RDBMSDataSourceUtils.assignBeanProps((Object)config, new HashMap<String, String>(props));
        this.handlePostConfigInit(config);
        return config;
    }

    private void handleExternalDataSource(RDBMSConfiguration config, Map<String, String> props) throws XMLStreamException {
        String dataSourcePropsString = props.remove("dataSourceProps");
        if (dataSourcePropsString != null) {
            Map<String, String> dsProps = DBUtils.extractProperties(AXIOMUtil.stringToOM((String)dataSourcePropsString));
            ArrayList<RDBMSConfiguration.DataSourceProperty> dspList = new ArrayList<RDBMSConfiguration.DataSourceProperty>();
            for (Map.Entry<String, String> dsProp : dsProps.entrySet()) {
                RDBMSConfiguration.DataSourceProperty tmpProp = new RDBMSConfiguration.DataSourceProperty();
                tmpProp.setEncrypted(false);
                tmpProp.setName(dsProp.getKey());
                tmpProp.setValue(dsProp.getValue());
                dspList.add(tmpProp);
            }
            config.setDataSourceProps(dspList);
        }
    }

    private void filterJDBCPoolProps(Map<String, String> props) {
        props.remove("forceJDBCBatchRequests");
        props.remove("forceStoredProc");
        props.remove("queryTimeout");
        props.remove("autoCommit");
        props.remove("fetchDirection");
        props.remove("fetchSize");
        props.remove("maxFieldSize");
        props.remove("maxRows");
        props.remove("maxWait");
        props.remove("dynamicUserAuthClass");
        props.remove("dynamicUserAuthMapping");
    }

    private void handlePostConfigInit(RDBMSConfiguration config) {
        if (this.getPrimaryDynAuth() != null) {
            config.setAlternateUsernameAllowed(Boolean.valueOf(true));
        }
    }

    @Override
    public ODataDataHandler createODataHandler() throws DataServiceFault {
        throw new ODataServiceFault("Expose as OData Service feature doesn't support for the " + this.getConfigId() + " Datasource.");
    }
}

