/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.config;

import com.atomikos.jdbc.AtomikosDataSourceBean;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.wso2.carbon.dataservices.common.DBConstants;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.auth.ConfigurationBasedAuthenticator;
import org.wso2.carbon.dataservices.core.auth.DynamicUserAuthenticator;
import org.wso2.carbon.dataservices.core.description.config.Config;
import org.wso2.carbon.dataservices.core.engine.DataService;

public abstract class SQLConfig
extends Config {
    private static final Log log = LogFactory.getLog(SQLConfig.class);
    private String validationQuery = this.getProperty("validationQuery");
    private boolean jdbcBatchUpdateSupport;
    private DBConstants.AutoCommit autoCommit;
    private DynamicUserAuthenticator primaryDynAuth;
    private DynamicUserAuthenticator secondaryDynAuth;
    private static ThreadLocal<Set<XAResource>> enlistedXADataSources = new ThreadLocal<Set<XAResource>>(){

        @Override
        protected Set<XAResource> initialValue() {
            return new HashSet<XAResource>();
        }
    };

    public SQLConfig(DataService dataService, String configId, String type, Map<String, String> properties, boolean odataEnable) throws DataServiceFault {
        super(dataService, configId, type, properties, odataEnable);
        this.processAutoCommitValue();
        this.processDynamicAuth();
    }

    private void processDynamicAuth() throws DataServiceFault {
        String dynAuthClass;
        String dynAuthMapping = this.getProperty("dynamicUserAuthMapping");
        if (!DBUtils.isEmptyString(dynAuthMapping)) {
            OMElement dynUserAuthPropEl;
            try {
                dynUserAuthPropEl = AXIOMUtil.stringToOM((String)dynAuthMapping);
            }
            catch (XMLStreamException e) {
                throw new DataServiceFault(e, "Error in reading dynamic user auth mapping configuration: " + e.getMessage());
            }
            OMElement dynUserAuthConfEl = dynUserAuthPropEl.getFirstElement();
            if (dynUserAuthConfEl == null) {
                throw new DataServiceFault("Invalid dynamic user auth mapping configuration");
            }
            if (null != dynUserAuthConfEl.getFirstElement()) {
                this.primaryDynAuth = new ConfigurationBasedAuthenticator(dynUserAuthConfEl.toString());
            }
        }
        if (!DBUtils.isEmptyString(dynAuthClass = this.getProperty("dynamicUserAuthClass"))) {
            try {
                DynamicUserAuthenticator authObj = (DynamicUserAuthenticator)Class.forName(dynAuthClass).newInstance();
                if (this.primaryDynAuth == null) {
                    this.primaryDynAuth = authObj;
                } else {
                    this.secondaryDynAuth = authObj;
                }
            }
            catch (Exception e) {
                throw new DataServiceFault(e, "Error in creating dynamic user authenticator: " + e.getMessage());
            }
        }
    }

    private void processAutoCommitValue() throws DataServiceFault {
        String autoCommitProp = this.getProperty("autoCommit");
        if (!DBUtils.isEmptyString(autoCommitProp)) {
            autoCommitProp = autoCommitProp.trim();
            try {
                boolean acBool = Boolean.parseBoolean(autoCommitProp);
                if (acBool) {
                    this.autoCommit = DBConstants.AutoCommit.AUTO_COMMIT_ON;
                }
                this.autoCommit = DBConstants.AutoCommit.AUTO_COMMIT_OFF;
            }
            catch (Exception e) {
                throw new DataServiceFault(e, "Invalid autocommit value in config: " + autoCommitProp + ", autocommit should be a boolean value");
            }
        } else {
            this.autoCommit = DBConstants.AutoCommit.DEFAULT;
        }
    }

    public DynamicUserAuthenticator getPrimaryDynAuth() {
        return this.primaryDynAuth;
    }

    public DynamicUserAuthenticator getSecondaryDynAuth() {
        return this.secondaryDynAuth;
    }

    public boolean hasJDBCBatchUpdateSupport() {
        return this.jdbcBatchUpdateSupport;
    }

    public DBConstants.AutoCommit getAutoCommit() {
        return this.autoCommit;
    }

    protected void initSQLDataSource() throws SQLException, DataServiceFault {
        try (Connection conn = (Connection)this.createConnection()[0];){
            this.jdbcBatchUpdateSupport = conn.getMetaData().supportsBatchUpdates();
        }
    }

    public abstract javax.sql.DataSource getDataSource() throws DataServiceFault;

    public abstract boolean isStatsAvailable() throws DataServiceFault;

    public abstract int getActiveConnectionCount() throws DataServiceFault;

    public abstract int getIdleConnectionCount() throws DataServiceFault;

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public Object[] createConnection() throws SQLException, DataServiceFault {
        return this.createConnection(null, null);
    }

    public Object[] createConnection(String user, String pass) throws SQLException, DataServiceFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating data source connection: ThreadID - " + Thread.currentThread().getId()));
        }
        javax.sql.DataSource ds = this.getDataSource();
        Boolean xaConn = false;
        if (ds != null) {
            XAConnection xac;
            Connection conn = user != null ? ds.getConnection(user, pass) : ds.getConnection();
            Object tds = this.extractSourceDS(ds);
            boolean[] xaResult = this.isXADataSource(tds);
            xaConn = xaResult[0] | xaResult[1];
            if (xaResult[0] && !xaResult[1] && (xac = ((XADataSource)tds).getXAConnection()) != null) {
                try {
                    XAResource xaResource;
                    Transaction tx = this.getDataService().getDSSTxManager().getTransactionManager().getTransaction();
                    if (tx != null && !this.isXAResourceEnlisted(xaResource = ((XAConnection)((Object)conn)).getXAResource())) {
                        tx.enlistResource(xaResource);
                        this.addToEnlistedXADataSources(xaResource);
                    }
                }
                catch (IllegalStateException tx) {
                }
                catch (Exception e) {
                    throw new DataServiceFault(e, "Error in getting current transaction: " + e.getMessage());
                }
            }
            return new Object[]{conn, xaConn};
        }
        throw new DataServiceFault("The data source is nonexistent");
    }

    private boolean[] isXADataSource(Object tds) {
        AtomikosDataSourceBean atb;
        boolean[] result = new boolean[2];
        result[0] = tds instanceof XADataSource;
        if (tds instanceof AtomikosDataSourceBean && (atb = (AtomikosDataSourceBean)tds).getXaDataSource() != null) {
            result[1] = true;
        }
        return result;
    }

    private Object extractSourceDS(javax.sql.DataSource ds) {
        Object tds = ds;
        if (ds instanceof DataSource) {
            DataSource jpDS = (DataSource)ds;
            tds = jpDS.getDataSource();
        }
        return tds;
    }

    @Override
    public boolean isActive() {
        try {
            Connection conn = this.getDataSource().getConnection();
            conn.close();
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Error in checking SQL config availability", (Throwable)e);
            return false;
        }
    }

    private void addToEnlistedXADataSources(XAResource resource) {
        enlistedXADataSources.get().add(resource);
    }

    private boolean isXAResourceEnlisted(XAResource resource) {
        return enlistedXADataSources.get().contains(resource);
    }

    @Override
    public boolean isResultSetFieldsCaseSensitive() {
        return false;
    }
}

