/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.event;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.description.event.EventTrigger;
import org.wso2.carbon.dataservices.core.description.event.XPathEventTrigger;

public class EventTriggerSerializer {
    public static OMElement serializeEventTrigger(EventTrigger eventTrigger) {
        OMFactory fac = DBUtils.getOMFactory();
        if (eventTrigger instanceof XPathEventTrigger) {
            return EventTriggerSerializer.serializeXPathEventTrigger((XPathEventTrigger)eventTrigger, fac);
        }
        return null;
    }

    private static OMElement serializeXPathEventTrigger(XPathEventTrigger eventTrigger, OMFactory fac) {
        OMElement eventTriggerEl = fac.createOMElement(new QName("event-trigger"));
        eventTriggerEl.addAttribute("id", eventTrigger.getTriggerId(), null);
        String language = eventTrigger.getLanguage();
        if (language != null) {
            eventTriggerEl.addAttribute("language", language, null);
        }
        OMElement exprEl = fac.createOMElement(new QName("expression"));
        exprEl.setText(eventTrigger.getExpression());
        eventTriggerEl.addChild((OMNode)exprEl);
        OMElement topicEl = fac.createOMElement(new QName("target-topic"));
        topicEl.setText(eventTrigger.getTargetTopic());
        eventTriggerEl.addChild((OMNode)topicEl);
        OMElement subsEl = fac.createOMElement(new QName("subscriptions"));
        for (String epr : eventTrigger.getEndpointUrls()) {
            OMElement subEl = fac.createOMElement(new QName("subscription"));
            subEl.setText(epr);
            subsEl.addChild((OMNode)subEl);
        }
        eventTriggerEl.addChild((OMNode)subsEl);
        return eventTriggerEl;
    }
}

