/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.query;

import java.sql.Connection;
import java.sql.SQLException;
import org.wso2.carbon.dataservices.core.DataServiceConnection;
import org.wso2.carbon.dataservices.core.DataServiceFault;

public class SQLDataServicesConnection
implements DataServiceConnection {
    private Connection jdbcConn;
    private boolean isXA;

    public SQLDataServicesConnection(Connection jdbcConn, boolean isXA) {
        this.jdbcConn = jdbcConn;
        this.isXA = isXA;
    }

    @Override
    public void commit() throws DataServiceFault {
        try {
            if (!this.jdbcConn.isClosed() && !this.getAutoCommit()) {
                this.jdbcConn.commit();
            }
        }
        catch (SQLException e) {
            throw new DataServiceFault(e);
        }
    }

    @Override
    public void rollback() throws DataServiceFault {
        try {
            if (!this.jdbcConn.isClosed() && !this.getAutoCommit()) {
                this.jdbcConn.rollback();
            }
        }
        catch (SQLException e) {
            throw new DataServiceFault(e);
        }
    }

    @Override
    public void close() throws DataServiceFault {
        try {
            if (!this.jdbcConn.isClosed()) {
                this.jdbcConn.close();
            }
        }
        catch (SQLException e) {
            throw new DataServiceFault(e);
        }
    }

    @Override
    public boolean isXA() {
        return this.isXA;
    }

    public Connection getJDBCConnection() {
        return this.jdbcConn;
    }

    private boolean getAutoCommit() {
        try {
            return this.jdbcConn.getAutoCommit();
        }
        catch (SQLException ignore) {
            return true;
        }
    }

    @Override
    public String toString() {
        return "SQLDataServicesConnection , " + this.jdbcConn.toString() + ", isXA=" + this.isXA + ", autoCommit=" + this.getAutoCommit();
    }
}

