/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.databinding.types.NCName;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.dataservices.common.DBConstants;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.query.Query;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.ExternalParam;
import org.wso2.carbon.dataservices.core.engine.ExternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.OutputElement;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.engine.QueryParam;

public class CallQuery
extends OutputElement {
    private DataService dataService;
    private String queryId;
    private Query query;
    private Map<String, WithParam> withParams;

    public CallQuery(DataService dataService, String queryId, Map<String, WithParam> withParams, Set<String> requiredRoles) {
        super(null, requiredRoles);
        this.dataService = dataService;
        this.queryId = queryId;
        this.withParams = withParams;
    }

    public void init() throws DataServiceFault {
        this.query = this.getDataService().getQuery(this.getQueryId());
        if (this.query == null) {
            throw new DataServiceFault("Query with the query id: '" + this.getQueryId() + "' cannot be found");
        }
        this.setNamespace(this.getQuery().getNamespace());
    }

    public Map<String, WithParam> getWithParams() {
        return this.withParams;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public Query getQuery() {
        return this.query;
    }

    private Object evaluateGetProperty(String propName) throws DataServiceFault {
        if ("USERNAME".equals(propName)) {
            MessageContext context = MessageContext.getCurrentMessageContext();
            if (context != null) {
                return this.getDataService().getAuthorizationProvider().getUsername(context);
            }
        } else {
            if ("TENANT_ID".equals(propName)) {
                return String.valueOf(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            }
            if ("USER_ROLES".equals(propName)) {
                MessageContext context = MessageContext.getCurrentMessageContext();
                if (context != null) {
                    return this.getDataService().getAuthorizationProvider().getUserRoles(context);
                }
            } else if ("NULL".equals(propName)) {
                return null;
            }
        }
        return null;
    }

    private ParamValue evaluateDefaultValue(ParamValue paramValue, String paramType) throws DataServiceFault {
        ParamValue result;
        Object evaluatedValue;
        if (paramValue.getValueType() != 1) {
            return paramValue;
        }
        String value = paramValue.getScalarValue();
        if (value != null && value.startsWith("#{") && value.endsWith("}")) {
            String propName = value.substring(2, value.length() - 1).trim();
            evaluatedValue = this.evaluateGetProperty(propName);
        } else {
            evaluatedValue = value;
        }
        if ("ARRAY".equals(paramType)) {
            result = new ParamValue(2);
            if (evaluatedValue instanceof String[]) {
                result.setArrayValue(this.getParamValueListFromStringArray((String[])evaluatedValue));
            } else if (evaluatedValue == null) {
                result.addArrayValue(null);
            } else {
                result.setArrayValue(this.getParamValueListFromString(evaluatedValue.toString()));
            }
        } else {
            result = new ParamValue(1);
            if (evaluatedValue instanceof String[]) {
                String[] tmpArray = (String[])evaluatedValue;
                String tmpVal = null;
                if (tmpArray.length > 0) {
                    tmpVal = tmpArray[0];
                }
                result.setScalarValue(tmpVal);
            } else {
                result.setScalarValue(evaluatedValue == null ? null : evaluatedValue.toString());
            }
        }
        return result;
    }

    private List<ParamValue> getParamValueListFromString(String stringVal) {
        ArrayList<ParamValue> paramList = new ArrayList<ParamValue>(2);
        int startValue = 0;
        boolean quotesPresent = false;
        boolean escapeChar = false;
        char quoteChar = '\u0000';
        StringBuilder builder = new StringBuilder();
        block5: for (int i = 0; i < stringVal.length(); ++i) {
            char charAt = stringVal.charAt(i);
            if (!(i != startValue || quotesPresent || charAt != '\'' && charAt != '\"')) {
                quoteChar = charAt;
                quotesPresent = true;
                ++startValue;
                continue;
            }
            if (!escapeChar) {
                if (charAt == '\\') {
                    escapeChar = true;
                    continue;
                }
                if (quotesPresent && charAt == quoteChar) {
                    if (i + 1 == stringVal.length()) {
                        quotesPresent = false;
                        break;
                    }
                    if (stringVal.charAt(i + 1) == ',') {
                        paramList.add(new ParamValue(builder.toString()));
                        builder.setLength(0);
                        startValue = ++i + 1;
                        quotesPresent = false;
                        continue;
                    }
                    throw new IllegalStateException(String.format("Value started as quoted value with (') but terminated prematurely at " + i + " maybe escape (\\) is missing before ' " + "or a , Processed Value up to error point: " + stringVal.substring(startValue, i + 1), new Object[0]));
                }
                if (!quotesPresent && charAt == ',') {
                    paramList.add(new ParamValue(builder.toString()));
                    builder.setLength(0);
                    startValue = i + 1;
                    continue;
                }
                builder.append(charAt);
                continue;
            }
            escapeChar = false;
            switch (charAt) {
                case 'n': {
                    builder.append('\n');
                    continue block5;
                }
                case 'r': {
                    builder.append('\r');
                    continue block5;
                }
                case 't': {
                    builder.append('\t');
                    continue block5;
                }
                default: {
                    builder.append(charAt);
                }
            }
        }
        if (escapeChar) {
            throw new IllegalStateException("Input ended abruptly with \\");
        }
        if (quotesPresent) {
            throw new IllegalStateException("At the end there was a quote present without ending quote.");
        }
        paramList.add(new ParamValue(builder.toString()));
        return paramList;
    }

    private List<ParamValue> getParamValueListFromStringArray(String[] inputArray) {
        ArrayList<ParamValue> paramList = new ArrayList<ParamValue>(2);
        for (String value : inputArray) {
            paramList.add(new ParamValue(value));
        }
        return paramList;
    }

    private void processDefaultValues(ExternalParamCollection params) throws DataServiceFault {
        List<QueryParam> queryParams = this.getQuery().getQueryParams();
        for (QueryParam queryParam : queryParams) {
            if (queryParam.getDefaultValue() == null) continue;
            params.addTempParam(queryParam.getName(), this.evaluateDefaultValue(queryParam.getDefaultValue(), queryParam.getParamType()));
        }
    }

    @Override
    protected void executeElement(XMLStreamWriter xmlWriter, ExternalParamCollection params, int queryLevel, boolean escapeNonPrintableChar) throws DataServiceFault {
        try {
            if (this.isHasResult()) {
                this.startWrapperElement(xmlWriter, this.getNamespace(), this.getResultWrapper(), this.getQuery().getResult().getResultType());
            }
            this.processDefaultValues(params);
            Map<String, ParamValue> qparams = this.extractParams(params);
            this.getQuery().execute(xmlWriter, qparams, queryLevel);
            params.clearTempValues();
            if (this.isHasResult() && this.getResultWrapper() != null) {
                this.endElement(xmlWriter);
            }
        }
        catch (XMLStreamException e) {
            throw new DataServiceFault(e, "Error in CallQueryGroup.execute");
        }
    }

    private Map<String, ParamValue> extractParams(ExternalParamCollection params) throws DataServiceFault {
        HashMap<String, ParamValue> qparams = new HashMap<String, ParamValue>();
        for (WithParam withParam : this.getWithParams().values()) {
            String paramName = withParam.getParam();
            String paramType = withParam.getParamType();
            ExternalParam paramObj = params.getParam(paramType, paramName);
            if (paramObj == null) {
                paramObj = params.getParam(paramName);
            }
            if (paramObj != null) {
                qparams.put(withParam.getName(), paramObj.getValue());
                continue;
            }
            if (params.getTempEntries().containsKey(withParam.getName())) continue;
            throw new DataServiceFault(DBConstants.FaultCodes.INCOMPATIBLE_PARAMETERS_ERROR, "Error in 'CallQuery.extractParams', cannot find parameter with type:" + paramType + " name:" + withParam.getOriginalName());
        }
        for (Map.Entry<String, ParamValue> entry : params.getTempEntries().entrySet()) {
            String key = entry.getKey();
            if (qparams.containsKey(key)) continue;
            qparams.put(key, entry.getValue());
        }
        return qparams;
    }

    public boolean isHasResult() {
        return this.getQuery().hasResult();
    }

    public String getResultWrapper() {
        String resultWrapper = null;
        if (this.isHasResult() && (resultWrapper = this.getQuery().getResult().getElementName()) != null && resultWrapper.trim().length() == 0) {
            resultWrapper = null;
        }
        return resultWrapper;
    }

    public static class WithParam {
        private String name;
        private String originalName;
        private String param;
        private String paramType;

        public WithParam(String name, String originalName, String param, String paramType) throws DataServiceFault {
            this.name = name;
            this.originalName = originalName;
            this.param = param;
            this.paramType = paramType;
            this.validateWithParam();
        }

        private void validateWithParam() throws DataServiceFault {
            if ("query-param".equals(this.getParamType()) && !NCName.isValid((String)this.getParam())) {
                throw new DataServiceFault("Invalid query param name: '" + this.getParam() + "', must be an NCName.");
            }
        }

        public String getName() {
            return this.name;
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public String getParam() {
            return this.param;
        }

        public String getParamType() {
            return this.paramType;
        }
    }
}

