/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.engine;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.engine.CallQuery;
import org.wso2.carbon.dataservices.core.engine.ExternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.OutputElement;
import org.wso2.carbon.dataservices.core.engine.Result;
import org.wso2.carbon.dataservices.core.engine.StaticOutputElement;

public class OutputElementGroup
extends OutputElement {
    private List<StaticOutputElement> attributeEntries;
    private List<StaticOutputElement> elementEntries;
    private List<CallQuery> callQueryEntries;
    private List<OutputElementGroup> elementGroupEntries;
    private List<OutputElement> allElements;
    private Result parentResult;
    private ThreadLocal<List<StaticOutputElement>> roleAttributeEntries = new ThreadLocal();
    private ThreadLocal<List<OutputElement>> roleAllElements = new ThreadLocal();

    public OutputElementGroup(String name, String namespace, Set<String> requiredRoles, String arrayName) {
        super(name, namespace, requiredRoles, arrayName);
        this.allElements = new ArrayList<OutputElement>();
        this.elementEntries = new ArrayList<StaticOutputElement>();
        this.callQueryEntries = new ArrayList<CallQuery>();
        this.elementGroupEntries = new ArrayList<OutputElementGroup>();
        this.attributeEntries = new ArrayList<StaticOutputElement>();
    }

    public void init() throws DataServiceFault {
        for (CallQuery callQuery : this.getCallQueryEntries()) {
            callQuery.init();
        }
        for (OutputElementGroup groups : this.getOutputElementGroupEntries()) {
            groups.init();
        }
    }

    public Result getParentResult() {
        return this.parentResult;
    }

    public void setParentResult(Result parentResult) {
        this.parentResult = parentResult;
    }

    @Override
    public void executeElement(XMLStreamWriter xmlWriter, ExternalParamCollection params, int queryLevel, boolean escapeNonPrintableChar) throws DataServiceFault {
        try {
            ++queryLevel;
            if (this.getName() != null) {
                this.startWrapperElement(xmlWriter, this.getNamespace(), this.getName(), this.getParentResult().getResultType());
            }
            List<StaticOutputElement> attributes = this.getAttributeEntriesForCurrentRole();
            for (OutputElement outputElement : attributes) {
                outputElement.execute(xmlWriter, params, queryLevel, this.getParentResult().isEscapeNonPrintableChar());
            }
            List<OutputElement> elements = this.getAllElementsForCurrentRole();
            for (OutputElement oe : elements) {
                if (oe instanceof OutputElementGroup) {
                    ((OutputElementGroup)oe).applyUserRoles(oe.getRequiredRoles());
                }
                oe.execute(xmlWriter, params, queryLevel, this.getParentResult().isEscapeNonPrintableChar());
            }
            if (this.getName() != null) {
                this.endElement(xmlWriter);
            }
        }
        catch (XMLStreamException e) {
            throw new DataServiceFault(e, "Error in XML generation at OutputElementGroup.execute");
        }
    }

    public void applyUserRoles(Set<String> userRoles) {
        ArrayList<StaticOutputElement> attrs = new ArrayList<StaticOutputElement>(this.getAttributeEntries());
        Iterator attrItr = attrs.iterator();
        while (attrItr.hasNext()) {
            StaticOutputElement attr = (StaticOutputElement)attrItr.next();
            if (attr.getRequiredRoles() == null || this.rolesCompatible(userRoles, attr.getRequiredRoles())) continue;
            attrItr.remove();
        }
        this.roleAttributeEntries.set(attrs);
        ArrayList<OutputElement> els = new ArrayList<OutputElement>(this.getAllElements());
        Iterator elItr = els.iterator();
        while (elItr.hasNext()) {
            OutputElement el = (OutputElement)elItr.next();
            if (el.getRequiredRoles() == null || this.rolesCompatible(userRoles, el.getRequiredRoles())) continue;
            elItr.remove();
        }
        this.roleAllElements.set(els);
    }

    private boolean rolesCompatible(Set<String> userRoles, Set<String> requiredRoles) {
        if (requiredRoles == null || requiredRoles.size() == 0) {
            return true;
        }
        if (userRoles == null || userRoles.size() == 0) {
            return false;
        }
        HashSet<String> intersection = new HashSet<String>(userRoles);
        intersection.retainAll(requiredRoles);
        return !intersection.isEmpty();
    }

    public void addAttributeEntry(StaticOutputElement attr) throws DataServiceFault {
        if (this.getAttributeEntries().contains(attr)) {
            throw new DataServiceFault("Error while adding attributes. Cannot use same attribute name more than once");
        }
        this.getAttributeEntries().add(attr);
    }

    public void addElementEntry(StaticOutputElement el) throws DataServiceFault {
        this.getElementEntries().add(el);
        this.getAllElements().add(el);
    }

    public void addCallQueryEntry(CallQuery callQuery) {
        this.getCallQueryEntries().add(callQuery);
        this.getAllElements().add(callQuery);
    }

    public void addOutputElementGroupEntry(OutputElementGroup outputElementGroup) {
        this.getOutputElementGroupEntries().add(outputElementGroup);
        this.getAllElements().add(outputElementGroup);
    }

    public List<StaticOutputElement> getAttributeEntries() {
        return this.attributeEntries;
    }

    public List<StaticOutputElement> getElementEntries() {
        return this.elementEntries;
    }

    public List<CallQuery> getCallQueryEntries() {
        return this.callQueryEntries;
    }

    public List<OutputElementGroup> getOutputElementGroupEntries() {
        return this.elementGroupEntries;
    }

    public List<OutputElement> getAllElements() {
        return this.allElements;
    }

    public List<StaticOutputElement> getAttributeEntriesForCurrentRole() {
        return this.roleAttributeEntries.get();
    }

    public List<OutputElement> getAllElementsForCurrentRole() {
        return this.roleAllElements.get();
    }
}

