/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.odata;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataHttpHandler;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.processor.Processor;
import org.apache.olingo.server.core.OData4Impl;
import org.wso2.carbon.dataservices.core.odata.ODataAdapter;
import org.wso2.carbon.dataservices.core.odata.ODataDataHandler;
import org.wso2.carbon.dataservices.core.odata.ODataServiceFault;

public class ODataServiceHandler {
    private ODataHttpHandler handler;

    public ODataServiceHandler(ODataDataHandler dataHandler, String namespace, String configID) throws ODataServiceFault {
        ODataAdapter processor = new ODataAdapter(dataHandler, namespace, configID);
        OData odata = OData4Impl.newInstance();
        ServiceMetadata edm = odata.createServiceMetadata(processor.getEdmProvider(), new ArrayList());
        this.handler = odata.createHandler(edm);
        this.handler.register((Processor)processor);
    }

    public void process(HttpServletRequest req, HttpServletResponse resp, String serviceRootPath) {
        this.handler.process(this.modifyServletPath(req, serviceRootPath), resp);
    }

    private HttpServletRequest modifyServletPath(final HttpServletRequest req, final String serviceRootPath) {
        return new HttpServletRequest(){

            public String getAuthType() {
                return req.getAuthType();
            }

            public Cookie[] getCookies() {
                return req.getCookies();
            }

            public long getDateHeader(String s) {
                return req.getDateHeader(s);
            }

            public String getHeader(String s) {
                if ("accept".equalsIgnoreCase(s)) {
                    req.getHeader(s).equalsIgnoreCase("application/json;odata.metadata=full");
                    return "application/json";
                }
                if ("prefer".equalsIgnoreCase(s) && "post".equalsIgnoreCase(req.getMethod())) {
                    return "return=representation";
                }
                return req.getHeader(s);
            }

            public Enumeration<String> getHeaders(String s) {
                if ("accept".equalsIgnoreCase(s)) {
                    if (req.getHeader(s).equalsIgnoreCase("application/json;odata.metadata=full")) {
                        CustomEnumeration<String> enumeration = new CustomEnumeration<String>();
                        enumeration.addValues("application/json");
                        return enumeration;
                    }
                    return req.getHeaders(s);
                }
                if ("prefer".equalsIgnoreCase(s) && "post".equalsIgnoreCase(req.getMethod()) && req.getHeader("accept").equalsIgnoreCase("application/json;odata.metadata=full")) {
                    CustomEnumeration<String> enumeration = new CustomEnumeration<String>();
                    enumeration.addValues("return=representation");
                    return enumeration;
                }
                return req.getHeaders(s);
            }

            public Enumeration<String> getHeaderNames() {
                if ("post".equalsIgnoreCase(req.getMethod()) && req.getHeader("accept").equalsIgnoreCase("application/json;odata.metadata=full")) {
                    CustomEnumeration<String> headerNames = new CustomEnumeration<String>(req.getHeaderNames());
                    headerNames.addValues("prefer");
                    return headerNames;
                }
                return req.getHeaderNames();
            }

            public int getIntHeader(String s) {
                return req.getIntHeader(s);
            }

            public String getMethod() {
                return req.getMethod();
            }

            public String getPathInfo() {
                return req.getPathInfo();
            }

            public String getPathTranslated() {
                return req.getPathTranslated();
            }

            public String getContextPath() {
                return req.getContextPath();
            }

            public String getQueryString() {
                return req.getQueryString();
            }

            public String getRemoteUser() {
                return req.getRemoteUser();
            }

            public boolean isUserInRole(String s) {
                return req.isUserInRole(s);
            }

            public Principal getUserPrincipal() {
                return req.getUserPrincipal();
            }

            public String getRequestedSessionId() {
                return req.getRequestedSessionId();
            }

            public String getRequestURI() {
                return req.getRequestURI();
            }

            public StringBuffer getRequestURL() {
                return req.getRequestURL();
            }

            public String getServletPath() {
                return req.getServletPath() + serviceRootPath;
            }

            public HttpSession getSession(boolean b) {
                return req.getSession(b);
            }

            public HttpSession getSession() {
                return req.getSession();
            }

            public boolean isRequestedSessionIdValid() {
                return req.isRequestedSessionIdValid();
            }

            public boolean isRequestedSessionIdFromCookie() {
                return req.isRequestedSessionIdFromCookie();
            }

            public boolean isRequestedSessionIdFromURL() {
                return req.isRequestedSessionIdFromURL();
            }

            public boolean isRequestedSessionIdFromUrl() {
                return req.isRequestedSessionIdFromUrl();
            }

            public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
                return req.authenticate(httpServletResponse);
            }

            public void login(String s, String s1) throws ServletException {
                req.login(s, s1);
            }

            public void logout() throws ServletException {
                req.logout();
            }

            public Collection<Part> getParts() throws IOException, IllegalStateException, ServletException {
                return req.getParts();
            }

            public Part getPart(String s) throws IOException, IllegalStateException, ServletException {
                return req.getPart(s);
            }

            public Object getAttribute(String s) {
                return req.getAttribute(s);
            }

            public Enumeration<String> getAttributeNames() {
                return req.getAttributeNames();
            }

            public String getCharacterEncoding() {
                return req.getCharacterEncoding();
            }

            public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
                req.setCharacterEncoding(s);
            }

            public int getContentLength() {
                return req.getContentLength();
            }

            public String getContentType() {
                return req.getContentType();
            }

            public ServletInputStream getInputStream() throws IOException {
                return req.getInputStream();
            }

            public String getParameter(String s) {
                return req.getParameter(s);
            }

            public Enumeration<String> getParameterNames() {
                return req.getParameterNames();
            }

            public String[] getParameterValues(String s) {
                return req.getParameterValues(s);
            }

            public Map<String, String[]> getParameterMap() {
                return req.getParameterMap();
            }

            public String getProtocol() {
                return req.getProtocol();
            }

            public String getScheme() {
                return req.getScheme();
            }

            public String getServerName() {
                return req.getServerName();
            }

            public int getServerPort() {
                return req.getServerPort();
            }

            public BufferedReader getReader() throws IOException {
                return req.getReader();
            }

            public String getRemoteAddr() {
                return req.getRemoteAddr();
            }

            public String getRemoteHost() {
                return req.getRemoteHost();
            }

            public void setAttribute(String s, Object o) {
                req.setAttribute(s, o);
            }

            public void removeAttribute(String s) {
                req.removeAttribute(s);
            }

            public Locale getLocale() {
                return req.getLocale();
            }

            public Enumeration<Locale> getLocales() {
                return req.getLocales();
            }

            public boolean isSecure() {
                return req.isSecure();
            }

            public RequestDispatcher getRequestDispatcher(String s) {
                return req.getRequestDispatcher(s);
            }

            public String getRealPath(String s) {
                return req.getRealPath(s);
            }

            public int getRemotePort() {
                return req.getRemotePort();
            }

            public String getLocalName() {
                return req.getLocalName();
            }

            public String getLocalAddr() {
                return req.getLocalAddr();
            }

            public int getLocalPort() {
                return req.getLocalPort();
            }

            public ServletContext getServletContext() {
                return req.getServletContext();
            }

            public AsyncContext startAsync() {
                return req.startAsync();
            }

            public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
                return req.startAsync(servletRequest, servletResponse);
            }

            public boolean isAsyncStarted() {
                return req.isAsyncStarted();
            }

            public boolean isAsyncSupported() {
                return req.isAsyncSupported();
            }

            public AsyncContext getAsyncContext() {
                return req.getAsyncContext();
            }

            public DispatcherType getDispatcherType() {
                return req.getDispatcherType();
            }
        };
    }

    private class CustomEnumeration<E>
    implements Enumeration<E> {
        private Enumeration<E> enumeration = null;
        private ArrayList<E> arrayList = new ArrayList();
        private int pos = -1;

        CustomEnumeration(Enumeration<E> e) {
            this.enumeration = e;
        }

        CustomEnumeration() {
        }

        public void addValues(E ob) {
            this.arrayList.add(ob);
        }

        @Override
        public boolean hasMoreElements() {
            return this.pos < this.arrayList.size() - 1 || this.enumeration != null && this.enumeration.hasMoreElements();
        }

        @Override
        public E nextElement() {
            if (this.enumeration != null && this.enumeration.hasMoreElements()) {
                return this.enumeration.nextElement();
            }
            if (this.pos < this.arrayList.size() - 1) {
                ++this.pos;
                return this.arrayList.get(this.pos);
            }
            return null;
        }
    }
}

