/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.odata;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.dataservices.core.internal.DataServicesDSComponent;
import org.wso2.carbon.dataservices.core.odata.ODataServiceFault;
import org.wso2.carbon.dataservices.core.odata.ODataServiceHandler;
import org.wso2.carbon.utils.ConfigurationContextService;

public class ODataServiceRegistry {
    private static Log log = LogFactory.getLog(ODataServiceRegistry.class);
    private static ODataServiceRegistry instance;
    private Map<String, ConcurrentHashMap<String, ODataServiceHandler>> registry = new ConcurrentHashMap<String, ConcurrentHashMap<String, ODataServiceHandler>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ODataServiceRegistry getInstance() {
        if (instance != null) return instance;
        Class<ODataServiceRegistry> clazz = ODataServiceRegistry.class;
        synchronized (ODataServiceRegistry.class) {
            if (instance != null) return instance;
            instance = new ODataServiceRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void registerODataService(String dataServiceName, ODataServiceHandler handler, String tenantDomain) {
        ConcurrentHashMap<String, ODataServiceHandler> oDataServiceHandlerMap = this.registry.get(tenantDomain);
        if (oDataServiceHandlerMap == null) {
            oDataServiceHandlerMap = new ConcurrentHashMap();
            this.registry.put(tenantDomain, oDataServiceHandlerMap);
        }
        oDataServiceHandlerMap.putIfAbsent(dataServiceName, handler);
    }

    public ODataServiceHandler getServiceHandler(String serviceKey, String tenantDomain) {
        if (null == this.registry.get(tenantDomain) && !"carbon.super".equals(tenantDomain)) {
            try {
                ConfigurationContextService contextService = DataServicesDSComponent.getContextService();
                if (null == contextService) {
                    throw new ODataServiceFault("ConfigurationContext is not found.");
                }
                ConfigurationContext configContext = contextService.getServerConfigContext();
                TenantAxisUtils.getTenantConfigurationContext((String)tenantDomain, (ConfigurationContext)configContext);
            }
            catch (Exception e) {
                log.error((Object)"ConfigurationContext is not found.", (Throwable)e);
            }
        }
        if (this.registry.get(tenantDomain) != null) {
            return this.registry.get(tenantDomain).get(serviceKey);
        }
        return null;
    }

    public void removeODataService(String tenantDomain, String serviceName) {
        this.registry.get(tenantDomain).remove(serviceName);
    }
}

