/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.odata;

import java.util.UUID;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.core.Encoder;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.commons.core.edm.primitivetype.EdmString;
import org.wso2.carbon.dataservices.core.odata.ODataEntry;

public class ODataUtils {
    public static String generateETag(String configID, String tableName, ODataEntry entry) {
        StringBuilder uniqueString = new StringBuilder();
        uniqueString.append(configID).append(tableName);
        for (String columnName : entry.getNames()) {
            uniqueString.append(columnName).append(entry.getValue(columnName));
        }
        return UUID.nameUUIDFromBytes(uniqueString.toString().getBytes()).toString();
    }

    public static String buildLocation(String baseURL, Entity entity, String enitySetName, EdmEntityType type) throws EdmPrimitiveTypeException {
        StringBuilder location = new StringBuilder();
        location.append(baseURL).append("/").append(enitySetName);
        int i = 0;
        boolean usename = type.getKeyPredicateNames().size() > 1;
        location.append("(");
        for (String key : type.getKeyPredicateNames()) {
            if (i > 0) {
                location.append(",");
            }
            ++i;
            if (usename) {
                location.append(key).append("=");
            }
            String propertyType = entity.getProperty(key).getType();
            Object propertyValue = entity.getProperty(key).getValue();
            if (propertyType.startsWith("Edm.")) {
                propertyType = propertyType.substring(4);
            }
            EdmPrimitiveTypeKind kind = EdmPrimitiveTypeKind.valueOf((String)propertyType);
            EdmProperty property = type.getStructuralProperty(key);
            String value = EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)kind).valueToString(propertyValue, Boolean.valueOf(property.isNullable()), property.getMaxLength(), property.getPrecision(), property.getScale(), Boolean.valueOf(property.isUnicode()));
            if (kind == EdmPrimitiveTypeKind.String) {
                value = EdmString.getInstance().toUriLiteral(Encoder.encode((String)value));
            }
            location.append(value);
        }
        location.append(")");
        return location.toString();
    }
}

