/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.tools;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFactory;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.DataServiceUser;
import org.wso2.carbon.dataservices.core.description.resource.Resource;
import org.wso2.carbon.dataservices.core.dispatch.BatchDataServiceRequest;
import org.wso2.carbon.dataservices.core.dispatch.BoxcarringDataServiceRequest;
import org.wso2.carbon.dataservices.core.dispatch.DataServiceRequest;
import org.wso2.carbon.dataservices.core.dispatch.SingleDataServiceRequest;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.DataServiceSerializer;
import org.wso2.carbon.dataservices.core.engine.ParamValue;

public class DSTools {
    public static DataService createDataService(OMElement dbsElement, String dsLocation) throws DataServiceFault {
        return DataServiceFactory.createDataService(dbsElement, dsLocation);
    }

    public static OMElement serializeDataService(DataService dataService) {
        return DataServiceSerializer.serializeDataService(dataService);
    }

    public static void setDataServicesUser(DataServiceUser user) {
        DataService.setCurrentUser(user);
    }

    public static void beginBoxcar(DataService dataService) throws DataServiceFault {
        DSTools.callBoxcarringOp(dataService, "begin_boxcar", new HashMap<String, ParamValue>());
    }

    public static OMElement endBoxcar(DataService dataService) throws DataServiceFault {
        return DSTools.callBoxcarringOp(dataService, "end_boxcar", new HashMap<String, ParamValue>());
    }

    public static void abortBoxcar(DataService dataService) throws DataServiceFault {
        DSTools.callBoxcarringOp(dataService, "abort_boxcar", new HashMap<String, ParamValue>());
    }

    private static OMElement callBoxcarringOp(DataService dataService, String opName, Map<String, ParamValue> params) throws DataServiceFault {
        return new BoxcarringDataServiceRequest(new SingleDataServiceRequest(dataService, opName, params)).dispatch();
    }

    public static OMElement invokeOperation(DataService dataService, String operationName, Map<String, ParamValue> params) throws DataServiceFault {
        if (DataServiceRequest.isBoxcarringRequest(operationName)) {
            return DSTools.callBoxcarringOp(dataService, operationName, params);
        }
        OMElement result = new SingleDataServiceRequest(dataService, operationName, params).dispatch();
        if (result == null) {
            return null;
        }
        OMDocument doc = DBUtils.getOMFactory().createOMDocument();
        doc.addChild((OMNode)result);
        return doc.getOMDocumentElement();
    }

    public static void invokeOperation(DataService dataService, String operationName, List<Map<String, ParamValue>> batchParams) throws DataServiceFault {
        new BatchDataServiceRequest(dataService, operationName + "_batch_req", batchParams).dispatch();
    }

    public static OMElement accessResource(DataService dataService, String resourcePath, Map<String, ParamValue> params, String accessMethod) throws DataServiceFault {
        OMElement result = new SingleDataServiceRequest(dataService, Resource.generateRequestName(resourcePath, accessMethod), params).dispatch();
        OMDocument doc = DBUtils.getOMFactory().createOMDocument();
        doc.addChild((OMNode)result);
        return doc.getOMDocumentElement();
    }
}

