/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.validation.standard;

import java.util.List;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.validation.ValidationContext;
import org.wso2.carbon.dataservices.core.validation.ValidationException;
import org.wso2.carbon.dataservices.core.validation.Validator;

public abstract class GenericValidator
implements Validator {
    private String message;

    public GenericValidator(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public void validate(ValidationContext context, String name, ParamValue value) throws ValidationException {
        if (value.getValueType() == 1) {
            if (!this.validateScalar(value.getScalarValue())) {
                throw new ValidationException(this.getMessage(), name, value);
            }
        } else if (value.getValueType() == 2) {
            List<ParamValue> arrayVal = value.getArrayValue();
            int n = arrayVal.size();
            for (int i = 0; i < n; ++i) {
                if (this.validateScalar(arrayVal.get(i).toString())) continue;
                throw new ValidationException(this.getMessage() + " at array index " + i, name, value);
            }
        }
    }

    protected abstract boolean validateScalar(String var1);
}

