/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.java2wsdl.TypeTable;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.dataservices.common.RDBMSUtils;
import org.wso2.carbon.dataservices.core.DBDeployer;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.auth.AuthorizationProvider;
import org.wso2.carbon.dataservices.core.auth.UserStoreAuthorizationProvider;
import org.wso2.carbon.dataservices.core.description.config.Config;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.ExternalParam;
import org.wso2.carbon.dataservices.core.engine.ExternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.InternalParam;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.internal.DataServicesDSComponent;
import org.wso2.carbon.ndatasource.core.utils.DataSourceUtils;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.wso2.carbon.utils.xml.XMLPrettyPrinter;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class DBUtils {
    private static final Log log = LogFactory.getLog(DBUtils.class);
    private static Pattern udtPattern = Pattern.compile("(.*?(\\[\\d+\\]))");
    private static ScheduledExecutorService globalExecutorService = Executors.newSingleThreadScheduledExecutor();
    private static HashMap<String, String> conversionTypes = null;
    private static HashMap<String, String> xsdSqlTypeMap = null;
    private static SecretResolver secretResolver;
    private static XMLOutputFactory xmlOutputFactory;
    private static XMLInputFactory xmlInputFactory;
    private static OMFactory omFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map loadFactoryProperties(String name) {
        ClassLoader classLoader = DBUtils.class.getClassLoader();
        InputStream in = classLoader.getResourceAsStream(name);
        if (in == null) {
            return null;
        }
        try {
            Properties rawProps = new Properties();
            HashMap<Object, Object> props = new HashMap<Object, Object>();
            rawProps.load(in);
            Object object = rawProps.entrySet().iterator();
            while (object.hasNext()) {
                Object value;
                String strValue;
                Map.Entry<Object, Object> objectObjectEntry;
                Map.Entry<Object, Object> entry = objectObjectEntry = object.next();
                switch (strValue = (String)entry.getValue()) {
                    case "true": {
                        value = Boolean.TRUE;
                        break;
                    }
                    case "false": {
                        value = Boolean.FALSE;
                        break;
                    }
                    default: {
                        try {
                            value = Integer.valueOf(strValue);
                            break;
                        }
                        catch (NumberFormatException ex) {
                            value = strValue;
                        }
                    }
                }
                props.put(entry.getKey(), value);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loaded factory properties from " + name + ": " + props));
            }
            object = props;
            return object;
        }
        catch (IOException e) {
            log.error((Object)("Failed to read from: " + name), (Throwable)e);
            Map map = null;
            return map;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                log.error((Object)("Failed to close the input stream of: " + name), (Throwable)e);
            }
        }
    }

    public static XMLOutputFactory getXMLOutputFactory() {
        return xmlOutputFactory;
    }

    public static XMLInputFactory getXMLInputFactory() {
        return xmlInputFactory;
    }

    public static OMFactory getOMFactory() {
        return omFactory;
    }

    public static String getJavaTypeFromSQLType(String sqlType) {
        return conversionTypes.get(sqlType);
    }

    public static String getSQLTypeFromXsdType(String xsdType) {
        String sqlType = xsdSqlTypeMap.get(xsdType);
        if (sqlType == null) {
            sqlType = "STRING";
        }
        return sqlType;
    }

    public static String getCurrentContextUsername(DataService dataService) {
        MessageContext ctx = MessageContext.getCurrentMessageContext();
        if (ctx != null) {
            try {
                return dataService.getAuthorizationProvider().getUsername(ctx);
            }
            catch (DataServiceFault dataServiceFault) {
                return null;
            }
        }
        return null;
    }

    public static String[] getUserRoles(String username) throws DataServiceFault {
        RealmService realmService = DataServicesDSComponent.getRealmService();
        RegistryService registryService = DataServicesDSComponent.getRegistryService();
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            if (tenantId < -1234) {
                tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
            }
            if (tenantId < -1234) {
                log.error((Object)("The tenant doesn't exist. Tenant domain:" + tenantDomain));
                throw new DataServiceFault("Access Denied. You are not authorized.");
            }
            if (tenantId != -1234) {
                username = MultitenantUtils.getTenantAwareUsername((String)username);
            }
            if (!realmService.getTenantManager().isTenantActive(tenantId)) {
                log.error((Object)("The tenant is not active. Tenant domain:" + tenantDomain));
                throw new DataServiceFault("The tenant is not active. Tenant domain:" + tenantDomain);
            }
            UserRealm realm = registryService.getUserRealm(tenantId);
            String[] roles = realm.getUserStoreManager().getRoleListOfUser(username);
            return roles;
        }
        catch (Exception e) {
            String msg = "Error in retrieving the realm for the tenant id: " + tenantId + ", username: " + username + ". " + e.getMessage();
            throw new DataServiceFault(msg);
        }
    }

    public static String[] getAllRoles(int tenantId) throws DataServiceFault {
        RegistryService registryService = DataServicesDSComponent.getRegistryService();
        try {
            UserRealm realm = registryService.getUserRealm(tenantId);
            String[] roles = realm.getUserStoreManager().getRoleNames();
            return roles;
        }
        catch (Exception e) {
            String msg = "Error in retrieving the realm for the tenant id: " + tenantId + ". " + e.getMessage();
            throw new DataServiceFault(msg);
        }
    }

    public static int getCurrentUserTenantId() throws DataServiceFault {
        RealmService realmService = DataServicesDSComponent.getRealmService();
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            if (tenantId < -1234) {
                tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
            }
            if (tenantId < -1234) {
                log.error((Object)("The tenant doesn't exist. Tenant domain:" + tenantDomain));
                throw new DataServiceFault("Access Denied. You are not authorized.");
            }
            if (!realmService.getTenantManager().isTenantActive(tenantId)) {
                log.error((Object)("The tenant is not active. Tenant domain:" + tenantDomain));
                throw new DataServiceFault("The tenant is not active. Tenant domain:" + tenantDomain);
            }
            return tenantId;
        }
        catch (Exception e) {
            String msg = "Error in retrieving the realm for the tenant id: " + tenantId + ". " + e.getMessage();
            throw new DataServiceFault(msg);
        }
    }

    public static boolean authenticate(String username, String password) throws DataServiceFault {
        try {
            RegistryService registryService = DataServicesDSComponent.getRegistryService();
            UserRealm realm = registryService.getUserRealm(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            username = MultitenantUtils.getTenantAwareUsername((String)username);
            return realm.getUserStoreManager().authenticate(username, (Object)password);
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in authenticating user '" + username + "'");
        }
    }

    public static String[] getAvailableDS(AxisConfiguration axisConfiguration) throws AxisFault {
        ArrayList<String> serviceList = new ArrayList<String>();
        HashMap map = axisConfiguration.getServices();
        Set set = map.keySet();
        for (String serviceName : set) {
            AxisService axisService = axisConfiguration.getService(serviceName);
            Parameter parameter = axisService.getParameter("serviceType");
            if (parameter == null || !"data_service".equals(parameter.getValue().toString())) continue;
            serviceList.add(serviceName);
        }
        return serviceList.toArray(new String[serviceList.size()]);
    }

    public static boolean isAvailableDS(AxisConfiguration axisConfiguration, String dataService) throws AxisFault {
        Parameter parameter;
        HashMap map = axisConfiguration.getServices();
        AxisService axisService = (AxisService)map.get(dataService);
        return axisService != null && (parameter = axisService.getParameter("serviceType")) != null && "data_service".equals(parameter.getValue().toString());
    }

    public static boolean isAvailableDSServiceGroup(AxisConfiguration axisConfiguration, String dataServiceGroup) throws AxisFault {
        Iterator map = axisConfiguration.getServiceGroups();
        while (map.hasNext()) {
            AxisServiceGroup serviceGroup = (AxisServiceGroup)map.next();
            if (!serviceGroup.getServiceGroupName().equals(dataServiceGroup)) continue;
            return true;
        }
        return false;
    }

    public static AxisService getActiveAxisServiceAccordingToDataServiceGroup(AxisConfiguration axisConfiguration, String serviceName) throws AxisFault {
        AxisService service;
        String[] splitArray;
        Iterator map = axisConfiguration.getServiceGroups();
        AxisServiceGroup serviceGroup = null;
        while (map.hasNext() && !(serviceGroup = (AxisServiceGroup)map.next()).getServiceGroupName().equals(serviceName)) {
            serviceGroup = null;
        }
        if (serviceName.contains("/") && (splitArray = serviceName.split("\\/")).length >= 1) {
            serviceName = splitArray[splitArray.length - 1];
        }
        if (serviceGroup != null && (service = serviceGroup.getService(serviceName)) != null && service.isActive()) {
            return service;
        }
        return null;
    }

    public static boolean isRegistryPath(String path) {
        return path.startsWith("conf:") || path.startsWith("gov:");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InputStream getInputStreamFromPath(String path) throws IOException, DataServiceFault {
        if (path.startsWith("http://")) {
            URL url = new URL(path);
            return url.openStream();
        }
        if (DBUtils.isRegistryPath(path)) {
            try {
                UserRegistry registry;
                RegistryService registryService = DataServicesDSComponent.getRegistryService();
                if (registryService == null) {
                    throw new DataServiceFault("DBUtils.getInputStreamFromPath(): Registry service is not available");
                }
                if (path.startsWith("conf:")) {
                    if (path.length() <= "conf:".length()) throw new DataServiceFault("Empty configuration registry path given");
                    path = path.substring("conf:".length());
                    registry = registryService.getConfigSystemRegistry(DBUtils.getCurrentTenantId());
                } else {
                    if (path.length() <= "gov:".length()) throw new DataServiceFault("Empty governance registry path given");
                    path = path.substring("gov:".length());
                    registry = registryService.getGovernanceSystemRegistry(DBUtils.getCurrentTenantId());
                }
                if (!registry.resourceExists(path)) throw new DataServiceFault("The given XSLT resource path at '" + path + "' does not exist");
                Resource serviceResource = registry.get(path);
                return serviceResource.getContentStream();
            }
            catch (RegistryException e) {
                String msg = "Error in retrieving the resource: " + path;
                throw new DataServiceFault(e, msg);
            }
        }
        File csvFile = new File(path);
        if (!path.startsWith("." + File.separator)) {
            if (!path.startsWith(".." + File.separator)) return new FileInputStream(path);
        }
        path = csvFile.getAbsolutePath();
        return new FileInputStream(path);
    }

    public static Map<Integer, String> createColumnMappings(String[] header) throws IOException {
        HashMap<Integer, String> mappings = null;
        if (header != null) {
            mappings = new HashMap();
            for (int i = 0; i < header.length; ++i) {
                mappings.put(i + 1, header[i]);
            }
        } else {
            mappings = new StringNumberMap();
        }
        return mappings;
    }

    public static String getStacktraceFromException(Throwable e) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(byteOut);
        e.printStackTrace(writer);
        writer.close();
        String message = new String(byteOut.toByteArray());
        return message;
    }

    public static int getOptimalRSFetchSizeForRDBMS(String jdbcUrl) {
        if (jdbcUrl == null) {
            return 1;
        }
        String rdbms = RDBMSUtils.getRDBMSEngine((String)jdbcUrl);
        if (rdbms.equals("mysql")) {
            return Integer.MIN_VALUE;
        }
        return 1;
    }

    public static boolean getChangeFetchSizeForRDBMS(String jdbcUrl) {
        if (jdbcUrl == null) {
            return false;
        }
        String rdbms = RDBMSUtils.getRDBMSEngine((String)jdbcUrl);
        return rdbms.equals("mysql");
    }

    public static Timestamp getTimestamp(String value) throws DataServiceFault, ParseException {
        if (value == null || value.isEmpty()) {
            throw new DataServiceFault("Empty string or null value was found as timeStamp.");
        }
        return new Timestamp(ConverterUtil.convertToDateTime((String)value).getTimeInMillis());
    }

    public static Time getTime(String value) throws DataServiceFault, ParseException {
        if (value == null || value.isEmpty()) {
            throw new DataServiceFault("Empty string or null value was found as time.");
        }
        return new Time(ConverterUtil.convertToTime((String)value).getAsCalendar().getTimeInMillis());
    }

    public static java.sql.Date getDate(String value) throws DataServiceFault {
        try {
            Date date = ConverterUtil.convertToDate((String)value);
            if (null == date) {
                throw new DataServiceFault("Empty string or null value was found as date.");
            }
            return new java.sql.Date(date.getTime());
        }
        catch (Exception e) {
            Calendar calendarDate = ConverterUtil.convertToDateTime((String)value);
            if (null == calendarDate) {
                throw new DataServiceFault("Empty string or null value was found as date.");
            }
            return new java.sql.Date(calendarDate.getTimeInMillis());
        }
    }

    public static String prettifyXML(String xmlContent) {
        Element element = DataSourceUtils.stringToElement((String)xmlContent);
        if (element == null) {
            throw new RuntimeException("Error in converting string to XML: " + xmlContent);
        }
        DBUtils.removeWhitespaceInMixedContentElements(element);
        xmlContent = DataSourceUtils.elementToString((Element)element);
        ByteArrayInputStream byteIn = new ByteArrayInputStream(xmlContent.getBytes());
        XMLPrettyPrinter prettyPrinter = new XMLPrettyPrinter((InputStream)byteIn);
        return prettyPrinter.xmlFormat().trim();
    }

    private static List<Node> getNodesAsList(Element element) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        int count = nodeList.getLength();
        for (int i = 0; i < count; ++i) {
            nodes.add(nodeList.item(i));
        }
        return nodes;
    }

    private static List<Element> getChildElements(Element element) {
        ArrayList<Element> childEls = new ArrayList<Element>();
        for (Node tmpNode : DBUtils.getNodesAsList(element)) {
            if (tmpNode.getNodeType() != 1) continue;
            childEls.add((Element)tmpNode);
        }
        return childEls;
    }

    private static List<Node> getWhitespaceNodes(Element element) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node node : DBUtils.getNodesAsList(element)) {
            if (node.getNodeType() != 3 || node.getNodeValue().trim().length() != 0) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private static void removeWhitespaceInMixedContentElements(Element element) {
        List<Element> childEls = DBUtils.getChildElements(element);
        if (childEls.size() > 0) {
            for (Node node : DBUtils.getWhitespaceNodes(element)) {
                element.removeChild(node);
            }
            for (Element childEl : childEls) {
                DBUtils.removeWhitespaceInMixedContentElements(childEl);
            }
        }
    }

    public static void prettifyXMLFile(String filePath) throws IOException, URISyntaxException {
        File file = new File(new URI(filePath).normalize().toString());
        String prettyXML = DBUtils.prettifyXML(FileUtils.readFileToString((File)file));
        FileUtils.writeStringToFile((File)file, (String)prettyXML);
    }

    public static String encodeBase64(String value) {
        try {
            return new String(Base64.encodeBase64((byte[])value.getBytes("UTF-8")), "UTF-8");
        }
        catch (UnsupportedEncodingException ueo) {
            throw new RuntimeException(ueo);
        }
    }

    public static AxisFault createAxisFault(Exception e) {
        Throwable cause = e.getCause();
        AxisFault fault = cause != null ? new AxisFault(e.getMessage(), cause) : new AxisFault(e.getMessage());
        fault.setDetail(DataServiceFault.extractFaultMessage(e));
        fault.setFaultCode(new QName("http://ws.wso2.org/dataservice", DataServiceFault.extractFaultCode(e)));
        return fault;
    }

    public static OMElement createDSFaultOM(String msg) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement ele = fac.createOMElement(new QName("http://ws.wso2.org/dataservice", "DataServiceFault"));
        ele.setText(msg);
        return ele;
    }

    public static String evaluateString(String source, ExternalParamCollection params) throws DataServiceFault {
        StringBuilder builder = new StringBuilder();
        int leftBracketIndex = source.indexOf(123, 0);
        int rightBracketIndex = source.indexOf(125, leftBracketIndex);
        if (leftBracketIndex == -1 || rightBracketIndex == -1) {
            throw new DataServiceFault("The source string: " + source + " is not parameterized.");
        }
        String paramName = source.substring(leftBracketIndex + 1, rightBracketIndex);
        ExternalParam exParam = params.getParam(paramName = paramName.toLowerCase());
        if (exParam == null) {
            throw new DataServiceFault("The parameter: " + paramName + " cannot be found for the source string: " + source);
        }
        String paramValue = exParam.getValue().getValueAsString();
        builder.append(source.subSequence(0, leftBracketIndex));
        builder.append(paramValue);
        builder.append(source.substring(rightBracketIndex + 1));
        return builder.toString();
    }

    public static void scheduleTask(Runnable task, long delay) {
        globalExecutorService.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    public static boolean isEmptyString(String text) {
        return text == null || text.trim().length() <= 0;
    }

    public static String resolvePasswordValue(DataService dataService, String password) {
        SecretResolver secretResolver = dataService.getSecretResolver();
        if (secretResolver != null && secretResolver.isTokenProtected(password)) {
            return secretResolver.resolve(password);
        }
        return password;
    }

    public static int getCurrentTenantId() {
        try {
            int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            if (tenantId == -1) {
                throw new RuntimeException("Tenant id cannot be -1");
            }
            return tenantId;
        }
        catch (NoClassDefFoundError e) {
            return -1234;
        }
        catch (ExceptionInInitializerError e) {
            return -1234;
        }
    }

    public static QName getSimpleSchemaTypeName(TypeTable typeTable, String typeName) {
        if (typeName.equals("java.net.URI")) {
            return new QName("http://www.w3.org/2001/XMLSchema", "anyURI");
        }
        if (typeName.equals("java.sql.Struct")) {
            return new QName("http://www.w3.org/2001/XMLSchema", "anyType");
        }
        return typeTable.getSimpleSchemaTypeName(typeName);
    }

    public static Map<String, String> extractProperties(OMElement propsParentEl) {
        HashMap<String, String> properties = new HashMap<String, String>();
        OMElement propEl = null;
        Iterator itr = propsParentEl.getChildrenWithName(new QName("property"));
        while (itr.hasNext()) {
            propEl = (OMElement)itr.next();
            String text = propEl.getChildElements().hasNext() ? propEl.toString() : propEl.getText();
            if (text == null || text.equals("")) continue;
            properties.put(propEl.getAttributeValue(new QName("name")), text);
        }
        return properties;
    }

    public static TransactionManager getContainerTransactionManager(String txManagerJNDIName) throws DataServiceFault {
        TransactionManager txManager = null;
        if (txManagerJNDIName != null) {
            try {
                txManager = (TransactionManager)InitialContext.doLookup(txManagerJNDIName);
            }
            catch (Exception e) {
                throw new DataServiceFault(e, "Cannot find TransactionManager with the given JNDI name '" + txManagerJNDIName + "'");
            }
        }
        txManager = DBDeployer.getCachedTransactionManager();
        return txManager;
    }

    public static OMElement cloneAndReturnBuiltElement(OMElement result) {
        StAXOMBuilder builder = new StAXOMBuilder(result.getXMLStreamReaderWithoutCaching());
        result = builder.getDocumentElement();
        result.build();
        return result;
    }

    public static Queue<String> getTokens(String param) {
        boolean isString = false;
        LinkedBlockingQueue<String> tokens = new LinkedBlockingQueue<String>();
        char[] chars = param.toCharArray();
        StringBuilder columnName = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            Character c = Character.valueOf(chars[i]);
            if (!(".".equals(c.toString()) || "[".equals(c.toString()) || "]".equals(c.toString()))) {
                isString = true;
                columnName.append(c.toString());
                if (i != chars.length - 1) continue;
                tokens.add(columnName.toString());
                continue;
            }
            if (isString) {
                tokens.add(columnName.toString());
                columnName = new StringBuilder();
                isString = false;
            }
            tokens.add(c.toString());
        }
        return tokens;
    }

    public static void getSyntaxEmbeddedQueue(Queue<String> tokens, Queue<String> syntaxQueue, boolean isIndex) {
        if (!tokens.isEmpty()) {
            if ("[".equals(tokens.peek())) {
                isIndex = true;
                tokens.poll();
                syntaxQueue.add("INEDX_START");
                syntaxQueue.add(tokens.poll());
            } else if ("]".equals(tokens.peek())) {
                isIndex = false;
                tokens.poll();
                syntaxQueue.add("INDEX_END");
            } else if (".".equals(tokens.peek())) {
                tokens.poll();
                syntaxQueue.add("DOT");
                syntaxQueue.add("COLUMN");
                syntaxQueue.add(tokens.poll());
            } else if (isIndex) {
                syntaxQueue.add("INDEX");
                syntaxQueue.add(tokens.poll());
            } else {
                syntaxQueue.add("COLUMN");
                syntaxQueue.add(tokens.poll());
            }
            DBUtils.getSyntaxEmbeddedQueue(tokens, syntaxQueue, isIndex);
        }
    }

    public static String getConnectionURL4XADataSource(Config config) throws XMLStreamException {
        String connectionURL = null;
        String connectionProperty = config.getProperty("dataSourceProps");
        if (connectionProperty != null) {
            OMElement payload = AXIOMUtil.stringToOM((String)connectionProperty);
            Map<String, String> properties = DBUtils.extractProperties(payload);
            Collection<String> propValues = properties.values();
            for (String propValue : propValues) {
                if (!propValue.startsWith("jdbc:")) continue;
                connectionURL = propValue;
                break;
            }
        }
        return connectionURL;
    }

    public static boolean isUDT(ParamValue paramValue) {
        return paramValue != null && paramValue.getValueType() == 3;
    }

    public static boolean isSQLArray(ParamValue paramValue) {
        return paramValue != null && paramValue.getValueType() == 2;
    }

    public static List<Integer> getNestedIndices(String indexString) throws DataServiceFault {
        String[] temp;
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (String s : temp = indexString.split("\\[")) {
            if ("".equals(s)) continue;
            try {
                indices.add(Integer.parseInt(s.substring(0, s.indexOf("]"))));
            }
            catch (NumberFormatException e) {
                throw new DataServiceFault("Unable to determine nested indices. Incompatible value specified for the attribute index");
            }
        }
        return indices;
    }

    public static ParamValue processSQLArray(Array sqlArray, ParamValue paramValue) throws SQLException {
        ResultSet rs = sqlArray.getResultSet();
        while (rs.next()) {
            Object arrayEl = rs.getObject(2);
            if (arrayEl instanceof Struct) {
                paramValue.getArrayValue().add(new ParamValue((Struct)arrayEl));
                continue;
            }
            if (arrayEl instanceof Array) {
                paramValue.getArrayValue().add(DBUtils.processSQLArray((Array)arrayEl, new ParamValue(2)));
                continue;
            }
            paramValue.getArrayValue().add(new ParamValue(String.valueOf(arrayEl)));
        }
        rs.close();
        return paramValue;
    }

    public static String extractUDTObjectName(String param) {
        Matcher m = udtPattern.matcher(param);
        if (m.find()) {
            String tmp = m.group();
            Pattern patternToGetIndex = Pattern.compile("\\[\\d+\\]");
            Matcher matcherToGetIndex = patternToGetIndex.matcher(tmp);
            if (matcherToGetIndex.find()) {
                int lengthOfIndexPart = matcherToGetIndex.group().length();
                return tmp.substring(0, tmp.length() - lengthOfIndexPart).trim();
            }
        }
        return null;
    }

    public static synchronized String loadFromSecureVault(String alias) {
        if (secretResolver == null) {
            secretResolver = SecretResolverFactory.create((OMElement)null, (boolean)false);
            secretResolver.init(DataServicesDSComponent.getSecretCallbackHandlerService().getSecretCallbackHandler());
        }
        return secretResolver.resolve(alias);
    }

    public static OMElement wrapBoxCarringResponse(OMElement result) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement wrapperElement = fac.createOMElement(new QName("http://ws.wso2.org/dataservice", "DATA_SERVICE_REQUEST_BOX_RESPONSE"));
        if (result != null) {
            wrapperElement.addChild((OMNode)result);
        }
        OMDocument doc = fac.createOMDocument();
        doc.addChild((OMNode)wrapperElement);
        return doc.getOMDocumentElement();
    }

    public static void populateStandardCustomDSProps(Map<String, String> dsProps, DataService dataService, Config config) {
        String dsInfo = dataService.getTenantId() + "#" + dataService.getName() + "#" + config.getConfigId();
        dsProps.put("__DATASOURCE_ID__", UUID.nameUUIDFromBytes(dsInfo.getBytes(Charset.forName("UTF-8"))).toString());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Custom Inline Data Source; ID: " + dsInfo + " UUID:" + dsProps.get("__DATASOURCE_ID__")));
        }
    }

    public static Object[] convertInputParamValues(List<InternalParam> params) throws DataServiceFault {
        Object[] result = new Object[params.size()];
        for (int i = 0; i < result.length; ++i) {
            InternalParam param = params.get(i);
            try {
                result[i] = DBUtils.convertInputParamValue(param.getValue().getValueAsString(), param.getSqlType());
                continue;
            }
            catch (DataServiceFault dataServiceFault) {
                throw new DataServiceFault(dataServiceFault, "Error processing parameter - " + param.getName() + ", Error - " + dataServiceFault.getMessage());
            }
        }
        return result;
    }

    public static Object convertInputParamValue(String value, String type) throws DataServiceFault {
        try {
            if ("INTEGER".equals(type)) {
                return Integer.parseInt(value);
            }
            if ("LONG".equals(type)) {
                return Long.parseLong(value);
            }
            if ("FLOAT".equals(type)) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if ("DOUBLE".equals(type)) {
                return Double.parseDouble(value);
            }
            if ("BOOLEAN".equals(type)) {
                return Boolean.parseBoolean(value);
            }
            if ("DATE".equals(type)) {
                return new Date(DBUtils.getDate(value).getTime());
            }
            if ("TIME".equals(type)) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(DBUtils.getTime(value).getTime());
                return cal;
            }
            if ("TIMESTAMP".equals(type)) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(DBUtils.getTimestamp(value).getTime());
                return cal;
            }
            return value;
        }
        catch (Exception e) {
            throw new DataServiceFault(e);
        }
    }

    public static String getTenantDomainFromId(int tid) {
        try {
            return DataServicesDSComponent.getRealmService().getTenantManager().getTenant(tid).getDomain();
        }
        catch (UserStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] getAllRolesUsingAuthorizationProvider(String authProviderConfig) throws DataServiceFault {
        try {
            AuthorizationProvider authorizationProvider;
            if (authProviderConfig != null && !authProviderConfig.isEmpty()) {
                StAXOMBuilder builder = new StAXOMBuilder((InputStream)new ByteArrayInputStream(authProviderConfig.getBytes(StandardCharsets.UTF_8)));
                OMElement documentElement = builder.getDocumentElement();
                authorizationProvider = DBUtils.generateAuthProviderFromXMLOMElement(documentElement);
            } else {
                authorizationProvider = new UserStoreAuthorizationProvider();
            }
            return authorizationProvider.getAllRoles();
        }
        catch (XMLStreamException e) {
            throw new DataServiceFault(e, "Error reading XML file data - " + authProviderConfig + " Error - " + e.getMessage());
        }
    }

    public static AuthorizationProvider generateAuthProviderFromXMLOMElement(OMElement authorizationProviderElement) throws DataServiceFault {
        Class<?> roleRetrieverClass = null;
        String roleRetrieverClassName = null;
        try {
            roleRetrieverClassName = authorizationProviderElement.getAttributeValue(new QName("class"));
            roleRetrieverClass = Class.forName(roleRetrieverClassName);
            AuthorizationProvider authorizationProvider = (AuthorizationProvider)roleRetrieverClass.newInstance();
            Iterator propertyElements = authorizationProviderElement.getChildrenWithName(new QName("property"));
            HashMap<String, String> properties = new HashMap<String, String>();
            if (propertyElements != null) {
                while (propertyElements.hasNext()) {
                    OMElement propertyElement = (OMElement)propertyElements.next();
                    String attributeName = propertyElement.getAttributeValue(new QName("name"));
                    String attributeValue = propertyElement.getText();
                    properties.put(attributeName, attributeValue);
                }
            }
            authorizationProvider.init(properties);
            return authorizationProvider;
        }
        catch (ClassNotFoundException e) {
            throw new DataServiceFault(e, "Specified class - " + roleRetrieverClassName + " class cannot be found, Error - " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new DataServiceFault(e, "Initialisation Error for class - " + roleRetrieverClass + " Error - " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new DataServiceFault(e, "Illegal access attempt for class - " + roleRetrieverClass + " Error - " + e.getMessage());
        }
    }

    static {
        conversionTypes = new HashMap();
        conversionTypes.put("CHAR", "java.lang.String");
        conversionTypes.put("STRING", "java.lang.String");
        conversionTypes.put("QUERY_STRING", "java.lang.String");
        conversionTypes.put("VARCHAR", "java.lang.String");
        conversionTypes.put("NVARCHAR", "java.lang.String");
        conversionTypes.put("TEXT", "java.lang.String");
        conversionTypes.put("NUMERIC", "java.math.BigDecimal");
        conversionTypes.put("DECIMAL", "java.math.BigDecimal");
        conversionTypes.put("MONEY", "java.math.BigDecimal");
        conversionTypes.put("SMALLMONEY", "java.math.BigDecimal");
        conversionTypes.put("BIT", "boolean");
        conversionTypes.put("BOOLEAN", "boolean");
        conversionTypes.put("TINYINT", "byte");
        conversionTypes.put("SMALLINT", "short");
        conversionTypes.put("INTEGER", "int");
        conversionTypes.put("BIGINT", "long");
        conversionTypes.put("REAL", "float");
        conversionTypes.put("FLOAT", "double");
        conversionTypes.put("DOUBLE", "double");
        conversionTypes.put("BINARY", "base64Binary");
        conversionTypes.put("VARBINARY", "base64Binary");
        conversionTypes.put("LONG VARBINARY", "base64Binary");
        conversionTypes.put("IMAGE", "base64Binary");
        conversionTypes.put("BLOB", "base64Binary");
        conversionTypes.put("DATE", "java.sql.Date");
        conversionTypes.put("TIME", "java.sql.Time");
        conversionTypes.put("TIMESTAMP", "java.sql.Timestamp");
        conversionTypes.put("ANYURI", "java.net.URI");
        conversionTypes.put("STRUCT", "java.sql.Struct");
        conversionTypes.put("VARINT", "java.math.BigInteger");
        conversionTypes.put("UUID", "java.lang.String");
        conversionTypes.put("INETADDRESS", "java.lang.String");
        conversionTypes.put("CLOB", "java.lang.String");
        xsdSqlTypeMap = new HashMap();
        xsdSqlTypeMap.put("string", "STRING");
        xsdSqlTypeMap.put("boolean", "BOOLEAN");
        xsdSqlTypeMap.put("int", "INTEGER");
        xsdSqlTypeMap.put("integer", "INTEGER");
        xsdSqlTypeMap.put("long", "LONG");
        xsdSqlTypeMap.put("float", "FLOAT");
        xsdSqlTypeMap.put("double", "DOUBLE");
        xsdSqlTypeMap.put("decimal", "DECIMAL");
        xsdSqlTypeMap.put("dateTime", "TIMESTAMP");
        xsdSqlTypeMap.put("time", "TIME");
        xsdSqlTypeMap.put("date", "DATE");
        xsdSqlTypeMap.put("base64Binary", "BINARY");
        xsdSqlTypeMap.put("binary", "BINARY");
        xmlOutputFactory = XMLOutputFactory.newInstance();
        xmlInputFactory = XMLInputFactory.newInstance();
        Map props = DBUtils.loadFactoryProperties("XMLInputFactory.properties");
        if (props != null) {
            Iterator iterator = props.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                xmlInputFactory.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
        omFactory = OMAbstractFactory.getOMFactory();
    }

    private static class StringNumberMap
    extends AbstractMap<Integer, String> {
        private StringNumberMap() {
        }

        @Override
        public Set<Map.Entry<Integer, String>> entrySet() {
            return null;
        }

        @Override
        public String get(Object key) {
            return key.toString();
        }
    }
}

