/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.config;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.policies.ConstantReconnectionPolicy;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.DefaultRetryPolicy;
import com.datastax.driver.core.policies.DowngradingConsistencyRetryPolicy;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.FallthroughRetryPolicy;
import com.datastax.driver.core.policies.LatencyAwarePolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.LoggingRetryPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import java.util.Map;
import org.wso2.carbon.dataservices.common.DBConstants;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.Config;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.odata.CassandraDataHandler;
import org.wso2.carbon.dataservices.core.odata.ODataDataHandler;
import org.wso2.carbon.dataservices.core.odata.ODataServiceFault;

public class CassandraConfig
extends Config {
    private Cluster cluster;
    private Session session;
    private boolean nativeBatchRequestsSupported;

    public CassandraConfig(DataService dataService, String configId, Map<String, String> properties, boolean odataEnable) throws DataServiceFault {
        super(dataService, configId, "Cassandra", properties, odataEnable);
        Cluster.Builder builder = Cluster.builder();
        this.populateSettings(builder, properties);
        String keyspace = properties.get("keyspace");
        this.cluster = builder.build();
        try {
            this.session = keyspace != null && keyspace.trim().length() > 0 ? this.cluster.connect(keyspace) : this.cluster.connect();
            this.nativeBatchRequestsSupported = this.session.getCluster().getConfiguration().getProtocolOptions().getProtocolVersion().toInt() > 1;
        }
        catch (NoHostAvailableException e) {
            throw new DataServiceFault(e, DBConstants.FaultCodes.CONNECTION_UNAVAILABLE_ERROR, e.getMessage());
        }
    }

    public boolean isNativeBatchRequestsSupported() {
        return this.nativeBatchRequestsSupported;
    }

    private Cluster.Builder populateLoadBalancingProp(Map<String, String> properties, Cluster.Builder builder) throws DataServiceFault {
        String loadBalancingProp = properties.get("loadBalancingPolicy");
        if (loadBalancingProp != null) {
            if ("LatencyAwareRoundRobinPolicy".equals(loadBalancingProp)) {
                builder = builder.withLoadBalancingPolicy((LoadBalancingPolicy)LatencyAwarePolicy.builder((LoadBalancingPolicy)new RoundRobinPolicy()).build());
            } else if ("RoundRobinPolicy".equals(loadBalancingProp)) {
                builder = builder.withLoadBalancingPolicy((LoadBalancingPolicy)new RoundRobinPolicy());
            } else if ("DCAwareRoundRobinPolicy".equals(loadBalancingProp)) {
                String dataCenter = properties.get("dataCenter");
                boolean allowRemoteDCsForLocalConsistencyLevel = Boolean.parseBoolean(properties.get("allowRemoteDCsForLocalConsistencyLevel"));
                builder = dataCenter != null && !dataCenter.isEmpty() ? (allowRemoteDCsForLocalConsistencyLevel ? builder.withLoadBalancingPolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().withLocalDc(dataCenter).allowRemoteDCsForLocalConsistencyLevel().build()) : builder.withLoadBalancingPolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().withLocalDc(dataCenter).build())) : (allowRemoteDCsForLocalConsistencyLevel ? builder.withLoadBalancingPolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().allowRemoteDCsForLocalConsistencyLevel().build()) : builder.withLoadBalancingPolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().build()));
            } else if ("TokenAwareRoundRobinPolicy".equals(loadBalancingProp)) {
                builder = builder.withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy()));
            } else if ("TokenAwareDCAwareRoundRobinPolicy".equals(loadBalancingProp)) {
                String dataCenter = properties.get("dataCenter");
                boolean allowRemoteDCsForLocalConsistencyLevel = Boolean.parseBoolean(properties.get("allowRemoteDCsForLocalConsistencyLevel"));
                builder = dataCenter != null && !dataCenter.isEmpty() ? (allowRemoteDCsForLocalConsistencyLevel ? builder.withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().withLocalDc(dataCenter).allowRemoteDCsForLocalConsistencyLevel().build())) : builder.withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().withLocalDc(dataCenter).build()))) : (allowRemoteDCsForLocalConsistencyLevel ? builder.withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().allowRemoteDCsForLocalConsistencyLevel().build())) : builder.withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().build())));
            } else {
                throw new DataServiceFault("Unsupported Cassandra load balancing policy: " + loadBalancingProp);
            }
        }
        return builder;
    }

    private Cluster.Builder populateCredentials(Map<String, String> properties, Cluster.Builder builder) {
        String usernameProp = properties.get("username");
        String passwordProp = properties.get("password");
        if (usernameProp != null) {
            builder = builder.withCredentials(usernameProp, passwordProp);
        }
        return builder;
    }

    private Cluster.Builder populatePoolingSettings(Map<String, String> properties, Cluster.Builder builder) {
        String localCoreConnectionsPerHost = properties.get("localCoreConnectionsPerHost");
        String remoteCoreConnectionsPerHost = properties.get("remoteCoreConnectionsPerHost");
        String localMaxConnectionsPerHost = properties.get("localMaxConnectionsPerHost");
        String remoteMaxConnectionsPerHost = properties.get("remoteMaxConnectionsPerHost");
        String localNewConnectionThreshold = properties.get("localNewConnectionThreshold");
        String remoteNewConnectionThreshold = properties.get("remoteNewConnectionThreshold");
        String localMaxRequestsPerConnection = properties.get("localMaxRequestsPerConnection");
        String remoteMaxRequestsPerConnection = properties.get("remoteMaxRequestsPerConnection");
        PoolingOptions options = new PoolingOptions();
        if (localCoreConnectionsPerHost != null) {
            options.setCoreConnectionsPerHost(HostDistance.LOCAL, Integer.parseInt(localCoreConnectionsPerHost));
        }
        if (remoteCoreConnectionsPerHost != null) {
            options.setCoreConnectionsPerHost(HostDistance.REMOTE, Integer.parseInt(remoteCoreConnectionsPerHost));
        }
        if (localMaxConnectionsPerHost != null) {
            options.setMaxConnectionsPerHost(HostDistance.LOCAL, Integer.parseInt(localMaxConnectionsPerHost));
        }
        if (remoteMaxConnectionsPerHost != null) {
            options.setMaxConnectionsPerHost(HostDistance.REMOTE, Integer.parseInt(remoteMaxConnectionsPerHost));
        }
        if (localNewConnectionThreshold != null) {
            options.setNewConnectionThreshold(HostDistance.LOCAL, Integer.parseInt(localNewConnectionThreshold));
        }
        if (remoteNewConnectionThreshold != null) {
            options.setNewConnectionThreshold(HostDistance.REMOTE, Integer.parseInt(remoteNewConnectionThreshold));
        }
        if (localMaxRequestsPerConnection != null) {
            options.setMaxRequestsPerConnection(HostDistance.LOCAL, Integer.parseInt(localMaxRequestsPerConnection));
        }
        if (remoteMaxRequestsPerConnection != null) {
            options.setMaxRequestsPerConnection(HostDistance.REMOTE, Integer.parseInt(remoteMaxRequestsPerConnection));
        }
        builder = builder.withPoolingOptions(options);
        return builder;
    }

    private Cluster.Builder populateQueryOptions(Map<String, String> properties, Cluster.Builder builder) {
        String consistencyLevelProp = properties.get("consistencyLevel");
        String serialConsistencyLevelProp = properties.get("serialConsistencyLevel");
        String fetchSize = properties.get("fetchSize");
        QueryOptions options = new QueryOptions();
        if (consistencyLevelProp != null) {
            options.setConsistencyLevel(ConsistencyLevel.valueOf((String)consistencyLevelProp));
        }
        if (serialConsistencyLevelProp != null) {
            options.setSerialConsistencyLevel(ConsistencyLevel.valueOf((String)serialConsistencyLevelProp));
        }
        if (fetchSize != null) {
            options.setFetchSize(Integer.parseInt(fetchSize));
        }
        return builder.withQueryOptions(options);
    }

    private Cluster.Builder populateReconnectPolicy(Map<String, String> properties, Cluster.Builder builder) throws DataServiceFault {
        String reconnectPolicyProp = properties.get("reconnectionPolicy");
        if (reconnectPolicyProp != null) {
            if ("ConstantReconnectionPolicy".equals(reconnectPolicyProp)) {
                String constantReconnectionPolicyDelay = properties.get("constantReconnectionPolicyDelay");
                if (constantReconnectionPolicyDelay == null) {
                    throw new DataServiceFault("constantReconnectionPolicyDelay property must be set for ConstantReconnectionPolicy");
                }
                ConstantReconnectionPolicy policy = new ConstantReconnectionPolicy(Long.parseLong(constantReconnectionPolicyDelay));
                builder = builder.withReconnectionPolicy((ReconnectionPolicy)policy);
            } else if ("ExponentialReconnectionPolicy".equals(reconnectPolicyProp)) {
                String exponentialReconnectionPolicyBaseDelay = properties.get("exponentialReconnectionPolicyBaseDelay");
                if (exponentialReconnectionPolicyBaseDelay == null) {
                    throw new DataServiceFault("exponentialReconnectionPolicyBaseDelay property must be set for ExponentialReconnectionPolicy");
                }
                String exponentialReconnectionPolicyMaxDelay = properties.get("exponentialReconnectionPolicyMaxDelay");
                if (exponentialReconnectionPolicyMaxDelay == null) {
                    throw new DataServiceFault("exponentialReconnectionPolicyMaxDelay property must be set for ExponentialReconnectionPolicy");
                }
                ExponentialReconnectionPolicy policy = new ExponentialReconnectionPolicy(Long.parseLong(exponentialReconnectionPolicyBaseDelay), Long.parseLong(exponentialReconnectionPolicyMaxDelay));
                builder = builder.withReconnectionPolicy((ReconnectionPolicy)policy);
            } else {
                throw new DataServiceFault("Unsupported Cassandra reconnection policy: " + reconnectPolicyProp);
            }
        }
        return builder;
    }

    private Cluster.Builder populateRetrytPolicy(Map<String, String> properties, Cluster.Builder builder) throws DataServiceFault {
        String retryPolicy = properties.get("retryPolicy");
        if (retryPolicy != null) {
            if ("DefaultRetryPolicy".equals(retryPolicy)) {
                builder = builder.withRetryPolicy((RetryPolicy)DefaultRetryPolicy.INSTANCE);
            } else if ("DowngradingConsistencyRetryPolicy".equals(retryPolicy)) {
                builder = builder.withRetryPolicy((RetryPolicy)DowngradingConsistencyRetryPolicy.INSTANCE);
            } else if ("FallthroughRetryPolicy".equals(retryPolicy)) {
                builder = builder.withRetryPolicy((RetryPolicy)FallthroughRetryPolicy.INSTANCE);
            } else if ("LoggingDefaultRetryPolicy".equals(retryPolicy)) {
                builder = builder.withRetryPolicy((RetryPolicy)new LoggingRetryPolicy((RetryPolicy)DefaultRetryPolicy.INSTANCE));
            } else if ("LoggingDowngradingConsistencyRetryPolicy".equals(retryPolicy)) {
                builder = builder.withRetryPolicy((RetryPolicy)new LoggingRetryPolicy((RetryPolicy)DowngradingConsistencyRetryPolicy.INSTANCE));
            } else if ("LoggingFallthroughRetryPolicy".equals(retryPolicy)) {
                builder = builder.withRetryPolicy((RetryPolicy)new LoggingRetryPolicy((RetryPolicy)FallthroughRetryPolicy.INSTANCE));
            } else {
                throw new DataServiceFault("Invalid Cassandra retry policy: " + retryPolicy);
            }
        }
        return builder;
    }

    private Cluster.Builder populateSocketOptions(Map<String, String> properties, Cluster.Builder builder) throws DataServiceFault {
        String connectionTimeoutMillisProp = properties.get("connectionTimeoutMillis");
        String keepAliveProp = properties.get("keepAlive");
        String readTimeoutMillisProp = properties.get("readTimeoutMillis");
        String receiveBufferSizeProp = properties.get("receiverBufferSize");
        String reuseAddress = properties.get("reuseAddress");
        String sendBufferSize = properties.get("sendBufferSize");
        String soLinger = properties.get("soLinger");
        String tcpNoDelay = properties.get("tcpNoDelay");
        SocketOptions options = new SocketOptions();
        if (connectionTimeoutMillisProp != null) {
            options.setConnectTimeoutMillis(Integer.parseInt(connectionTimeoutMillisProp));
        }
        if (keepAliveProp != null) {
            options.setKeepAlive(Boolean.parseBoolean(keepAliveProp));
        }
        if (readTimeoutMillisProp != null) {
            options.setReadTimeoutMillis(Integer.parseInt(readTimeoutMillisProp));
        }
        if (receiveBufferSizeProp != null) {
            options.setReceiveBufferSize(Integer.parseInt(receiveBufferSizeProp));
        }
        if (reuseAddress != null) {
            options.setReuseAddress(Boolean.parseBoolean(reuseAddress));
        }
        if (sendBufferSize != null) {
            options.setSendBufferSize(Integer.parseInt(sendBufferSize));
        }
        if (soLinger != null) {
            options.setSoLinger(Integer.parseInt(soLinger));
        }
        if (tcpNoDelay != null) {
            options.setTcpNoDelay(Boolean.parseBoolean(tcpNoDelay));
        }
        return builder.withSocketOptions(options);
    }

    private Cluster.Builder populateSettings(Cluster.Builder builder, Map<String, String> properties) throws DataServiceFault {
        String enableMetricsProp;
        String compressionProp;
        String clusterNameProp;
        String[] servers;
        String serversParam = properties.get("cassandraServers");
        for (String server : servers = serversParam.split(",")) {
            builder = builder.addContactPoint(server);
        }
        String portProp = properties.get("port");
        if (portProp != null) {
            builder = builder.withPort(Integer.parseInt(portProp));
        }
        if ((clusterNameProp = properties.get("clusterName")) != null) {
            builder = builder.withClusterName(clusterNameProp);
        }
        if ((compressionProp = properties.get("compression")) != null) {
            builder = builder.withCompression(ProtocolOptions.Compression.valueOf((String)compressionProp));
        }
        builder = this.populateCredentials(properties, builder);
        builder = this.populateLoadBalancingProp(properties, builder);
        String enableJMXProp = properties.get("enableJMXReporting");
        if (enableJMXProp != null && !Boolean.parseBoolean(enableJMXProp)) {
            builder = builder.withoutJMXReporting();
        }
        if ((enableMetricsProp = properties.get("enableMetrics")) != null && !Boolean.parseBoolean(enableMetricsProp)) {
            builder = builder.withoutMetrics();
        }
        builder = this.populatePoolingSettings(properties, builder);
        String versionProp = properties.get("protocolVersion");
        if (versionProp != null) {
            builder = builder.withProtocolVersion(ProtocolVersion.fromInt((int)Integer.parseInt(versionProp)));
        }
        builder = this.populateQueryOptions(properties, builder);
        builder = this.populateReconnectPolicy(properties, builder);
        builder = this.populateRetrytPolicy(properties, builder);
        builder = this.populateSocketOptions(properties, builder);
        String enableSSLProp = properties.get("enableSSL");
        if (enableSSLProp != null && Boolean.parseBoolean(enableSSLProp)) {
            builder = builder.withSSL();
        }
        return builder;
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public synchronized void close() {
        this.session.close();
        this.cluster.close();
    }

    @Override
    public ODataDataHandler createODataHandler() throws ODataServiceFault {
        String keySpace = this.getProperty("keyspace");
        if (keySpace != null) {
            return new CassandraDataHandler(this.getConfigId(), this.getSession(), keySpace);
        }
        throw new ODataServiceFault("Please specify the Cassandra keyspace.");
    }

    @Override
    public boolean isResultSetFieldsCaseSensitive() {
        return false;
    }
}

