/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.config;

import java.util.Map;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.custom.datasource.CustomQueryBasedDS;
import org.wso2.carbon.dataservices.core.custom.datasource.CustomQueryDataSourceReader;
import org.wso2.carbon.dataservices.core.description.config.CustomQueryBasedDSConfig;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.internal.DataServicesDSComponent;
import org.wso2.carbon.dataservices.core.odata.ODataDataHandler;
import org.wso2.carbon.dataservices.core.odata.ODataServiceFault;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.CarbonDataSource;
import org.wso2.carbon.ndatasource.core.DataSourceService;

public class CustomQueryCarbonDataSourceConfig
extends CustomQueryBasedDSConfig {
    private String dataSourceName;
    private CustomQueryBasedDS dataSource;

    public CustomQueryCarbonDataSourceConfig(DataService dataService, String configId, Map<String, String> properties, boolean odataEnable) throws DataServiceFault {
        super(dataService, configId, "CUSTOM_QUERY", properties, odataEnable);
        this.dataSourceName = properties.get("carbon_datasource_name");
        this.dataSource = this.initDataSource();
    }

    @Override
    public CustomQueryBasedDS getDataSource() {
        return this.dataSource;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    private CustomQueryBasedDS initDataSource() throws DataServiceFault {
        DataSourceService dataSourceService = DataServicesDSComponent.getDataSourceService();
        if (dataSourceService == null) {
            throw new DataServiceFault("Carbon DataSource Service is not initialized properly");
        }
        try {
            CarbonDataSource cds = dataSourceService.getDataSource(this.getDataSourceName());
            if (cds == null) {
                throw new DataServiceFault("Cannot find data source with the name: " + this.getDataSourceName());
            }
            String dsType = cds.getDSMInfo().getDefinition().getType();
            if (CustomQueryDataSourceReader.DATA_SOURCE_TYPE.equals(dsType)) {
                Object result = cds.getDSObject();
                if (!(result instanceof CustomQueryBasedDS)) {
                    throw new DataServiceFault("The data source '" + this.getDataSourceName() + "' is not of type '" + CustomQueryDataSourceReader.DATA_SOURCE_TYPE + "'");
                }
                return (CustomQueryBasedDS)result;
            }
            throw new DataServiceFault("The type '" + dsType + "' of data source '" + this.getDataSourceName() + "' is not supported in CustomQueryCarbonDataSourceConfig");
        }
        catch (DataSourceException e) {
            throw new DataServiceFault(e, "Error in retrieving data source: " + e.getMessage());
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public ODataDataHandler createODataHandler() throws ODataServiceFault {
        throw new ODataServiceFault("Expose as OData Service feature doesn't support for the " + this.getConfigId() + " Datasource.");
    }

    @Override
    public boolean isResultSetFieldsCaseSensitive() {
        return false;
    }
}

