/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.dispatch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.TLConnectionStore;
import org.wso2.carbon.dataservices.core.dispatch.BatchRequestParticipant;
import org.wso2.carbon.dataservices.core.dispatch.DataServiceRequest;
import org.wso2.carbon.dataservices.core.dispatch.DispatchStatus;
import org.wso2.carbon.dataservices.core.dispatch.SingleDataServiceRequest;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.ParamValue;

public class BatchDataServiceRequest
extends DataServiceRequest {
    private List<SingleDataServiceRequest> dsRequests = new ArrayList<SingleDataServiceRequest>();
    private static ThreadLocal<List<BatchRequestParticipant>> batchRequestParticipant = new ThreadLocal<List<BatchRequestParticipant>>(){

        @Override
        protected synchronized List<BatchRequestParticipant> initialValue() {
            return new ArrayList<BatchRequestParticipant>();
        }
    };

    public BatchDataServiceRequest(DataService dataService, String requestName, List<Map<String, ParamValue>> batchParams) throws DataServiceFault {
        super(dataService, requestName);
        for (Map<String, ParamValue> params : batchParams) {
            this.dsRequests.add(new SingleDataServiceRequest(dataService, requestName, params));
        }
    }

    public static void addParticipant(BatchRequestParticipant participant) {
        batchRequestParticipant.get().add(participant);
    }

    private static List<BatchRequestParticipant> getParticipants() {
        return batchRequestParticipant.get();
    }

    private static void releaseParticipantResources() {
        List<BatchRequestParticipant> finList = BatchDataServiceRequest.getParticipants();
        for (BatchRequestParticipant fin : finList) {
            fin.releaseBatchRequestResources();
        }
    }

    private static void clearParticipants() {
        BatchDataServiceRequest.getParticipants().clear();
    }

    private static void clearStatus() {
        DispatchStatus.clearBatchRequestStatus();
    }

    public List<SingleDataServiceRequest> getDSRequests() {
        return this.dsRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMElement processRequest() throws DataServiceFault {
        boolean error = true;
        try {
            DispatchStatus.setBatchRequest();
            List<SingleDataServiceRequest> requests = this.getDSRequests();
            int count = requests.size();
            DispatchStatus.setBatchRequestCount(count);
            OMElement result = null;
            for (int i = 0; i < count; ++i) {
                DispatchStatus.setBatchRequestNumber(i);
                OMElement element = requests.get(i).dispatch();
                if (element == null || element.getFirstOMChild() == null) continue;
                result = element;
            }
            error = false;
            OMElement oMElement = result;
            return oMElement;
        }
        finally {
            this.finalizeTx(error);
            BatchDataServiceRequest.releaseParticipantResources();
            BatchDataServiceRequest.clearParticipants();
            BatchDataServiceRequest.clearStatus();
        }
    }

    private void finalizeTx(boolean error) {
        if (DispatchStatus.isBoxcarringRequest()) {
            return;
        }
        if (error) {
            if (this.getDataService().isInDTX()) {
                TLConnectionStore.rollbackNonXAConns();
                TLConnectionStore.closeAll();
            } else {
                TLConnectionStore.rollbackAll();
                TLConnectionStore.closeAll();
            }
        } else {
            if (this.getDataService().isInDTX()) {
                TLConnectionStore.commitNonXAConns();
            } else {
                TLConnectionStore.commitAll();
            }
            TLConnectionStore.closeAll();
        }
    }
}

