/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.dispatch;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DSSessionManager;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.TLConnectionStore;
import org.wso2.carbon.dataservices.core.boxcarring.TLParamStore;
import org.wso2.carbon.dataservices.core.dispatch.DataServiceRequest;
import org.wso2.carbon.dataservices.core.dispatch.DispatchStatus;

public class BoxcarringDataServiceRequest
extends DataServiceRequest {
    private DataServiceRequest dsRequest;

    public BoxcarringDataServiceRequest(DataServiceRequest dsRequest) throws DataServiceFault {
        super(dsRequest.getDataService(), dsRequest.getRequestName());
        this.dsRequest = dsRequest;
    }

    public DataServiceRequest getDSRequest() {
        return this.dsRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMElement processRequest() throws DataServiceFault {
        if ("begin_boxcar".equals(this.getRequestName())) {
            DSSessionManager.getCurrentRequestBox().clear();
            DSSessionManager.setBoxcarring(true);
        } else {
            if ("end_boxcar".equals(this.getRequestName())) {
                boolean error = true;
                try {
                    DispatchStatus.setBoxcarringRequest();
                    if (!this.getDataService().isInDTX()) {
                        this.getDataService().getDSSTxManager().begin();
                    }
                    OMElement lastRequestResult = DSSessionManager.getCurrentRequestBox().execute();
                    error = false;
                    OMElement oMElement = lastRequestResult;
                    return oMElement;
                }
                finally {
                    this.finalizeTx(error);
                    DSSessionManager.getCurrentRequestBox().clear();
                    DSSessionManager.setBoxcarring(false);
                    TLParamStore.clear();
                }
            }
            if ("abort_boxcar".equals(this.getRequestName())) {
                DSSessionManager.getCurrentRequestBox().clear();
                DSSessionManager.setBoxcarring(false);
                this.finalizeTx(true);
            } else {
                DSSessionManager.getCurrentRequestBox().addRequest(this.getDSRequest());
                return this.createBoxcarringRequestResultWrapper();
            }
        }
        return null;
    }

    private void finalizeTx(boolean error) throws DataServiceFault {
        if (error) {
            if (this.getDataService().isInDTX()) {
                TLConnectionStore.rollbackNonXAConns();
                TLConnectionStore.closeAll();
                if (this.getDataService().getDSSTxManager().isDTXInitiatedByUS()) {
                    this.getDataService().getDSSTxManager().rollback();
                }
            } else {
                TLConnectionStore.rollbackAll();
                TLConnectionStore.closeAll();
            }
        } else {
            if (this.getDataService().isInDTX()) {
                TLConnectionStore.commitNonXAConns();
            } else {
                TLConnectionStore.commitAll();
            }
            TLConnectionStore.closeAll();
            if (this.getDataService().getDSSTxManager().isDTXInitiatedByUS()) {
                this.getDataService().getDSSTxManager().commit();
            }
        }
    }

    private OMElement createBoxcarringRequestResultWrapper() {
        String resultWrapper = this.getDataService().getResultWrapperForRequest(this.getRequestName());
        if (resultWrapper == null) {
            return null;
        }
        String ns = this.getDataService().getNamespaceForRequest(this.getRequestName());
        OMFactory fac = DBUtils.getOMFactory();
        OMElement ele = fac.createOMElement(new QName(ns, resultWrapper));
        return ele;
    }
}

