/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.dispatch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DSSessionManager;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.DataServiceUser;
import org.wso2.carbon.dataservices.core.dispatch.BatchDataServiceRequest;
import org.wso2.carbon.dataservices.core.dispatch.BoxcarringDataServiceRequest;
import org.wso2.carbon.dataservices.core.dispatch.RequestBoxRequest;
import org.wso2.carbon.dataservices.core.dispatch.SingleDataServiceRequest;
import org.wso2.carbon.dataservices.core.engine.CallableRequest;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.ParamValue;

public abstract class DataServiceRequest {
    private String user;
    private String[] userRoles;
    private DataService dataService;
    private String requestName;
    private boolean disableStreaming;

    protected DataServiceRequest(DataService dataService, String requestName) throws DataServiceFault {
        this.dataService = dataService;
        this.requestName = requestName;
        CallableRequest request = this.dataService.getCallableRequest(this.requestName);
        if (request == null) {
            throw new DataServiceFault("A data service request named '" + requestName + "' does not exist in data service '" + dataService.getName() + "'");
        }
        this.disableStreaming = this.dataService.getCallableRequest(this.requestName).isDisableStreamingEffective();
    }

    public static DataServiceRequest createDataServiceRequest(MessageContext msgContext) throws DataServiceFault {
        AxisService axisService = msgContext.getAxisService();
        AxisOperation axisOp = msgContext.getAxisOperation();
        OMElement inputMessage = msgContext.getEnvelope().getBody().getFirstElement();
        String requestName = axisOp.getName().getLocalPart();
        if (Boolean.parseBoolean(System.getProperty("dss.force.xml.validation")) && inputMessage != null && !requestName.equals(inputMessage.getLocalName())) {
            throw new DataServiceFault("Input Message and " + requestName + " Axis Operation didn't match.");
        }
        DataService dataService = (DataService)axisService.getParameter("org.wso2.ws.dataservice.dataservice.obj").getValue();
        if (DataServiceRequest.isRequestBoxRequest(requestName)) {
            DataServiceRequest dsRequest = DataServiceRequest.createRequestBoxRequest(dataService, requestName, inputMessage);
            return dsRequest;
        }
        DataServiceRequest dsRequest = DataServiceRequest.isBatchRequest(inputMessage) ? new BatchDataServiceRequest(dataService, requestName, DataServiceRequest.getBatchInputValuesFromOM(inputMessage)) : new SingleDataServiceRequest(dataService, requestName, DataServiceRequest.getSingleInputValuesFromOM(inputMessage));
        DataServiceRequest.populateUserInfo(dataService, dsRequest, msgContext);
        if (DataServiceRequest.isBoxcarringRequest(requestName)) {
            dsRequest = new BoxcarringDataServiceRequest(dsRequest);
        }
        return dsRequest;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public String getRequestName() {
        return this.requestName;
    }

    public boolean isDisableStreaming() {
        return this.disableStreaming;
    }

    private static void populateUserInfo(DataService dataService, DataServiceRequest dsRequest, MessageContext msgContext) throws DataServiceFault {
        String username = dataService.getAuthorizationProvider().getUsername(msgContext);
        dsRequest.setUser(username);
        if (username != null) {
            try {
                dsRequest.setUserRoles(dataService.getAuthorizationProvider().getUserRoles(msgContext));
            }
            catch (Exception e) {
                throw new DataServiceFault(e, "Error setting user roles");
            }
        }
    }

    private static boolean isBatchRequest(OMElement inputMessage) {
        OMElement el;
        return inputMessage != null && (el = inputMessage.getFirstElement()) != null && el.getChildElements().hasNext();
    }

    public static boolean isBoxcarringRequest(String requestName) {
        if ("begin_boxcar".equals(requestName)) {
            return true;
        }
        if ("end_boxcar".equals(requestName)) {
            return true;
        }
        if ("abort_boxcar".equals(requestName)) {
            return true;
        }
        return DSSessionManager.isBoxcarring();
    }

    private static boolean isRequestBoxRequest(String requestName) {
        return requestName.endsWith("request_box");
    }

    private static Map<String, ParamValue> getSingleInputValuesFromOM(OMElement inputMessage) {
        List omElList;
        if (inputMessage == null) {
            return new HashMap<String, ParamValue>();
        }
        HashMap<String, ParamValue> inputs = new HashMap<String, ParamValue>();
        HashMap inputMap = new HashMap();
        Iterator iter = inputMessage.getChildElements();
        while (iter.hasNext()) {
            OMElement element = (OMElement)iter.next();
            String name = element.getLocalName();
            if (!inputMap.containsKey(name)) {
                inputMap.put(name, new ArrayList());
            }
            omElList = (List)inputMap.get(name);
            omElList.add(element);
        }
        for (String key : inputMap.keySet()) {
            ParamValue paramValue;
            omElList = (List)inputMap.get(key);
            if (omElList.size() == 1) {
                paramValue = new ParamValue(DataServiceRequest.getTextValueFromOMElement((OMElement)omElList.get(0)));
            } else {
                paramValue = new ParamValue(2);
                for (OMElement omEl : omElList) {
                    paramValue.addToArrayValue(new ParamValue(DataServiceRequest.getTextValueFromOMElement(omEl)));
                }
            }
            inputs.put(key, paramValue);
        }
        return inputs;
    }

    private static List<Map<String, ParamValue>> getBatchInputValuesFromOM(OMElement inputMessage) {
        ArrayList<Map<String, ParamValue>> batchParams = new ArrayList<Map<String, ParamValue>>();
        Iterator paramItr = inputMessage.getChildElements();
        while (paramItr.hasNext()) {
            OMElement paramEl = (OMElement)paramItr.next();
            batchParams.add(DataServiceRequest.getSingleInputValuesFromOM(paramEl));
        }
        return batchParams;
    }

    private static DataServiceRequest createRequestBoxRequest(DataService dataService, String requestName, OMElement inputMessage) throws DataServiceFault {
        RequestBoxRequest dsRequest = new RequestBoxRequest(dataService, requestName);
        if (inputMessage == null) {
            throw new DataServiceFault("Input message is null for REQUEST_BOX request");
        }
        Iterator paramItr = inputMessage.getChildElements();
        while (paramItr.hasNext()) {
            OMElement paramEl = (OMElement)paramItr.next();
            DataServiceRequest childRequest = DataServiceRequest.isBatchRequest(paramEl) ? new BatchDataServiceRequest(dataService, paramEl.getLocalName(), DataServiceRequest.getBatchInputValuesFromOM(paramEl)) : new SingleDataServiceRequest(dataService, paramEl.getLocalName(), DataServiceRequest.getSingleInputValuesFromOM(paramEl));
            dsRequest.addRequests(childRequest);
        }
        return dsRequest;
    }

    private static String getTextValueFromOMElement(OMElement omEl) {
        String nillValue = omEl.getAttributeValue(new QName("http://www.w3.org/2001/XMLSchema-instance", "nil"));
        if (nillValue != null && (nillValue.equals("1") || nillValue.equals("true"))) {
            return null;
        }
        return omEl.getText();
    }

    public void setUser(String requestUser) {
        this.user = requestUser;
    }

    public String getUser() {
        return this.user;
    }

    public void setUserRoles(String[] userRoles) {
        this.userRoles = userRoles;
    }

    public String[] getUserRoles() {
        return this.userRoles;
    }

    public OMElement dispatch() throws DataServiceFault {
        if (this.getUserRoles() != null) {
            DataServiceUser currentUser = new DataServiceUser(this.getUser(), new HashSet<String>(Arrays.asList(this.getUserRoles())));
            DataService.setCurrentUser(currentUser);
        }
        OMElement result = this.processRequest();
        if (this.isDisableStreaming() && result instanceof OMSourcedElementImpl) {
            result = DBUtils.cloneAndReturnBuiltElement(result);
        }
        return result;
    }

    public abstract OMElement processRequest() throws DataServiceFault;
}

