/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.engine;

import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.dataservices.core.engine.ExternalParam;
import org.wso2.carbon.dataservices.core.engine.ParamValue;

public class ExternalParamCollection {
    private Map<String, ExternalParam> columnEntries = new HashMap<String, ExternalParam>();
    private Map<String, ExternalParam> queryParamEntries = new HashMap<String, ExternalParam>();
    private Map<String, ParamValue> tmpEntries = new HashMap<String, ParamValue>();

    public Map<String, ParamValue> getTempEntries() {
        return this.tmpEntries;
    }

    public void addParam(ExternalParam param) {
        if ("column".equals(param.getType())) {
            this.columnEntries.put(param.getName(), param);
        } else {
            this.queryParamEntries.put(param.getName(), param);
        }
    }

    public void addTempParam(String name, ParamValue value) {
        this.getTempEntries().put(name, value);
    }

    public ParamValue getTempParam(String name) {
        return this.getTempEntries().get(name);
    }

    public void clearTempValues() {
        this.getTempEntries().clear();
    }

    public ExternalParam getParam(String type, String name) {
        if ("column".equals(type)) {
            return this.columnEntries.get(name);
        }
        return this.queryParamEntries.get(name);
    }

    public ExternalParam getParam(String name) {
        ExternalParam param = this.getParam("query-param", name);
        if (param == null) {
            param = this.getParam("column", name);
        }
        return param;
    }
}

