/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.odata;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.edm.EdmBindingTarget;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByItem;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.SkipOption;
import org.apache.olingo.server.api.uri.queryoption.SkipTokenOption;
import org.apache.olingo.server.api.uri.queryoption.TopOption;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.wso2.carbon.dataservices.core.odata.ODataConstants;
import org.wso2.carbon.dataservices.core.odata.expression.ExpressionVisitorImpl;
import org.wso2.carbon.dataservices.core.odata.expression.operand.TypedOperand;
import org.wso2.carbon.dataservices.core.odata.expression.operand.VisitorOperand;

public class QueryHandler {
    private static final int MAX_PAGE_SIZE = 10;

    public static void applyCountSystemQueryOption(CountOption countOption, EntityCollection entitySet) {
        if (countOption.getValue()) {
            entitySet.setCount(Integer.valueOf(entitySet.getEntities().size()));
        }
    }

    public static void applyFilterSystemQuery(FilterOption filterOption, EntityCollection entitySet, EdmBindingTarget edmEntitySet) throws ODataApplicationException {
        try {
            Iterator iter = entitySet.getEntities().iterator();
            while (iter.hasNext()) {
                VisitorOperand operand = (VisitorOperand)filterOption.getExpression().accept((ExpressionVisitor)new ExpressionVisitorImpl((Entity)iter.next(), edmEntitySet));
                TypedOperand typedOperand = operand.asTypedOperand();
                if (typedOperand.is(ODataConstants.primitiveBoolean)) {
                    if (!Boolean.FALSE.equals(typedOperand.getTypedValue(Boolean.class))) continue;
                    iter.remove();
                    continue;
                }
                throw new ODataApplicationException("Invalid filter expression. Filter expressions must return a value of type Edm.Boolean", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ROOT);
            }
        }
        catch (ExpressionVisitException e) {
            throw new ODataApplicationException("Exception in filter evaluation", HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.ROOT);
        }
    }

    public static void applyTopSystemQueryOption(TopOption topOption, EntityCollection entitySet) throws ODataApplicationException {
        if (topOption.getValue() < 0) {
            throw new ODataApplicationException("Top value must be positive", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ROOT);
        }
        QueryHandler.reduceToSize(entitySet, topOption.getValue());
    }

    private static void reduceToSize(EntityCollection entitySet, int limit) {
        while (entitySet.getEntities().size() > limit) {
            entitySet.getEntities().remove(entitySet.getEntities().size() - 1);
        }
    }

    public static void applySkipSystemQueryHandler(SkipOption skipOption, EntityCollection entitySet) throws ODataApplicationException {
        if (skipOption.getValue() < 0) {
            throw new ODataApplicationException("Skip value must be positive", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ROOT);
        }
        QueryHandler.popAtMost(entitySet, skipOption.getValue());
    }

    private static void popAtMost(EntityCollection entitySet, int n) {
        Iterator iter = entitySet.getEntities().iterator();
        for (int i = 0; iter.hasNext() && i < n; ++i) {
            iter.next();
            iter.remove();
        }
    }

    public static Integer applyServerSidePaging(SkipTokenOption skipTokenOption, EntityCollection entityCollection, EdmEntitySet edmEntitySet, String rawRequestUri, Integer preferredPageSize) throws ODataApplicationException {
        if (edmEntitySet != null) {
            int page;
            int pageSize = QueryHandler.getPageSize(preferredPageSize);
            int itemsToSkip = pageSize * (page = QueryHandler.getPage(skipTokenOption));
            if (itemsToSkip <= entityCollection.getEntities().size()) {
                QueryHandler.popAtMost(entityCollection, itemsToSkip);
                int remainingItems = entityCollection.getEntities().size();
                QueryHandler.reduceToSize(entityCollection, pageSize);
                if (remainingItems > pageSize) {
                    entityCollection.setNext(QueryHandler.createNextLink(rawRequestUri, edmEntitySet, page + 1));
                }
            } else {
                throw new ODataApplicationException("Nothing found.", HttpStatusCode.NOT_FOUND.getStatusCode(), Locale.ROOT);
            }
            return pageSize;
        }
        return null;
    }

    private static URI createNextLink(String rawRequestUri, EdmEntitySet entitySet, int page) throws ODataApplicationException {
        String nextLink = rawRequestUri + "/" + entitySet.getName() + "?$skiptoken=" + page;
        try {
            return new URI(nextLink);
        }
        catch (URISyntaxException e) {
            throw new ODataApplicationException("Exception while constructing next link", HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.ROOT, (Throwable)e);
        }
    }

    private static int getPageSize(Integer preferredPageSize) {
        return preferredPageSize == null ? 10 : preferredPageSize;
    }

    private static int getPage(SkipTokenOption skipTokenOption) throws ODataApplicationException {
        String value = skipTokenOption.getValue();
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ODataApplicationException("Invalid skip token", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ROOT, (Throwable)e);
        }
    }

    public static void applyOrderByOption(final OrderByOption orderByOption, EntityCollection entitySet, final EdmBindingTarget edmBindingTarget) {
        Collections.sort(entitySet.getEntities(), new Comparator<Entity>(){

            @Override
            public int compare(Entity e1, Entity e2) {
                int result = 0;
                for (int i = 0; i < orderByOption.getOrders().size() && result == 0; ++i) {
                    try {
                        OrderByItem item = (OrderByItem)orderByOption.getOrders().get(i);
                        TypedOperand op1 = ((VisitorOperand)item.getExpression().accept((ExpressionVisitor)new ExpressionVisitorImpl(e1, edmBindingTarget))).asTypedOperand();
                        TypedOperand op2 = ((VisitorOperand)item.getExpression().accept((ExpressionVisitor)new ExpressionVisitorImpl(e2, edmBindingTarget))).asTypedOperand();
                        if (op1.isNull() || op2.isNull()) {
                            result = op1.isNull() && op2.isNull() ? 0 : (op1.isNull() ? -1 : 1);
                        } else {
                            Object o1 = op1.getValue();
                            Object o2 = op2.getValue();
                            result = o1.getClass() == o2.getClass() && o1 instanceof Comparable ? ((Comparable)o1).compareTo(o2) : 0;
                        }
                        result = item.isDescending() ? result * -1 : result;
                        continue;
                    }
                    catch (ODataApplicationException | ExpressionVisitException e) {
                        throw new RuntimeException(e);
                    }
                }
                return result;
            }
        });
    }
}

