/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.odata.expression.operand;

import java.util.Locale;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.wso2.carbon.dataservices.core.odata.ODataConstants;
import org.wso2.carbon.dataservices.core.odata.expression.operand.TypedOperand;
import org.wso2.carbon.dataservices.core.odata.expression.operand.VisitorOperand;

public class UntypedOperand
extends VisitorOperand {
    public UntypedOperand(String literal) {
        super(literal);
    }

    @Override
    public TypedOperand asTypedOperand() throws ODataApplicationException {
        return this.determineType();
    }

    @Override
    public TypedOperand asTypedOperand(EdmPrimitiveType ... types) throws ODataApplicationException {
        String literal = (String)this.value;
        Object newValue = this.tryCast(literal, ODataConstants.primitiveNull);
        if (newValue != null) {
            return new TypedOperand(newValue, (EdmType)ODataConstants.primitiveNull);
        }
        for (EdmPrimitiveType type : types) {
            newValue = this.tryCast(literal, type);
            if (newValue == null) continue;
            return new TypedOperand(newValue, (EdmType)type);
        }
        throw new ODataApplicationException("Cast failed", HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.ROOT);
    }

    public TypedOperand determineType() throws ODataApplicationException {
        String literal = (String)this.value;
        if (ODataConstants.primitiveNull.validate(literal, null, null, null, null, null)) {
            return new TypedOperand(null, (EdmType)ODataConstants.primitiveNull);
        }
        Object newValue = this.tryCast(literal, ODataConstants.primitiveString);
        if (newValue != null) {
            return new TypedOperand(newValue, (EdmType)ODataConstants.primitiveString);
        }
        newValue = this.tryCast(literal, ODataConstants.primitiveBoolean);
        if (newValue != null) {
            return new TypedOperand(newValue, (EdmType)ODataConstants.primitiveBoolean);
        }
        newValue = this.tryCast(literal, ODataConstants.primitiveDateTimeOffset);
        if (newValue != null) {
            return new TypedOperand(newValue, (EdmType)ODataConstants.primitiveDateTimeOffset);
        }
        newValue = this.tryCast(literal, ODataConstants.primitiveDate);
        if (newValue != null) {
            return new TypedOperand(newValue, (EdmType)ODataConstants.primitiveDate);
        }
        newValue = this.tryCast(literal, ODataConstants.primitiveTimeOfDay);
        if (newValue != null) {
            return new TypedOperand(newValue, (EdmType)ODataConstants.primitiveTimeOfDay);
        }
        newValue = this.tryCast(literal, ODataConstants.primitiveDuration);
        if (newValue != null) {
            return new TypedOperand(newValue, (EdmType)ODataConstants.primitiveDuration);
        }
        newValue = this.tryCast(literal, ODataConstants.primitiveSByte);
        if (newValue != null) {
            return new TypedOperand(newValue, (EdmType)ODataConstants.primitiveSByte);
        }
        newValue = this.tryCast(literal, ODataConstants.primitiveByte);
        if (newValue != null) {
            return new TypedOperand(newValue, (EdmType)ODataConstants.primitiveByte);
        }
        newValue = this.tryCast(literal, ODataConstants.primitiveInt16);
        if (newValue != null) {
            return new TypedOperand(newValue, (EdmType)ODataConstants.primitiveInt16);
        }
        newValue = this.tryCast(literal, ODataConstants.primitiveInt32);
        if (newValue != null) {
            return new TypedOperand(newValue, (EdmType)ODataConstants.primitiveInt32);
        }
        newValue = this.tryCast(literal, ODataConstants.primitiveInt64);
        if (newValue != null) {
            return new TypedOperand(newValue, (EdmType)ODataConstants.primitiveInt64);
        }
        newValue = this.tryCast(literal, ODataConstants.primitiveDecimal);
        if (newValue != null) {
            return new TypedOperand(newValue, (EdmType)ODataConstants.primitiveDecimal);
        }
        newValue = this.tryCast(literal, ODataConstants.primitiveSingle);
        if (newValue != null) {
            return new TypedOperand(newValue, (EdmType)ODataConstants.primitiveSingle);
        }
        newValue = this.tryCast(literal, ODataConstants.primitiveGuid);
        if (newValue != null) {
            return new TypedOperand(newValue, (EdmType)ODataConstants.primitiveGuid);
        }
        newValue = this.tryCast(literal, ODataConstants.primitiveDouble);
        if (newValue != null) {
            return new TypedOperand(newValue, (EdmType)ODataConstants.primitiveDouble);
        }
        newValue = this.tryCast(literal, ODataConstants.primitiveBinary);
        if (newValue != null) {
            return new TypedOperand(newValue, (EdmType)ODataConstants.primitiveBinary);
        }
        throw new ODataApplicationException("Could not determine type for literal " + literal, HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.ROOT);
    }

    @Override
    public EdmProperty getEdmProperty() {
        return null;
    }
}

