/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.odata.expression.operation;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.queryoption.expression.BinaryOperatorKind;
import org.wso2.carbon.dataservices.core.odata.ODataConstants;
import org.wso2.carbon.dataservices.core.odata.expression.operand.TypedOperand;
import org.wso2.carbon.dataservices.core.odata.expression.operand.VisitorOperand;
import org.wso2.carbon.dataservices.core.odata.expression.primitive.EdmNull;

public class BinaryOperator {
    private TypedOperand right;
    private TypedOperand left;

    public BinaryOperator(VisitorOperand leftOperand, VisitorOperand rightOperand) throws ODataApplicationException {
        this.left = leftOperand.asTypedOperand();
        this.right = rightOperand.asTypedOperand();
        this.left = this.left.castToCommonType(this.right);
        this.right = this.right.castToCommonType(this.left);
    }

    public VisitorOperand andOperator() throws ODataApplicationException {
        Boolean result = null;
        if (this.left.is(ODataConstants.primitiveBoolean) && this.right.is(ODataConstants.primitiveBoolean)) {
            if (Boolean.TRUE.equals(this.left.getValue()) && Boolean.TRUE.equals(this.right.getValue())) {
                result = true;
            } else if (Boolean.FALSE.equals(this.left.getValue()) || Boolean.FALSE.equals(this.right.getValue())) {
                result = false;
            }
            return new TypedOperand(result, (EdmType)ODataConstants.primitiveBoolean);
        }
        throw new ODataApplicationException("Add operator needs two binary operands", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ROOT);
    }

    public VisitorOperand orOperator() throws ODataApplicationException {
        Boolean result = null;
        if (this.left.is(ODataConstants.primitiveBoolean) && this.right.is(ODataConstants.primitiveBoolean)) {
            if (Boolean.TRUE.equals(this.left.getValue()) || Boolean.TRUE.equals(this.right.getValue())) {
                result = true;
            } else if (Boolean.FALSE.equals(this.left.getValue()) && Boolean.FALSE.equals(this.right.getValue())) {
                result = false;
            }
            return new TypedOperand(result, (EdmType)ODataConstants.primitiveBoolean);
        }
        throw new ODataApplicationException("Or operator needs two binary operands", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ROOT);
    }

    public VisitorOperand equalsOperator() {
        boolean result = this.isBinaryComparisonNecessary() && this.binaryComparison(0);
        return new TypedOperand(result, (EdmType)ODataConstants.primitiveBoolean);
    }

    public VisitorOperand notEqualsOperator() {
        VisitorOperand equalsOperator = this.equalsOperator();
        return new TypedOperand((Boolean)equalsOperator.getValue() == false, (EdmType)ODataConstants.primitiveBoolean);
    }

    private boolean isBinaryComparisonNecessary() {
        return !(this.left.isNull() ^ this.right.isNull());
    }

    public VisitorOperand greaterEqualsOperator() {
        boolean result = this.isBinaryComparisonNecessary() && this.binaryComparison(1, 0);
        return new TypedOperand(result, (EdmType)ODataConstants.primitiveBoolean);
    }

    public VisitorOperand greaterThanOperator() {
        boolean result = this.isBinaryComparisonNecessary() && this.binaryComparison(1);
        return new TypedOperand(result, (EdmType)ODataConstants.primitiveBoolean);
    }

    public VisitorOperand lessEqualsOperator() {
        boolean result = this.isBinaryComparisonNecessary() && this.binaryComparison(-1, 0);
        return new TypedOperand(result, (EdmType)ODataConstants.primitiveBoolean);
    }

    public VisitorOperand lessThanOperator() {
        boolean result = this.isBinaryComparisonNecessary() && this.binaryComparison(-1);
        return new TypedOperand(result, (EdmType)ODataConstants.primitiveBoolean);
    }

    private boolean binaryComparison(int ... expect) {
        int result = this.left.isNull() && this.right.isNull() ? 0 : (this.left.isIntegerType() ? this.left.getTypedValue(BigInteger.class).compareTo(this.right.getTypedValue(BigInteger.class)) : (this.left.isDecimalType() ? this.left.getTypedValue(BigDecimal.class).compareTo(this.right.getTypedValue(BigDecimal.class)) : (this.left.getValue().getClass() == this.right.getValue().getClass() && this.left.getValue() instanceof Comparable ? ((Comparable)this.left.getValue()).compareTo(this.right.getValue()) : (this.left.getValue().equals(this.right.getValue()) ? 0 : 1))));
        for (int expectedValue : expect) {
            if (expectedValue != result) continue;
            return true;
        }
        return false;
    }

    public VisitorOperand arithmeticOperator(BinaryOperatorKind operator) throws ODataApplicationException {
        if (this.left.isNull() || this.right.isNull()) {
            return new TypedOperand(new Object(), (EdmType)EdmNull.getInstance());
        }
        if (this.left.isIntegerType()) {
            BigInteger result = this.integerArithmeticOperation(operator);
            return new TypedOperand(result, this.determineResultType(result, this.left));
        }
        if (this.left.isDecimalType()) {
            BigDecimal result = this.decimalArithmeticOperation(operator);
            return new TypedOperand(result, this.determineResultType(result, this.left));
        }
        if (this.left.is(ODataConstants.primitiveDate, ODataConstants.primitiveDuration, ODataConstants.primitiveDateTimeOffset)) {
            return this.dateArithmeticOperation(operator);
        }
        throw new ODataApplicationException("Invalid type", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ROOT);
    }

    private EdmType determineResultType(Number arithmeticResult, TypedOperand leftOperand) {
        if (leftOperand.isDecimalType()) {
            BigDecimal value = (BigDecimal)arithmeticResult;
            if (value.compareTo(ODataConstants.EDM_SINGLE_MIN) >= 0 && value.compareTo(ODataConstants.EDM_SINGLE_MAX) <= 0) {
                return ODataConstants.primitiveSingle;
            }
            return ODataConstants.primitiveDouble;
        }
        BigInteger value = (BigInteger)arithmeticResult;
        if (value.compareTo(ODataConstants.EDN_SBYTE_MAX) <= 0 && value.compareTo(ODataConstants.EDM_SBYTE_MIN) >= 0) {
            return ODataConstants.primitiveSByte;
        }
        if (value.compareTo(ODataConstants.EDM_BYTE_MAX) <= 0 && value.compareTo(ODataConstants.EDM_BYTE_MIN) >= 0) {
            return ODataConstants.primitiveByte;
        }
        if (value.compareTo(ODataConstants.EDM_INT16_MAX) <= 0 && value.compareTo(ODataConstants.EDM_INT16_MIN) >= 0) {
            return ODataConstants.primitiveInt16;
        }
        if (value.compareTo(ODataConstants.EDM_INT32_MAX) <= 0 && value.compareTo(ODataConstants.EDM_INT32_MIN) >= 0) {
            return ODataConstants.primitiveInt32;
        }
        if (value.compareTo(ODataConstants.EDM_INT64_MAX) <= 0 && value.compareTo(ODataConstants.EDM_INT64_MIN) >= 0) {
            return ODataConstants.primitiveInt64;
        }
        return ODataConstants.primitiveDouble;
    }

    private VisitorOperand dateArithmeticOperation(BinaryOperatorKind operator) throws ODataApplicationException {
        TypedOperand result = null;
        if (this.left.is(ODataConstants.primitiveDate)) {
            if (this.right.is(ODataConstants.primitiveDate) && operator == BinaryOperatorKind.SUB) {
                long millis = this.left.getTypedValue(Calendar.class).getTimeInMillis() - this.left.getTypedValue(Calendar.class).getTimeInMillis();
                result = new TypedOperand(new BigDecimal(millis).divide(ODataConstants.FACTOR_SECOND), (EdmType)ODataConstants.primitiveDuration);
            } else if (this.right.is(ODataConstants.primitiveDuration) && operator == BinaryOperatorKind.ADD) {
                long millis = this.left.getTypedValue(Calendar.class).getTimeInMillis() + this.right.getTypedValue(BigDecimal.class).longValue() * 1000L;
                result = new TypedOperand(new Timestamp(millis), (EdmType)ODataConstants.primitiveDateTimeOffset);
            } else if (this.right.is(ODataConstants.primitiveDuration) && operator == BinaryOperatorKind.SUB) {
                long millis = this.left.getTypedValue(Calendar.class).getTimeInMillis() - this.right.getTypedValue(BigDecimal.class).longValue() * 1000L;
                result = new TypedOperand(new Timestamp(millis), (EdmType)ODataConstants.primitiveDateTimeOffset);
            }
        } else if (this.left.is(ODataConstants.primitiveDuration)) {
            if (this.right.is(ODataConstants.primitiveDuration) && operator == BinaryOperatorKind.ADD) {
                long seconds = this.left.getTypedValue(BigDecimal.class).longValue() + this.right.getTypedValue(BigDecimal.class).longValue();
                result = new TypedOperand(new BigDecimal(seconds), (EdmType)ODataConstants.primitiveDuration);
            } else if (this.right.is(ODataConstants.primitiveDuration) && operator == BinaryOperatorKind.SUB) {
                long seconds = this.left.getTypedValue(BigDecimal.class).longValue() - this.right.getTypedValue(BigDecimal.class).longValue();
                result = new TypedOperand(new BigDecimal(seconds), (EdmType)ODataConstants.primitiveDuration);
            }
        } else if (this.left.is(ODataConstants.primitiveDateTimeOffset)) {
            if (this.right.is(ODataConstants.primitiveDuration) && operator == BinaryOperatorKind.ADD) {
                long millis = this.left.getTypedValue(Timestamp.class).getTime() + this.right.getTypedValue(BigDecimal.class).longValue() * 1000L;
                result = new TypedOperand(new Timestamp(millis), (EdmType)ODataConstants.primitiveDateTimeOffset);
            } else if (this.right.is(ODataConstants.primitiveDuration) && operator == BinaryOperatorKind.SUB) {
                long millis = this.left.getTypedValue(Timestamp.class).getTime() - this.right.getTypedValue(BigDecimal.class).longValue() * 1000L;
                result = new TypedOperand(new Timestamp(millis), (EdmType)ODataConstants.primitiveDateTimeOffset);
            } else if (this.right.is(ODataConstants.primitiveDateTimeOffset) && operator == BinaryOperatorKind.SUB) {
                long millis = this.left.getTypedValue(Timestamp.class).getTime() - this.right.getTypedValue(Timestamp.class).getTime();
                result = new TypedOperand(new BigDecimal(millis).divide(ODataConstants.FACTOR_SECOND), (EdmType)ODataConstants.primitiveDuration);
            }
        }
        if (result == null) {
            throw new ODataApplicationException("Invalid operation / operand", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ROOT);
        }
        return result;
    }

    private BigDecimal decimalArithmeticOperation(BinaryOperatorKind operator) throws ODataApplicationException {
        BigDecimal left = this.left.getTypedValue(BigDecimal.class);
        BigDecimal right = this.right.getTypedValue(BigDecimal.class);
        switch (operator) {
            case ADD: {
                return left.add(right);
            }
            case DIV: {
                return left.divide(right);
            }
            case MUL: {
                return left.multiply(right);
            }
            case SUB: {
                return left.subtract(right);
            }
        }
        throw new ODataApplicationException("Operator not valid", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ROOT);
    }

    private BigInteger integerArithmeticOperation(BinaryOperatorKind operator) throws ODataApplicationException {
        BigInteger left = this.left.getTypedValue(BigInteger.class);
        BigInteger right = this.right.getTypedValue(BigInteger.class);
        switch (operator) {
            case ADD: {
                return left.add(right);
            }
            case DIV: {
                return left.divide(right);
            }
            case MUL: {
                return left.multiply(right);
            }
            case SUB: {
                return left.subtract(right);
            }
            case MOD: {
                return left.mod(right);
            }
        }
        throw new ODataApplicationException("Operator not valid", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ROOT);
    }
}

