/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.validation.standard;

import org.wso2.carbon.dataservices.core.validation.standard.GenericValidator;

public class LengthValidator
extends GenericValidator {
    private int minLength;
    private int maxLength;
    private boolean hasMin;
    private boolean hasMax;

    public LengthValidator(int minLength, int maxLength, boolean hasMin, boolean hasMax) {
        super("The value length must be between " + minLength + " and " + maxLength);
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.hasMin = hasMin;
        this.hasMax = hasMax;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public boolean isHasMin() {
        return this.hasMin;
    }

    public boolean isHasMax() {
        return this.hasMax;
    }

    @Override
    protected boolean validateScalar(String value) {
        try {
            int min = this.getMinLength();
            if (this.isHasMin() && value.length() < min) {
                return false;
            }
            int max = this.getMaxLength();
            return !this.isHasMax() || value.length() <= max;
        }
        catch (Exception e) {
            return false;
        }
    }
}

