/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.validation.standard;

import org.wso2.carbon.dataservices.core.validation.standard.GenericValidator;

public class LongRangeValidator
extends GenericValidator {
    private long minimum;
    private long maximum;
    private boolean hasMin;
    private boolean hasMax;

    public LongRangeValidator(long minimum, long maximum, boolean hasMin, boolean hasMax) {
        super("The long value range expected is [" + minimum + "," + maximum + "]");
        this.minimum = minimum;
        this.maximum = maximum;
        this.hasMin = hasMin;
        this.hasMax = hasMax;
    }

    public long getMinimum() {
        return this.minimum;
    }

    public long getMaximum() {
        return this.maximum;
    }

    public boolean isHasMin() {
        return this.hasMin;
    }

    public boolean isHasMax() {
        return this.hasMax;
    }

    @Override
    protected boolean validateScalar(String value) {
        try {
            long longVal = Long.parseLong(value);
            long min = this.getMinimum();
            if (this.isHasMin() && longVal < min) {
                return false;
            }
            long max = this.getMaximum();
            return !this.isHasMax() || longVal <= max;
        }
        catch (Exception e) {
            return false;
        }
    }
}

