/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.query;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.ResultSet;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamWriter;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.SparqlEndpointConfig;
import org.wso2.carbon.dataservices.core.description.event.EventTrigger;
import org.wso2.carbon.dataservices.core.description.query.SparqlQueryBase;
import org.wso2.carbon.dataservices.core.engine.DataEntry;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.InternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.QueryParam;
import org.wso2.carbon.dataservices.core.engine.Result;

public class SparqlEndpointQuery
extends SparqlQueryBase {
    private SparqlEndpointConfig config;

    public SparqlEndpointQuery(DataService dataService, String queryId, String configId, String query, List<QueryParam> queryParams, Result result, EventTrigger inputEventTrigger, EventTrigger outputEventTrigger, Map<String, String> advancedProperties, String inputNamespace) throws DataServiceFault {
        super(dataService, queryId, configId, query, queryParams, result, inputEventTrigger, outputEventTrigger, advancedProperties, inputNamespace);
        try {
            this.config = (SparqlEndpointConfig)this.getDataService().getConfig(this.getConfigId());
        }
        catch (ClassCastException e) {
            throw new DataServiceFault(e, "Configuration is not a SPARQL Endpoint config:" + this.getConfigId());
        }
    }

    public SparqlEndpointConfig getConfig() {
        return this.config;
    }

    @Override
    public QueryExecution getQueryExecution() throws IOException, DataServiceFault {
        return QueryExecutionFactory.sparqlService((String)this.getConfig().getSparqlEndpoint(), (String)this.getQuery());
    }

    @Override
    public Object processPreQuery(InternalParamCollection params, int queryLevel) throws DataServiceFault {
        try {
            ResultSet results = null;
            QueryExecution qe = this.getQueryExecution();
            results = qe.execSelect();
            return results;
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in 'SparqlQueryBase.processQuery'");
        }
    }

    @Override
    public void processPostQuery(Object result, XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault {
        ResultSet results = (ResultSet)result;
        while (results != null && results.hasNext()) {
            DataEntry dataEntry = this.getDataEntryFromRS(results);
            this.writeResultEntry(xmlWriter, dataEntry, params, queryLevel);
        }
    }
}

