/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.engine;

import java.io.InputStream;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axis2.databinding.types.NCName;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.wso2.carbon.dataservices.common.DBConstants;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DSSessionManager;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.boxcarring.TLParamStore;
import org.wso2.carbon.dataservices.core.description.query.SQLQuery;
import org.wso2.carbon.dataservices.core.dispatch.DispatchStatus;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.ExternalParam;
import org.wso2.carbon.dataservices.core.engine.ExternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.OutputElement;
import org.wso2.carbon.dataservices.core.engine.ParamValue;

public class StaticOutputElement
extends OutputElement {
    private String originalParam;
    private String elementType;
    private QName xsdType;
    private int resultType;
    private int dataCategory;
    private String export;
    private int exportType;
    private boolean hasConstantValue;
    private boolean isUserDefinedObj;
    private UDT udtInfo;
    private static final String NON_PRINTABLE_CHARS = "[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]";

    public StaticOutputElement(DataService dataService, String name, String param, String originalParam, String paramType, String elementType, String namespace, QName xsdType, Set<String> requiredRoles, int dataCategory, int resultType, String export, int exportType, String arrayName) throws DataServiceFault {
        super(name, namespace, requiredRoles, param, paramType, arrayName);
        this.originalParam = originalParam;
        this.elementType = elementType;
        this.xsdType = xsdType;
        this.dataCategory = dataCategory;
        this.resultType = resultType;
        this.export = export;
        this.exportType = exportType;
        this.hasConstantValue = "value".equals(paramType);
        this.udtInfo = this.processParamForUserDefinedObjects(this.getParam());
        if (this.getArrayName() != null || this.getUDTInfo() != null) {
            this.isUserDefinedObj = true;
        }
        if (!NCName.isValid((String)this.getName())) {
            throw new DataServiceFault("Invalid output " + this.elementType + " name: '" + this.getName() + "', must be an NCName.");
        }
    }

    public boolean hasConstantValue() {
        return this.hasConstantValue;
    }

    public String getExport() {
        return this.export;
    }

    public int getExportType() {
        return this.exportType;
    }

    public int getDataCategory() {
        return this.dataCategory;
    }

    public int getResultType() {
        return this.resultType;
    }

    public String getOriginalParam() {
        return this.originalParam;
    }

    public QName getXsdType() {
        return this.xsdType;
    }

    public String getElementType() {
        return this.elementType;
    }

    public boolean isUserDefinedObj() {
        return this.isUserDefinedObj;
    }

    public UDT getUDTInfo() {
        return this.udtInfo;
    }

    private UDT processParamForUserDefinedObjects(String param) throws DataServiceFault {
        String udtColumnName = DBUtils.extractUDTObjectName(param);
        if (udtColumnName != null) {
            List<Integer> indices = DBUtils.getNestedIndices(param.substring(udtColumnName.length() + 1, param.length()));
            return new UDT(udtColumnName, indices);
        }
        return null;
    }

    private ParamValue getParamValue(ExternalParamCollection params) throws DataServiceFault {
        if (this.getParamType().equals("rdf-ref-uri")) {
            return new ParamValue(this.getParam());
        }
        ExternalParam paramObj = this.getParamObj(params);
        if (paramObj == null) {
            if (this.getParamType().equals("column")) {
                paramObj = params.getParam("query-param", this.getParam());
            } else if (this.getParamType().equals("query-param")) {
                paramObj = params.getParam("column", this.getParam());
            }
        }
        if (paramObj != null) {
            return paramObj.getValue();
        }
        if (this.isOptional()) {
            return null;
        }
        throw new DataServiceFault(DBConstants.FaultCodes.INCOMPATIBLE_PARAMETERS_ERROR, "Error in 'StaticOutputElement.execute', cannot find parameter with type:" + this.getParamType() + " name:" + this.getOriginalParam());
    }

    private void exportParam(String exportName, String value, int type) {
        ParamValue paramVal = TLParamStore.getParam(exportName);
        if (paramVal == null || paramVal.getValueType() != type) {
            paramVal = new ParamValue(type);
            TLParamStore.addParam(exportName, paramVal);
        }
        if (type == 2) {
            paramVal.addToArrayValue(new ParamValue(value));
        } else if (type == 1) {
            paramVal.setScalarValue(value);
        }
    }

    @Override
    public void executeElement(XMLStreamWriter xmlWriter, ExternalParamCollection params, int queryLevel, boolean escapeNonPrintableChar) throws DataServiceFault {
        ParamValue paramValue = this.hasConstantValue() ? new ParamValue(this.getParam()) : this.getParamValue(params);
        if (paramValue == null) {
            return;
        }
        if (escapeNonPrintableChar && paramValue.getScalarValue() != null) {
            paramValue.setScalarValue(paramValue.getScalarValue().replaceAll(NON_PRINTABLE_CHARS, "?"));
        }
        if (this.getExport() != null && (DSSessionManager.isBoxcarring() || DispatchStatus.isBoxcarringRequest())) {
            this.exportParam(this.getExport(), paramValue.toString(), this.getExportType());
        }
        try {
            if (this.getElementType().equals("element")) {
                this.writeResultElement(xmlWriter, this.getName(), paramValue, this.getXsdType(), this.getDataCategory(), this.getResultType(), params);
            } else if (this.getElementType().equals("attribute")) {
                this.addAttribute(xmlWriter, this.getName(), paramValue, this.getXsdType(), this.getResultType());
            }
        }
        catch (XMLStreamException e) {
            throw new DataServiceFault(e, "Error in XML generation at StaticOutputElement.execute");
        }
    }

    private ExternalParam getParamObj(ExternalParamCollection params) throws DataServiceFault {
        ExternalParam exParam = params.getParam(this.getParamType(), this.getParam());
        if (exParam != null) {
            return exParam;
        }
        if (this.isUserDefinedObj()) {
            exParam = params.getParam(this.getParamType(), this.getUDTInfo().getUDTObjName());
            ParamValue value = exParam.getValue();
            if (DBUtils.isUDT(value)) {
                ParamValue processedParamValue = this.getUDTAttributeValue(value, 0);
                return new ExternalParam(this.getParam(), processedParamValue, this.getParamType());
            }
            if (DBUtils.isSQLArray(value)) {
                ParamValue processedParamValue = new ParamValue(2);
                this.getExternalParamFromArray(processedParamValue, value);
                return new ExternalParam(this.getParam(), processedParamValue, this.getParamType());
            }
        }
        return exParam;
    }

    private void getExternalParamFromArray(ParamValue processedParamValue, ParamValue rawParamValue) throws DataServiceFault {
        for (ParamValue value : rawParamValue.getArrayValue()) {
            if (DBUtils.isUDT(value)) {
                processedParamValue.getArrayValue().add(this.getUDTAttributeValue(value, 0));
            }
            if (DBUtils.isSQLArray(value)) {
                this.getExternalParamFromArray(processedParamValue, value);
                continue;
            }
            processedParamValue.getArrayValue().add(value);
        }
    }

    private ParamValue getUDTAttributeValue(ParamValue value, int i) throws DataServiceFault {
        if (this.getUDTInfo() == null) {
            throw new DataServiceFault("Output element '" + this.getName() + "' cannot be resolved to a UDT");
        }
        List<Integer> indices = this.getUDTInfo().getIndices();
        if (DBUtils.isUDT(value)) {
            Object tmpVal;
            try {
                tmpVal = value.getUdt().getAttributes()[indices.get(i)];
            }
            catch (SQLException e) {
                throw new DataServiceFault(e, "Unable to retrieve UDT attribute value referred by the given index");
            }
            if (tmpVal instanceof Struct) {
                value = new ParamValue((Struct)tmpVal);
            } else if (tmpVal instanceof Array) {
                try {
                    value = DBUtils.processSQLArray((Array)tmpVal, new ParamValue(2));
                }
                catch (SQLException e) {
                    throw new DataServiceFault(e, "Unable to process the SQL Array");
                }
            } else {
                try {
                    if (tmpVal == null) {
                        value = new ParamValue((String)null);
                    }
                    if (tmpVal instanceof Timestamp) {
                        Timestamp timestamp = (Timestamp)tmpVal;
                        value = new ParamValue(SQLQuery.convertToTimestampString(timestamp));
                    }
                    if (tmpVal instanceof Blob) {
                        value = new ParamValue(SQLQuery.getBase64StringFromInputStream(((Blob)tmpVal).getBinaryStream()));
                    }
                    if (tmpVal instanceof Time) {
                        Time time = (Time)tmpVal;
                        value = new ParamValue(SQLQuery.convertToTimeString(time));
                    }
                    if (tmpVal instanceof Date) {
                        Date date = (Date)tmpVal;
                        value = new ParamValue(ConverterUtil.convertToString((java.util.Date)date));
                    }
                    if (tmpVal instanceof InputStream) {
                        InputStream inputStream = (InputStream)tmpVal;
                        value = new ParamValue(SQLQuery.getBase64StringFromInputStream(inputStream));
                    }
                    value = new ParamValue(String.valueOf(tmpVal));
                }
                catch (SQLException e) {
                    throw new DataServiceFault(e, "Unable to process the SQL UDT attribute value");
                }
            }
        } else if (DBUtils.isSQLArray(value)) {
            ParamValue processedParamValue = new ParamValue(2);
            for (ParamValue paramVal : value.getArrayValue()) {
                if (DBUtils.isUDT(paramVal)) {
                    try {
                        processedParamValue.getArrayValue().add(new ParamValue(String.valueOf(paramVal.getUdt().getAttributes()[indices.get(i)])));
                        continue;
                    }
                    catch (SQLException e) {
                        throw new DataServiceFault(e, "Unable to retrieve UDT attribute value referred by the given index");
                    }
                }
                processedParamValue.getArrayValue().add(paramVal);
            }
            value = processedParamValue;
        } else {
            return value;
        }
        if (i <= indices.size()) {
            return this.getUDTAttributeValue(value, i + 1);
        }
        return value;
    }

    public boolean equals(Object o) {
        return o instanceof StaticOutputElement && ((StaticOutputElement)o).getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    private class UDT {
        private String udtObjName;
        private List<Integer> indices;

        public UDT(String udtObjName, List<Integer> indices) {
            this.udtObjName = udtObjName;
            this.indices = indices;
        }

        public String getUDTObjName() {
            return this.udtObjName;
        }

        public List<Integer> getIndices() {
            return this.indices;
        }
    }
}

