/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.jmx;

import java.util.ArrayList;
import java.util.Set;
import org.wso2.carbon.dataservices.core.description.config.CSVConfig;
import org.wso2.carbon.dataservices.core.description.config.Config;
import org.wso2.carbon.dataservices.core.description.config.ExcelConfig;
import org.wso2.carbon.dataservices.core.description.config.GSpreadConfig;
import org.wso2.carbon.dataservices.core.description.config.JNDIConfig;
import org.wso2.carbon.dataservices.core.description.config.RDBMSConfig;
import org.wso2.carbon.dataservices.core.description.config.SQLCarbonDataSourceConfig;
import org.wso2.carbon.dataservices.core.description.config.SQLConfig;
import org.wso2.carbon.dataservices.core.description.operation.Operation;
import org.wso2.carbon.dataservices.core.description.query.Query;
import org.wso2.carbon.dataservices.core.description.resource.Resource;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.jmx.DataServiceInstanceMBean;

public class DataServiceInstance
implements DataServiceInstanceMBean {
    private DataService dataService;

    public DataServiceInstance(DataService dataService) {
        this.dataService = dataService;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    @Override
    public String getServiceName() {
        return this.getDataService().getName();
    }

    @Override
    public String getDataServiceDescriptorPath() {
        return this.getDataService().getDsLocation();
    }

    @Override
    public String[] getConfigIds() {
        return this.getDataService().getConfigs().keySet().toArray(new String[0]);
    }

    @Override
    public String[] getQueryIds() {
        return this.getDataService().getQueries().keySet().toArray(new String[0]);
    }

    @Override
    public String[] getOperationNames() {
        return this.getDataService().getOperationNames().toArray(new String[0]);
    }

    @Override
    public String[] getResourcePaths() {
        Set<Resource.ResourceID> resourceIds = this.getDataService().getResourceIds();
        ArrayList<String> list = new ArrayList<String>();
        for (Resource.ResourceID resourceId : resourceIds) {
            list.add(resourceId.getPath());
        }
        return list.toArray(new String[0]);
    }

    @Override
    public String[] getHTTPMethodsForResourcePath(String resPath) {
        Set<Resource.ResourceID> resourceIds = this.getDataService().getResourceIds();
        ArrayList<String> list = new ArrayList<String>();
        for (Resource.ResourceID resourceId : resourceIds) {
            if (!resourceId.getPath().equals(resPath)) continue;
            list.add(resourceId.getMethod());
        }
        return list.toArray(new String[0]);
    }

    @Override
    public String getQueryIdFromOperationName(String operationName) {
        Operation op = this.getDataService().getOperation(operationName);
        if (op != null) {
            return op.getCallQuery().getQueryId();
        }
        return null;
    }

    @Override
    public String getConfigIdFromQueryId(String queryId) {
        Query query = this.getDataService().getQuery(queryId);
        if (query != null) {
            return query.getConfigId();
        }
        return null;
    }

    @Override
    public boolean isConfigActive(String configId) {
        Config config = this.getDataService().getConfig(configId);
        if (config != null) {
            return config.isActive();
        }
        return false;
    }

    @Override
    public String getConfigTypeFromId(String configId) {
        Config config = this.getDataService().getConfig(configId);
        if (config instanceof RDBMSConfig) {
            return "RDBMS";
        }
        if (config instanceof JNDIConfig) {
            return "JNDI";
        }
        if (config instanceof SQLCarbonDataSourceConfig) {
            return "CARBON_DATASOURCE";
        }
        if (config instanceof ExcelConfig) {
            return "EXCEL";
        }
        if (config instanceof CSVConfig) {
            return "CSV";
        }
        if (config instanceof GSpreadConfig) {
            return "GDATA_SPREADSHEET";
        }
        return null;
    }

    @Override
    public boolean isDatabaseConnectionStatsAvailable(String configId) {
        Config config = this.getDataService().getConfig(configId);
        if (config instanceof SQLConfig) {
            SQLConfig sqlConfig = (SQLConfig)config;
            try {
                return sqlConfig.isStatsAvailable();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return false;
    }

    @Override
    public int getOpenDatabaseConnectionsCount(String configId) {
        Config config = this.getDataService().getConfig(configId);
        if (config instanceof SQLConfig) {
            SQLConfig sqlConfig = (SQLConfig)config;
            try {
                return sqlConfig.getActiveConnectionCount();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return -1;
    }
}

