/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.processor.reader;

import com.google.gdata.data.spreadsheet.CellEntry;
import com.google.gdata.data.spreadsheet.CellFeed;
import com.google.gdata.data.spreadsheet.WorksheetEntry;
import com.google.gdata.data.spreadsheet.WorksheetFeed;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.wso2.carbon.dataservices.sql.driver.TConnection;
import org.wso2.carbon.dataservices.sql.driver.TDriverUtil;
import org.wso2.carbon.dataservices.sql.driver.TGSpreadConnection;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.AbstractFixedDataReader;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataCell;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataRow;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataTable;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.FixedDataTable;
import org.wso2.carbon.dataservices.sql.driver.query.ColumnInfo;

public class GSpreadDataReader
extends AbstractFixedDataReader {
    public GSpreadDataReader(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    public void populateData() throws SQLException {
        int tmp = -1;
        TGSpreadConnection gsConnection = (TGSpreadConnection)this.getConnection();
        WorksheetFeed workSheetFeed = gsConnection.getWorksheetFeed();
        if (workSheetFeed == null) {
            throw new SQLException("Work sheet feed it not initialized properly and is null");
        }
        List workSheets = workSheetFeed.getEntries();
        for (WorksheetEntry workSheet : workSheets) {
            DataRow dataRow = null;
            CellFeed cellFeed = TDriverUtil.getGSpreadCellFeed((TGSpreadConnection)this.getConnection(), workSheet);
            ColumnInfo[] headers = this.extractHeaders(workSheet);
            FixedDataTable result = new FixedDataTable(workSheet.getTitle().getPlainText(), headers);
            for (CellEntry cell : cellFeed.getEntries()) {
                int columnId;
                int rowId = TDriverUtil.getRowIndex(cell.getId());
                if (tmp != rowId && rowId != 1) {
                    if (dataRow != null) {
                        ((DataTable)result).addRow(this.fillUpEmptyCells(dataRow, headers));
                    }
                    dataRow = new DataRow(rowId - 1);
                    tmp = rowId;
                }
                if ((columnId = TDriverUtil.getColumnIndex(cell.getId())) > headers.length || rowId == 1 || dataRow == null) continue;
                DataCell dataCell = new DataCell(TDriverUtil.getColumnIndex(cell.getId()), cell.getContent().getType(), cell.getTextContent().getContent().getPlainText());
                dataRow.addCell(dataCell.getColumnId(), dataCell);
            }
            if (dataRow != null) {
                ((DataTable)result).addRow(this.fillUpEmptyCells(dataRow, headers));
            }
            this.getData().put(result.getTableName(), result);
        }
    }

    private DataRow fillUpEmptyCells(DataRow row, ColumnInfo[] columns) {
        DataRow fixedRow = new DataRow(row.getRowId());
        Set<Integer> existingColumns = row.getCells().keySet();
        for (ColumnInfo column : columns) {
            if (existingColumns.contains(column.getId())) {
                fixedRow.addCell(column.getId(), row.getCell(column.getId()));
                continue;
            }
            fixedRow.addCell(column.getId(), new DataCell(column.getId(), -1, null));
        }
        return fixedRow;
    }

    private ColumnInfo[] extractHeaders(WorksheetEntry currentWorkSheet) throws SQLException {
        CellEntry cell;
        ArrayList<ColumnInfo> headers = new ArrayList<ColumnInfo>();
        if (!((TConnection)this.getConnection()).hasHeader()) {
            int maxColumns = ((TConnection)this.getConnection()).getMaxColumns();
            for (int i = 1; i < maxColumns + 1; ++i) {
                headers.add(new ColumnInfo(i, "COLUMN" + i, currentWorkSheet.getTitle().getPlainText(), -1, i));
            }
            return headers.toArray(new ColumnInfo[headers.size()]);
        }
        CellFeed cellFeed = TDriverUtil.getGSpreadCellFeed((TGSpreadConnection)this.getConnection(), currentWorkSheet);
        Iterator i$ = cellFeed.getEntries().iterator();
        while (i$.hasNext() && TDriverUtil.getCellPosition((cell = (CellEntry)i$.next()).getId()).startsWith("R1")) {
            int columnIndex = TDriverUtil.getColumnIndex(cell.getId());
            headers.add(new ColumnInfo(columnIndex, cell.getTextContent().getContent().getPlainText(), currentWorkSheet.getTitle().getPlainText(), 12, columnIndex));
        }
        return headers.toArray(new ColumnInfo[headers.size()]);
    }
}

