/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.query.create;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.wso2.carbon.dataservices.sql.driver.TDriverUtil;
import org.wso2.carbon.dataservices.sql.driver.TExcelConnection;
import org.wso2.carbon.dataservices.sql.driver.query.create.CreateQuery;

public class ExcelCreateQuery
extends CreateQuery {
    public ExcelCreateQuery(Statement stmt) throws SQLException {
        super(stmt);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeSQL();
        return null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.executeSQL();
        return 0;
    }

    @Override
    public boolean execute() throws SQLException {
        this.executeSQL();
        return false;
    }

    private synchronized void executeSQL() throws SQLException {
        TExcelConnection excelCon = (TExcelConnection)this.getConnection();
        excelCon.beginExcelTransaction();
        if (excelCon.getWorkbook() == null) {
            throw new SQLException("Connection to EXCEL data source has not been established properly");
        }
        Sheet sheet = excelCon.getWorkbook().createSheet(this.getTableName());
        Row headerRow = sheet.createRow(0);
        for (int i = 0; i < this.getColumns().size(); ++i) {
            Cell cell = headerRow.createCell(i);
            cell.setCellValue(this.getColumns().get(i).getName());
        }
        TDriverUtil.writeRecords(excelCon.getWorkbook(), excelCon.getPath());
    }
}

