/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.query.create;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.spreadsheet.CellEntry;
import com.google.gdata.data.spreadsheet.CellFeed;
import com.google.gdata.data.spreadsheet.SpreadsheetEntry;
import com.google.gdata.data.spreadsheet.WorksheetEntry;
import com.google.gdata.data.spreadsheet.WorksheetFeed;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.wso2.carbon.dataservices.sql.driver.TGSpreadConnection;
import org.wso2.carbon.dataservices.sql.driver.query.create.CreateQuery;
import org.wso2.carbon.dataservices.sql.driver.util.GSpreadFeedProcessor;

public class GSpreadCreateQuery
extends CreateQuery {
    public GSpreadCreateQuery(Statement stmt) throws SQLException {
        super(stmt);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeSQL();
        return null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.executeSQL();
        return 0;
    }

    @Override
    public boolean execute() throws SQLException {
        this.executeSQL();
        return false;
    }

    private synchronized void executeSQL() throws SQLException {
        TGSpreadConnection gspreadCon = (TGSpreadConnection)this.getConnection();
        GSpreadFeedProcessor feedProcessor = gspreadCon.getFeedProcessor();
        if (this.isWorkSheetExists(gspreadCon)) {
            throw new SQLException("A sheet named '" + this.getTableName() + "' already exists");
        }
        WorksheetEntry newWorkSheet = new WorksheetEntry();
        newWorkSheet.setTitle((TextConstruct)new PlainTextConstruct(this.getTableName()));
        newWorkSheet.setRowCount(1);
        newWorkSheet.setColCount(this.getColumns().size());
        SpreadsheetEntry currentSpreadSheet = (SpreadsheetEntry)gspreadCon.getSpreadSheetFeed().getEntries().get(0);
        feedProcessor.insert(currentSpreadSheet.getWorksheetFeedUrl(), newWorkSheet);
        WorksheetEntry currentWorkSheet = this.getCurrentWorksheetEntry(gspreadCon);
        try {
            CellFeed cellFeed = feedProcessor.getFeed(currentWorkSheet.getCellFeedUrl(), CellFeed.class);
            for (int i = 0; i < this.getColumns().size(); ++i) {
                CellEntry cell = new CellEntry(1, i + 1, this.getColumns().get(i).getName());
                cellFeed.insert((BaseEntry)cell);
            }
        }
        catch (IOException e) {
            throw new SQLException("Error occurred while adding column header to the sheet '" + this.getTableName() + "'", e);
        }
        catch (ServiceException e) {
            throw new SQLException("Error occurred while adding column header to the sheet '" + this.getTableName() + "'", e);
        }
    }

    private boolean isWorkSheetExists(TGSpreadConnection conn) {
        WorksheetFeed worksheetFeed = conn.getWorksheetFeed();
        for (WorksheetEntry worksheet : worksheetFeed.getEntries()) {
            if (!this.getTableName().equals(worksheet.getTitle().getPlainText())) continue;
            return true;
        }
        return false;
    }

    private WorksheetEntry getCurrentWorksheetEntry(TGSpreadConnection conn) throws SQLException {
        WorksheetEntry currentWorksheetEntry = null;
        SpreadsheetEntry currentSpreadsheetEntry = (SpreadsheetEntry)conn.getSpreadSheetFeed().getEntries().get(0);
        WorksheetFeed worksheetFeed = conn.getFeedProcessor().getFeed(currentSpreadsheetEntry.getWorksheetFeedUrl(), WorksheetFeed.class);
        for (WorksheetEntry worksheetEntry : worksheetFeed.getEntries()) {
            if (!this.getTableName().equals(worksheetEntry.getTitle().getPlainText())) continue;
            currentWorksheetEntry = worksheetEntry;
            break;
        }
        return currentWorksheetEntry;
    }
}

