/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.parser;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.wso2.carbon.dataservices.sql.driver.parser.EntityList;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataRow;
import org.wso2.carbon.dataservices.sql.driver.query.ParamInfo;

public class ParserUtil {
    private static List<String> keyWords = new EntityList();
    private static List<String> operators = new EntityList();
    private static List<String> delimiters = new EntityList();
    private static List<String> stringFunctions = new EntityList();
    private static List<String> aggregateFunctions = new EntityList();
    private static List<String> dmlTypes = new EntityList();
    private static List<String> conditionalOperators = new EntityList();

    public static List<String> getConditionalOperatorList() {
        return conditionalOperators;
    }

    public static List<String> getKeyWordList() {
        return keyWords;
    }

    public static List<String> getDMLTypeList() {
        return dmlTypes;
    }

    public static List<String> getDelimiterList() {
        return delimiters;
    }

    public static List<String> getOperatorList() {
        return operators;
    }

    public static List<String> getAggregateFunctionList() {
        return aggregateFunctions;
    }

    public static List<String> getStringFunctionList() {
        return stringFunctions;
    }

    public static boolean isDelimiter(String token) {
        return ParserUtil.getDelimiterList().contains(token);
    }

    public static boolean isOperator(String token) {
        return ParserUtil.getOperatorList().contains(token);
    }

    public static boolean isAggregateFunction(String token) {
        return ParserUtil.getAggregateFunctionList().contains(token);
    }

    public static boolean isStringFunction(String token) {
        return ParserUtil.getStringFunctionList().contains(token);
    }

    public static boolean isKeyword(String token) {
        return ParserUtil.getKeyWordList().contains(token);
    }

    public static boolean isStringLiteral(String token) {
        return !ParserUtil.isDelimiter(token) && !ParserUtil.isOperator(token) && !ParserUtil.isKeyword(token);
    }

    public static synchronized Queue<String> getTokens(String sql) throws SQLException {
        boolean isQuoted = false;
        StringBuilder token = new StringBuilder();
        LinkedList<String> tokenQueue = new LinkedList<String>();
        char[] inputCharacters = new char[sql.length()];
        sql.getChars(0, sql.length(), inputCharacters, 0);
        for (char c : inputCharacters) {
            String tmp = Character.valueOf(c).toString();
            if ("'".equals(tmp)) {
                boolean bl = isQuoted = !isQuoted;
                if (token.length() > 0) {
                    tokenQueue.add(token.toString());
                }
                tokenQueue.add("" + c);
                token = new StringBuilder();
                continue;
            }
            if (isQuoted) {
                token.append(c);
                continue;
            }
            if (!ParserUtil.isControlCharacter(tmp)) {
                if (!" ".equals(tmp)) {
                    token.append(c);
                    continue;
                }
                if (!" ".equals(tmp)) continue;
                if (token.length() > 0) {
                    tokenQueue.add(token.toString());
                }
                token = new StringBuilder();
                continue;
            }
            if (token.length() > 0) {
                tokenQueue.add(token.toString());
            }
            tokenQueue.add("" + c);
            token = new StringBuilder();
        }
        if (token.length() > 0) {
            tokenQueue.add(token.toString());
        }
        return tokenQueue;
    }

    public static boolean isControlCharacter(String token) {
        return ParserUtil.isDelimiter(token) || ParserUtil.isOperator(token);
    }

    public static boolean isDMLStatement(String type) {
        return ParserUtil.getDMLTypeList().contains(type.toUpperCase());
    }

    public static ParamInfo[] extractParameters(String sql) {
        ArrayList<ParamInfo> tmp = new ArrayList<ParamInfo>();
        int idx = 0;
        char[] s = sql.toCharArray();
        for (int i = 0; i < s.length; ++i) {
            char c = s[i];
            if (c != '?') continue;
            ParamInfo param = new ParamInfo(idx, null);
            tmp.add(param);
            ++idx;
        }
        return tmp.toArray(new ParamInfo[tmp.size()]);
    }

    public static String extractFirstKeyword(String sql) {
        char c;
        char[] s = sql.toCharArray();
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < s.length && (c = s[i]) != ' '; ++i) {
            b.append(c);
        }
        String token = b.toString();
        return ParserUtil.isKeyword(token) ? token : null;
    }

    public static ParamInfo getParameter(int orinal, ParamInfo[] parameters) {
        ParamInfo result = null;
        for (ParamInfo paramInfo : parameters) {
            if (paramInfo.getOrdinal() != orinal) continue;
            result = paramInfo;
        }
        return result;
    }

    public static ParamInfo getParameter(String column, ParamInfo[] parameters) {
        ParamInfo result = null;
        for (ParamInfo paramInfo : parameters) {
            if (!paramInfo.getName().equals(column)) continue;
            result = paramInfo;
        }
        return result;
    }

    public static Map<Integer, DataRow> mergeRows(String operation, Map<Integer, DataRow> rows1, Map<Integer, DataRow> rows2) {
        Map<Object, Object> result = new HashMap();
        if (operation == null) {
            if (rows1 != null) {
                result = rows1;
            } else if (rows2 != null) {
                result = rows2;
            }
        } else if ("OR".equals(operation)) {
            result = ParserUtil.processORCondition(rows1, rows2);
        } else if ("AND".equals(operation)) {
            result = ParserUtil.processANDCondition(rows1, rows2);
        }
        return result;
    }

    public static Map<Integer, DataRow> processORCondition(Map<Integer, DataRow> rows1, Map<Integer, DataRow> rows2) {
        HashMap<Integer, DataRow> result = new HashMap<Integer, DataRow>();
        for (Map.Entry<Integer, DataRow> row : rows1.entrySet()) {
            result.put(row.getKey(), row.getValue());
        }
        for (Map.Entry<Integer, DataRow> row : rows2.entrySet()) {
            result.put(row.getKey(), row.getValue());
        }
        return result;
    }

    public static Map<Integer, DataRow> processANDCondition(Map<Integer, DataRow> rows1, Map<Integer, DataRow> rows2) {
        HashMap<Integer, DataRow> result = new HashMap<Integer, DataRow>();
        for (Map.Entry<Integer, DataRow> row : rows1.entrySet()) {
            if (!rows2.containsKey(row.getKey())) continue;
            result.put(row.getKey(), row.getValue());
        }
        return result;
    }

    static {
        keyWords.add("COUNT");
        keyWords.add("SELECT");
        keyWords.add("FROM");
        keyWords.add("WHERE");
        keyWords.add("MAX");
        keyWords.add("INSERT");
        keyWords.add("INTO");
        keyWords.add("VALUES");
        keyWords.add("GROUP BY");
        keyWords.add("ORDER_BY");
        keyWords.add("DISTINCT");
        keyWords.add("UPDATE");
        keyWords.add("SET");
        keyWords.add("IN");
        keyWords.add("AND");
        keyWords.add("DELAYED");
        keyWords.add("LOW_PRIORITY");
        keyWords.add("HIGH_PRIORITY");
        keyWords.add("ON");
        keyWords.add("DUPLICATE");
        keyWords.add("KEY");
        keyWords.add("LAST_INSERT_ID");
        keyWords.add("ALL");
        keyWords.add("DISTINCTROW");
        keyWords.add("STRAIGHT_JOIN");
        keyWords.add("SQL_SMALL_RESULT");
        keyWords.add("SQL_BIG_RESULT");
        keyWords.add("SQL_BUFFER_RESULT");
        keyWords.add("SQL_CACHE");
        keyWords.add("SQL_NO_CACHE");
        keyWords.add("SQL_CALC_FOUND_ROWS");
        keyWords.add("ASC");
        keyWords.add("DESC");
        keyWords.add("OFFSET");
        keyWords.add("LIMIT");
        keyWords.add("WITH");
        keyWords.add("ROLLUP");
        keyWords.add("PROCEDURE");
        keyWords.add("OUTFILE");
        keyWords.add("DUMPFILE");
        keyWords.add("LOCK");
        keyWords.add("SHARE");
        keyWords.add("MODE");
        keyWords.add("CONCAT");
        keyWords.add("AS");
        keyWords.add("AVG");
        keyWords.add("MIN");
        keyWords.add("IS");
        keyWords.add("NULL");
        keyWords.add("LIKE");
        keyWords.add("OR");
        keyWords.add("JOIN");
        keyWords.add("INNER");
        keyWords.add("SUM");
        keyWords.add("VALUE");
        keyWords.add("DELETE");
        keyWords.add("CREATE");
        keyWords.add("SHEET");
        keyWords.add("DROP");
        operators.add("=");
        operators.add("-");
        operators.add("+");
        operators.add("/");
        operators.add("*");
        operators.add(">");
        operators.add("/");
        delimiters.add(",");
        delimiters.add("<");
        delimiters.add("'");
        delimiters.add(";");
        delimiters.add(":");
        delimiters.add(".");
        delimiters.add("{");
        delimiters.add("(");
        delimiters.add("}");
        delimiters.add(")");
        delimiters.add("`");
        delimiters.add("\n");
        delimiters.add("\r");
        aggregateFunctions.add("AVG");
        aggregateFunctions.add("MAX");
        aggregateFunctions.add("MIN");
        aggregateFunctions.add("COUNT");
        aggregateFunctions.add("SUM");
        stringFunctions.add("TRIM");
        stringFunctions.add("RTRIM");
        stringFunctions.add("LTRIM");
        stringFunctions.add("SUBSTR");
        stringFunctions.add("CONCAT");
        dmlTypes.add("INSERT");
        dmlTypes.add("UPDATE");
        dmlTypes.add("DELETE");
        conditionalOperators.add("AND");
        conditionalOperators.add("OR");
    }
}

