/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver;

import com.google.gdata.client.Query;
import com.google.gdata.client.spreadsheet.CellQuery;
import com.google.gdata.client.spreadsheet.ListQuery;
import com.google.gdata.client.spreadsheet.SpreadsheetQuery;
import com.google.gdata.client.spreadsheet.WorksheetQuery;
import com.google.gdata.data.spreadsheet.CellEntry;
import com.google.gdata.data.spreadsheet.CellFeed;
import com.google.gdata.data.spreadsheet.ListFeed;
import com.google.gdata.data.spreadsheet.SpreadsheetEntry;
import com.google.gdata.data.spreadsheet.WorksheetEntry;
import com.google.gdata.data.spreadsheet.WorksheetFeed;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.dataservices.sql.driver.TConnection;
import org.wso2.carbon.dataservices.sql.driver.TCustomConnection;
import org.wso2.carbon.dataservices.sql.driver.TExcelConnection;
import org.wso2.carbon.dataservices.sql.driver.TGSpreadConnection;
import org.wso2.carbon.dataservices.sql.driver.internal.SQLDriverDSComponent;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataTable;
import org.wso2.carbon.dataservices.sql.driver.query.ColumnInfo;
import org.wso2.carbon.dataservices.sql.driver.query.ParamInfo;
import org.wso2.carbon.dataservices.sql.driver.query.QueryFactory;
import org.wso2.carbon.dataservices.sql.driver.util.WorkBookOutputWriter;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class TDriverUtil {
    private static List<String> driverProperties = new ArrayList<String>();
    public static final String GOV_REGISTRY_PATH_PREFIX = "gov:";
    public static final String CONF_REGISTRY_PATH_PREFIX = "conf:";

    public static List<String> getAvailableDriverProperties() {
        return driverProperties;
    }

    public static ColumnInfo[] getHeaders(Connection connection, String tableName) throws SQLException {
        if (!(connection instanceof TConnection)) {
            throw new SQLException("Invalid connection type");
        }
        String connectionType = ((TConnection)connection).getType();
        QueryFactory.QueryTypes type = QueryFactory.QueryTypes.valueOf(connectionType.toUpperCase());
        switch (type) {
            case EXCEL: {
                return TDriverUtil.getExcelHeaders(connection, tableName);
            }
            case GSPREAD: {
                return TDriverUtil.getGSpreadHeaders(connection, tableName);
            }
            case CUSTOM: {
                return TDriverUtil.getCustomHeaders(connection, tableName);
            }
        }
        throw new SQLException("Invalid query type: " + (Object)((Object)type));
    }

    private static ColumnInfo[] getExcelHeaders(Connection connection, String tableName) throws SQLException {
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        if (!(connection instanceof TExcelConnection)) {
            throw new SQLException("Invalid connection type");
        }
        Workbook workbook = ((TExcelConnection)connection).getWorkbook();
        Sheet sheet = workbook.getSheet(tableName);
        if (sheet == null) {
            throw new SQLException("Sheet '" + tableName + "' does not exist");
        }
        Iterator cellItr = sheet.getRow(0).cellIterator();
        while (cellItr.hasNext()) {
            Cell header = (Cell)cellItr.next();
            ColumnInfo column = new ColumnInfo(header.getStringCellValue());
            column.setTableName(tableName);
            column.setSqlType(header.getCellType());
            column.setId(header.getColumnIndex());
            columns.add(column);
        }
        return columns.toArray(new ColumnInfo[columns.size()]);
    }

    private static ColumnInfo[] getGSpreadHeaders(Connection connection, String sheetName) throws SQLException {
        CellEntry cell;
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        if (!(connection instanceof TGSpreadConnection)) {
            throw new SQLException("Invalid connection type");
        }
        WorksheetEntry currentWorksheet = TDriverUtil.getCurrentWorkSheetEntry((TGSpreadConnection)connection, sheetName);
        if (currentWorksheet == null) {
            throw new SQLException("Worksheet '" + sheetName + "' does not exist");
        }
        CellFeed cellFeed = TDriverUtil.getGSpreadCellFeed((TGSpreadConnection)connection, currentWorksheet);
        Iterator i$ = cellFeed.getEntries().iterator();
        while (i$.hasNext() && TDriverUtil.getCellPosition((cell = (CellEntry)i$.next()).getId()).startsWith("R1")) {
            ColumnInfo column = new ColumnInfo(cell.getTextContent().getContent().getPlainText());
            column.setTableName(sheetName);
            column.setSqlType(cell.getContent().getType());
            column.setId(TDriverUtil.getColumnIndex(cell.getId()) - 1);
            columns.add(column);
        }
        return columns.toArray(new ColumnInfo[columns.size()]);
    }

    public static WorksheetEntry getCurrentWorkSheetEntry(TGSpreadConnection connection, String sheetName) throws SQLException {
        SpreadsheetEntry spreadsheetEntry = (SpreadsheetEntry)connection.getSpreadSheetFeed().getEntries().get(0);
        WorksheetQuery worksheetQuery = TDriverUtil.createWorkSheetQuery(spreadsheetEntry.getWorksheetFeedUrl());
        WorksheetFeed worksheetFeed = connection.getFeedProcessor().getFeed((Query)worksheetQuery, WorksheetFeed.class);
        for (WorksheetEntry entry : worksheetFeed.getEntries()) {
            if (!sheetName.equals(entry.getTitle().getPlainText())) continue;
            return entry;
        }
        return null;
    }

    public static CellFeed getGSpreadCellFeed(TGSpreadConnection connection, WorksheetEntry currentWorkSheet) throws SQLException {
        CellQuery cellQuery = new CellQuery(currentWorkSheet.getCellFeedUrl());
        return connection.getFeedProcessor().getFeed((Query)cellQuery, CellFeed.class);
    }

    public static ListFeed getListFeed(TGSpreadConnection connection, WorksheetEntry currentWorkSheet) throws SQLException {
        ListQuery listQuery = new ListQuery(currentWorkSheet.getListFeedUrl());
        return connection.getFeedProcessor().getFeed((Query)listQuery, ListFeed.class);
    }

    private static ColumnInfo[] getCustomHeaders(Connection connection, String sheetName) throws SQLException {
        DataTable table = ((TCustomConnection)connection).getDataSource().getDataTable(sheetName);
        return table.getHeaders();
    }

    public static int getColumnIndex(String id) {
        String tmp = TDriverUtil.getCellPosition(id);
        id = tmp.substring(tmp.indexOf("C"), tmp.length()).substring(1);
        return Integer.parseInt(id);
    }

    public static int getRowIndex(String id) {
        String tmp = TDriverUtil.getCellPosition(id);
        id = tmp.substring(tmp.indexOf("R") + 1, tmp.indexOf("C"));
        return Integer.parseInt(id);
    }

    public static String getCellPosition(String id) {
        return id.substring(id.lastIndexOf("/") + 1);
    }

    public static SpreadsheetQuery createSpreadSheetQuery(String spreadSheetName, URL spreadSheetFeedUrl) {
        SpreadsheetQuery spreadsheetQuery = new SpreadsheetQuery(spreadSheetFeedUrl);
        spreadsheetQuery.setTitleQuery(spreadSheetName);
        spreadsheetQuery.setTitleExact(true);
        return spreadsheetQuery;
    }

    public static WorksheetQuery createWorkSheetQuery(URL workSheetFeedUrl) {
        return new WorksheetQuery(workSheetFeedUrl);
    }

    public static ParamInfo findParam(ColumnInfo columnInfo, ParamInfo[] params) {
        ParamInfo param = null;
        for (ParamInfo tmpParam : params) {
            if (!columnInfo.getName().equals(tmpParam.getName())) continue;
            param = tmpParam;
            break;
        }
        return param;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeRecords(Workbook workbook, String filePath) throws SQLException {
        OutputStream out = null;
        PipedInputStream pin = null;
        try {
            if (TDriverUtil.isRegistryPath(filePath)) {
                try {
                    UserRegistry registry;
                    RegistryService registryService = SQLDriverDSComponent.getRegistryService();
                    if (registryService == null) {
                        throw new SQLException("DBUtils.getInputStreamFromPath(): Registry service is not available");
                    }
                    if (filePath.startsWith(CONF_REGISTRY_PATH_PREFIX)) {
                        if (filePath.length() <= CONF_REGISTRY_PATH_PREFIX.length()) throw new SQLException("Empty configuration registry path given");
                        filePath = filePath.substring(CONF_REGISTRY_PATH_PREFIX.length());
                        registry = registryService.getConfigSystemRegistry(TDriverUtil.getCurrentTenantId());
                    } else {
                        if (filePath.length() <= GOV_REGISTRY_PATH_PREFIX.length()) throw new SQLException("Empty governance registry path given");
                        filePath = filePath.substring(GOV_REGISTRY_PATH_PREFIX.length());
                        registry = registryService.getGovernanceSystemRegistry(TDriverUtil.getCurrentTenantId());
                    }
                    if (!registry.resourceExists(filePath)) throw new SQLException("The given XSLT resource path at '" + filePath + "' does not exist");
                    pin = new PipedInputStream();
                    out = new PipedOutputStream(pin);
                    new WorkBookOutputWriter(workbook, out).start();
                    Resource serviceResource = registry.get(filePath);
                    serviceResource.setContentStream((InputStream)pin);
                    registry.put(filePath, serviceResource);
                    return;
                }
                catch (RegistryException e) {
                    throw new SQLException(e);
                }
            }
            File file = new File(filePath);
            if (filePath.startsWith("." + File.separator) || filePath.startsWith(".." + File.separator)) {
                filePath = file.getAbsolutePath();
            }
            out = new FileOutputStream(filePath);
            workbook.write(out);
            return;
        }
        catch (FileNotFoundException e) {
            throw new SQLException("Error occurred while locating the EXCEL datasource", e);
        }
        catch (IOException e) {
            throw new SQLException("Error occurred while writing the records to the EXCEL data source", e);
        }
        finally {
            if (pin != null) {
                try {
                    pin.close();
                }
                catch (IOException ignore) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InputStream getInputStreamFromPath(String path) throws IOException, SQLException {
        if (path.startsWith("http://")) {
            URL url = new URL(path);
            return url.openStream();
        }
        if (TDriverUtil.isRegistryPath(path)) {
            try {
                UserRegistry registry;
                RegistryService registryService = SQLDriverDSComponent.getRegistryService();
                if (registryService == null) {
                    throw new SQLException("DBUtils.getInputStreamFromPath(): Registry service is not available");
                }
                if (path.startsWith(CONF_REGISTRY_PATH_PREFIX)) {
                    if (path.length() <= CONF_REGISTRY_PATH_PREFIX.length()) throw new SQLException("Empty configuration registry path given");
                    path = path.substring(CONF_REGISTRY_PATH_PREFIX.length());
                    registry = registryService.getConfigSystemRegistry(TDriverUtil.getCurrentTenantId());
                } else {
                    if (path.length() <= GOV_REGISTRY_PATH_PREFIX.length()) throw new SQLException("Empty governance registry path given");
                    path = path.substring(GOV_REGISTRY_PATH_PREFIX.length());
                    registry = registryService.getGovernanceSystemRegistry(TDriverUtil.getCurrentTenantId());
                }
                if (!registry.resourceExists(path)) throw new SQLException("The given XSLT resource path at '" + path + "' does not exist");
                Resource serviceResource = registry.get(path);
                return serviceResource.getContentStream();
            }
            catch (RegistryException e) {
                throw new SQLException(e);
            }
        }
        File file = new File(path);
        if (!path.startsWith("." + File.separator)) {
            if (!path.startsWith(".." + File.separator)) return new FileInputStream(path);
        }
        path = file.getAbsolutePath();
        return new FileInputStream(path);
    }

    public static boolean isRegistryPath(String path) {
        return path.startsWith(CONF_REGISTRY_PATH_PREFIX) || path.startsWith(GOV_REGISTRY_PATH_PREFIX);
    }

    public static int getCurrentTenantId() {
        try {
            int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            if (tenantId == -1) {
                throw new RuntimeException("Tenant id cannot be -1");
            }
            return tenantId;
        }
        catch (NoClassDefFoundError e) {
            return -1234;
        }
        catch (ExceptionInInitializerError e) {
            return -1234;
        }
    }

    static {
        driverProperties.add("filePath");
        driverProperties.add("sheetName");
        driverProperties.add("visibility");
        driverProperties.add("hasHeader");
        driverProperties.add("USER");
        driverProperties.add("PASSWORD");
        driverProperties.add("dsType");
        driverProperties.add("maxColumns");
        driverProperties.add("clientId");
        driverProperties.add("clientSecret");
        driverProperties.add("refreshToken");
    }
}

