/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.parser;

import java.sql.SQLException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.wso2.carbon.dataservices.sql.driver.parser.ParserUtil;

public class Parser {
    private static final String DELIMITER = ";";

    public static Queue<String> parse(String sql, String type) throws SQLException {
        QueryTypes types = QueryTypes.valueOf(type);
        Queue<String> tokens = ParserUtil.getTokens(sql);
        ConcurrentLinkedQueue<String> processed = new ConcurrentLinkedQueue<String>();
        switch (types) {
            case SELECT: {
                Parser.parseSelect(tokens, processed);
                break;
            }
            case INSERT: {
                Parser.parseInsert(tokens, processed);
                break;
            }
            case UPDATE: {
                Parser.parseUpdate(tokens, processed);
                break;
            }
            case DELETE: {
                Parser.parseDelete(tokens, processed);
                break;
            }
            case CREATE: {
                Parser.parseCreate(tokens, processed);
                break;
            }
            case DROP: {
                Parser.parseDrop(tokens, processed);
                break;
            }
            default: {
                throw new SQLException("Query type unsupported");
            }
        }
        return processed;
    }

    private static void parseDrop(Queue<String> tokens, Queue<String> processedTokens) throws SQLException {
        if (!"DROP".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("Syntax Error : 'DROP' keyword is expected");
        }
        processedTokens.add(tokens.poll().toUpperCase());
        if (!"SHEET".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("Syntax Error : 'SHEET' keyword is expected");
        }
        processedTokens.add(tokens.poll().toUpperCase());
        if (!ParserUtil.isStringLiteral(tokens.peek())) {
            throw new SQLException("Syntax Error : String literal is expected");
        }
        processedTokens.add("TABLE");
        processedTokens.add(tokens.poll());
        Parser.processDelimiter(tokens);
        if (!tokens.isEmpty()) {
            throw new SQLException("Syntax Error : Unusual end to the statement");
        }
    }

    private static void parseCreate(Queue<String> tokens, Queue<String> processedTokens) throws SQLException {
        if (!"CREATE".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("Syntax Error : 'CREATE' keyword is expected");
        }
        processedTokens.add(tokens.poll().toUpperCase());
        if (!"SHEET".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("Syntax Error : 'SHEET' keyword is expected");
        }
        processedTokens.add(tokens.poll().toUpperCase());
        if (!ParserUtil.isStringLiteral(tokens.peek())) {
            throw new SQLException("Syntax Error : String literal is expected");
        }
        processedTokens.add("TABLE");
        processedTokens.add(tokens.poll());
        if (tokens.isEmpty()) {
            return;
        }
        if (!"(".equals(tokens.peek())) {
            throw new SQLException("Syntax Error : '(' is expected");
        }
        tokens.poll();
        Parser.processColumnNames(tokens, processedTokens);
        if (!")".equals(tokens.peek())) {
            throw new SQLException("Syntax Error : ')' is expected");
        }
    }

    private static void processColumnNames(Queue<String> tokens, Queue<String> processedTokens) throws SQLException {
        if (!ParserUtil.isStringLiteral(tokens.peek())) {
            throw new SQLException("Syntax Error : String literal is expected");
        }
        processedTokens.add("COLUMN");
        processedTokens.add(tokens.poll());
        if (",".equals(tokens.peek())) {
            tokens.poll();
            Parser.processColumnNames(tokens, processedTokens);
        }
    }

    private static void parseSelect(Queue<String> tokens, Queue<String> processed) throws SQLException {
        if (!"SELECT".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("Syntax Error : 'SELECT' keyword is expected");
        }
        processed.add(tokens.poll().toUpperCase());
        Parser.processSelectedColumns(tokens, processed);
        Parser.processFromClause(tokens, processed);
        if (tokens.isEmpty()) {
            return;
        }
        Parser.processWhereClause(tokens, processed);
    }

    private static void processSelectedColumns(Queue<String> tokens, Queue<String> processed) throws SQLException {
        if ("*".equalsIgnoreCase(tokens.peek())) {
            processed.add(tokens.poll());
            return;
        }
        if (ParserUtil.isStringLiteral(tokens.peek())) {
            processed.add("COLUMN");
            processed.add(tokens.poll());
            if (",".equalsIgnoreCase(tokens.peek())) {
                tokens.poll();
                Parser.processSelectedColumns(tokens, processed);
            }
        }
    }

    private static void processSelectClause(Queue<String> tokens, Queue<String> processed) throws SQLException {
        if (ParserUtil.isAggregateFunction(tokens.peek()) || ParserUtil.isStringFunction(tokens.peek())) {
            if (ParserUtil.isAggregateFunction(tokens.peek())) {
                String aggFunction = tokens.poll();
                processed.add("AGGREGATEFUNC");
                processed.add(aggFunction);
                if (!tokens.isEmpty()) {
                    throw new SQLException("Syntax Error");
                }
                Parser.processSelectClause(tokens, processed);
            } else {
                String strFunction = tokens.poll();
                processed.add("STRINGFUNC");
                processed.add(strFunction);
                if (!tokens.isEmpty()) {
                    throw new SQLException("Syntax Error");
                }
                Parser.processSelectClause(tokens, processed);
            }
        } else if (tokens.peek().equalsIgnoreCase("(")) {
            tokens.poll();
            processed.add("START_OF_LBRACKET");
            if (!tokens.isEmpty()) {
                throw new SQLException("Syntax Error");
            }
            Parser.processSelectClause(tokens, processed);
        } else if (tokens.peek().equalsIgnoreCase(")")) {
            tokens.poll();
            processed.add("START_OF_RBRACKET");
            if (!tokens.isEmpty()) {
                throw new SQLException("Syntax Error");
            }
            Parser.processSelectClause(tokens, processed);
        } else if (tokens.peek().equalsIgnoreCase("'")) {
            StringBuilder sb = new StringBuilder();
            tokens.poll();
            while (!tokens.peek().equalsIgnoreCase("'")) {
                sb.append(tokens.poll());
            }
            processed.add("OPVALUE");
            processed.add(sb.toString());
            tokens.poll();
            if (!tokens.isEmpty()) {
                throw new SQLException("Syntax Error");
            }
            Parser.processSelectClause(tokens, processed);
        } else if (tokens.peek().equalsIgnoreCase(",")) {
            tokens.poll();
            if (!tokens.isEmpty()) {
                throw new SQLException("Syntax Error");
            }
            Parser.processSelectClause(tokens, processed);
        } else if (tokens.peek().equalsIgnoreCase("AS")) {
            tokens.poll();
            if (ParserUtil.isStringLiteral(tokens.peek())) {
                StringBuilder sb = new StringBuilder();
                while (!tokens.isEmpty() && !tokens.peek().equalsIgnoreCase(",")) {
                    sb.append(tokens.poll());
                }
                processed.add("ASREF");
                processed.add(sb.toString());
                if (!tokens.isEmpty()) {
                    throw new SQLException("Syntax Error");
                }
                Parser.processSelectClause(tokens, processed);
            }
        } else {
            String strRef = tokens.poll();
            if (!tokens.isEmpty()) {
                if (tokens.peek().equalsIgnoreCase(".")) {
                    processed.add("TABLE");
                    processed.add(strRef);
                    tokens.poll();
                    if (!ParserUtil.isStringLiteral(tokens.peek())) {
                        throw new SQLException("Token is not a string literal");
                    }
                    String columnRef = tokens.poll();
                    processed.add("COLUMN");
                    processed.add(columnRef);
                    if (!tokens.isEmpty()) {
                        throw new SQLException("Syntax Error");
                    }
                    if (tokens.peek().equalsIgnoreCase(",")) {
                        tokens.poll();
                        if (!tokens.isEmpty()) {
                            throw new SQLException("Syntax Error");
                        }
                        Parser.processSelectClause(tokens, processed);
                    } else if (tokens.peek().equalsIgnoreCase(")")) {
                        if (!tokens.isEmpty()) {
                            throw new SQLException("Syntax Error");
                        }
                        Parser.processSelectClause(tokens, processed);
                    }
                } else if (tokens.peek().equalsIgnoreCase(",")) {
                    processed.add("COLUMN");
                    processed.add(strRef);
                    tokens.poll();
                    if (tokens.isEmpty()) {
                        throw new SQLException("Syntax Error");
                    }
                    Parser.processSelectClause(tokens, processed);
                } else if (tokens.peek().equalsIgnoreCase("AS")) {
                    processed.add("COLUMN");
                    processed.add(strRef);
                    tokens.poll();
                    processed.add("ASCOLUMN");
                    processed.add(tokens.poll());
                    if (tokens.isEmpty()) {
                        throw new SQLException("Syntax Error");
                    }
                    Parser.processSelectClause(tokens, processed);
                } else {
                    if (!ParserUtil.isStringLiteral(tokens.peek())) {
                        return;
                    }
                    processed.add("COLUMN");
                    processed.add(strRef);
                    if (tokens.isEmpty()) {
                        throw new SQLException("Syntax Error");
                    }
                    Parser.processSelectClause(tokens, processed);
                }
            } else {
                processed.add("COLUMN");
                processed.add(strRef);
            }
        }
    }

    private static void processFromClause(Queue<String> tokens, Queue<String> processed) throws SQLException {
        if (!"FROM".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("Syntax Error : 'FROM' keyword is missing");
        }
        processed.add(tokens.poll().toUpperCase());
        if (!ParserUtil.isStringLiteral(tokens.peek())) {
            throw new SQLException("Syntax Error : String literal is expected");
        }
        processed.add("TABLE");
        processed.add(tokens.poll());
        if (",".equalsIgnoreCase(tokens.peek()) || "JOIN".equalsIgnoreCase(tokens.peek()) || "INNER".equalsIgnoreCase(tokens.peek()) || "OUTER".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("JOINs are not supported");
        }
    }

    private static void processWhereClause(Queue<String> tokens, Queue<String> processed) throws SQLException {
        if (!"WHERE".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("Syntax Error : 'WHERE' keyword is expected");
        }
        processed.add(tokens.poll().toUpperCase());
        Parser.processConditions(tokens, processed);
    }

    private static void processConditions(Queue<String> tokens, Queue<String> processed) throws SQLException {
        if (!tokens.isEmpty() && "(".equals(tokens.peek())) {
            processed.add(tokens.poll());
            if ("(".equals(tokens.peek())) {
                Parser.processConditions(tokens, processed);
            }
            if (!ParserUtil.isStringLiteral(tokens.peek())) {
                throw new SQLException("Syntax Error : String literal expected");
            }
            processed.add("COLUMN");
            processed.add(tokens.poll());
            processed.add("OPERATOR");
            processed.add(tokens.poll());
            Parser.processColumnValue(tokens, processed);
            if (!tokens.isEmpty() && ")".equals(tokens.peek())) {
                processed.add(tokens.poll());
            }
            if (tokens.isEmpty()) {
                return;
            }
            if (!"OR".equals(tokens.peek()) && !"AND".equals(tokens.peek())) {
                throw new SQLException("Syntax Error : 'OR' or 'AND' keyword is expected");
            }
            processed.add(tokens.poll());
            Parser.processConditions(tokens, processed);
        } else if (!tokens.isEmpty() && ParserUtil.isStringLiteral(tokens.peek())) {
            processed.add("COLUMN");
            processed.add(tokens.poll());
            processed.add("OPERATOR");
            processed.add(tokens.poll());
            Parser.processColumnValue(tokens, processed);
            if (!tokens.isEmpty() && ")".equals(tokens.peek())) {
                Parser.processConditions(tokens, processed);
            }
            if (!tokens.isEmpty()) {
                if (!"OR".equals(tokens.peek()) && !"AND".equals(tokens.peek())) {
                    throw new SQLException("Syntax Error : 'OR' or 'AND' keyword is expected");
                }
                processed.add(tokens.poll());
                Parser.processConditions(tokens, processed);
            }
        } else if (!tokens.isEmpty() && ")".equals(tokens.peek())) {
            processed.add(tokens.poll());
            if (!tokens.isEmpty() && ")".equals(tokens.peek())) {
                Parser.processConditions(tokens, processed);
            }
            if (tokens.isEmpty()) {
                return;
            }
            if (!"OR".equals(tokens.peek()) && !"AND".equals(tokens.peek())) {
                throw new SQLException("Syntax Error : 'OR' or 'AND' keyword is expected");
            }
            processed.add(tokens.poll());
            Parser.processConditions(tokens, processed);
        }
    }

    private static void parseInsert(Queue<String> tokens, Queue<String> processed) throws SQLException {
        if (!"INSERT".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("Syntax Error : INSERT keyword is missing");
        }
        processed.add(tokens.poll().toUpperCase());
        if (!"INTO".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("Syntax Error : INTO keyword is missing");
        }
        processed.add(tokens.poll().toUpperCase());
        if (!ParserUtil.isStringLiteral(tokens.peek())) {
            throw new SQLException("Syntax Error : String literal expected");
        }
        processed.add("TABLE");
        processed.add(tokens.poll());
        if ("(".equalsIgnoreCase(tokens.peek())) {
            tokens.poll();
            Parser.processInsertedColumns(tokens, processed);
            if (!")".equalsIgnoreCase(tokens.peek())) {
                throw new SQLException("Syntax Error : ')' expected");
            }
            tokens.poll();
        }
        if (!"VALUES".equalsIgnoreCase(tokens.peek()) && !"VALUE".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("Syntax Error : VALUE/VALUES keyword missing");
        }
        processed.add(tokens.poll().toUpperCase());
        if (!"(".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("Syntax Error : Left bracket is expected");
        }
        tokens.poll();
        Parser.processInsertedValues(tokens, processed, false, false, true);
        if (!")".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("Syntax exception : ')' expected");
        }
        tokens.poll();
        Parser.processDelimiter(tokens);
    }

    private static void processInsertedColumns(Queue<String> tokens, Queue<String> processed) throws SQLException {
        if (!ParserUtil.isStringLiteral(tokens.peek())) {
            throw new SQLException("Syntax Error : String literal expected");
        }
        processed.add("COLUMN");
        processed.add(tokens.poll());
        if (",".equalsIgnoreCase(tokens.peek())) {
            tokens.poll();
            Parser.processInsertedColumns(tokens, processed);
        }
    }

    private static void processInsertedValues(Queue<String> tokens, Queue<String> processed, boolean isParameterized, boolean isEnd, boolean isInit) throws SQLException {
        if (!isEnd) {
            if (!ParserUtil.isStringLiteral(tokens.peek())) {
                throw new SQLException("Syntax Error : String literal expected");
            }
            if ("?".equalsIgnoreCase(tokens.peek())) {
                if (isInit) {
                    isParameterized = true;
                    isInit = false;
                }
                if (!isParameterized) {
                    throw new SQLException("Both parameters and inline parameter values are not allowed to exist together");
                }
                isParameterized = true;
                processed.add("PARAM_VALUE");
                processed.add(tokens.poll());
            } else if ("'".equalsIgnoreCase(tokens.peek())) {
                if (isInit) {
                    isInit = false;
                    isParameterized = false;
                }
                if (isParameterized) {
                    throw new SQLException("Both parameters and inline parameter values are not allowed to exist together");
                }
                processed.add(tokens.poll());
                StringBuilder b = new StringBuilder();
                while ("'".equalsIgnoreCase(tokens.peek()) || tokens.isEmpty()) {
                    b.append(tokens.poll());
                }
                processed.add(b.toString());
                processed.add("'");
            } else if (ParserUtil.isStringLiteral(tokens.peek())) {
                if (isInit) {
                    isInit = false;
                    isParameterized = false;
                }
                if (isParameterized) {
                    throw new SQLException("Both parameters and inline parameter values are not allowed to exist together");
                }
                processed.add(tokens.peek());
            }
            if (!",".equalsIgnoreCase(tokens.peek())) {
                isEnd = true;
            } else {
                tokens.poll();
            }
            Parser.processInsertedValues(tokens, processed, isParameterized, isEnd, isInit);
        }
    }

    private static void parseUpdate(Queue<String> tokens, Queue<String> processed) throws SQLException {
        if (!"UPDATE".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("Syntax Error : UPDATE keyword missing");
        }
        processed.add(tokens.poll().toUpperCase());
        if (!ParserUtil.isStringLiteral(tokens.peek())) {
            throw new SQLException("Syntax Error : Table name missing");
        }
        processed.add("TABLE");
        processed.add(tokens.poll());
        if (!"SET".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("Syntax Error : SET keyword missing");
        }
        processed.add(tokens.poll().toUpperCase());
        Parser.processUpdateTargets(tokens, processed);
        if (tokens.isEmpty()) {
            return;
        }
        if ("WHERE".equalsIgnoreCase(tokens.peek())) {
            Parser.processWhere(tokens, processed);
        }
        Parser.processDelimiter(tokens);
    }

    private static void processUpdateTargets(Queue<String> tokens, Queue<String> processed) throws SQLException {
        if (!ParserUtil.isStringLiteral(tokens.peek())) {
            throw new SQLException("Syntax Error");
        }
        processed.add("COLUMN");
        processed.add(tokens.poll());
        if (!"=".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("Syntax Error : '=' is expected");
        }
        processed.add("OPERATOR");
        processed.add(tokens.poll());
        Parser.processColumnValue(tokens, processed);
        if (tokens.isEmpty() || "WHERE".equalsIgnoreCase(tokens.peek())) {
            return;
        }
        if (!",".equals(tokens.peek())) {
            throw new SQLException("Syntax Error : Unexpected token found");
        }
        tokens.poll();
        Parser.processUpdateTargets(tokens, processed);
    }

    private static void processColumnValue(Queue<String> tokens, Queue<String> processed) throws SQLException {
        if ("?".equalsIgnoreCase(tokens.peek())) {
            processed.add("PARAM_VALUE");
            processed.add(tokens.poll());
        } else if ("'".equalsIgnoreCase(tokens.peek())) {
            processed.add("PARAM_VALUE");
            processed.add(tokens.poll());
            while (!"'".equalsIgnoreCase(tokens.peek())) {
                processed.add(tokens.poll());
            }
            if (!"'".equalsIgnoreCase(tokens.peek())) {
                throw new SQLException("Syntax Error : Single quote is expected");
            }
            processed.add(tokens.poll());
        } else if (ParserUtil.isStringLiteral(tokens.peek())) {
            processed.add("PARAM_VALUE");
            StringBuilder tmp = new StringBuilder();
            while (!(tokens.isEmpty() || ParserUtil.getConditionalOperatorList().contains(tokens.peek()) || ")".equals(tokens.peek()))) {
                tmp.append(tokens.poll());
            }
            Parser.validateParamValue(tmp.toString());
            processed.add(tmp.toString());
        }
    }

    private static void validateParamValue(String s) throws SQLException {
        try {
            if (!s.contains(".")) {
                Integer.parseInt(s);
            } else {
                Double.parseDouble(s);
            }
        }
        catch (Exception e) {
            throw new SQLException("Invalid parameter value ('" + s + "') specified", e);
        }
    }

    private static void parseDelete(Queue<String> tokens, Queue<String> processed) throws SQLException {
        if (!"DELETE".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("Syntax Error : 'DELETE' expected");
        }
        processed.add(tokens.poll().toUpperCase());
        if (!"FROM".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("Syntax Error : 'FROM' expected");
        }
        processed.add(tokens.poll().toUpperCase());
        if (!ParserUtil.isStringLiteral(tokens.peek())) {
            throw new SQLException("Syntax Error : String literal expected");
        }
        processed.add("TABLE");
        processed.add(tokens.poll());
        if (!tokens.isEmpty()) {
            Parser.processWhereClause(tokens, processed);
        }
        Parser.processDelimiter(tokens);
    }

    private static void processWhere(Queue<String> tokens, Queue<String> processed) throws SQLException {
        if (!"WHERE".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("Syntax Error : 'WHERE' clause expected");
        }
        processed.add(tokens.poll().toUpperCase());
        Parser.processWhereTargets(tokens, processed);
        Parser.processDelimiter(tokens);
    }

    private static void processDelimiter(Queue<String> tokens) throws SQLException {
        if (DELIMITER.equalsIgnoreCase(tokens.peek())) {
            tokens.peek();
        } else if (ParserUtil.isKeyword(tokens.peek())) {
            throw new SQLException("Synatax Error : ';' expected");
        }
    }

    private static void processWhereTargets(Queue<String> tokens, Queue<String> processed) throws SQLException {
        if (!ParserUtil.isStringLiteral(tokens.peek())) {
            throw new SQLException("Syntax Error : String literal expected");
        }
        processed.add("COLUMN");
        processed.add(tokens.poll());
        processed.add("OPERATOR");
        processed.add(tokens.poll());
        Parser.processWhereColumnValues(tokens, processed, false, false, true);
    }

    private static void processWhereColumnValues(Queue<String> tokens, Queue<String> processed, boolean isParameterized, boolean isEnd, boolean isInit) throws SQLException {
        if (!isEnd) {
            if (!ParserUtil.isStringLiteral(tokens.peek())) {
                throw new SQLException("Syntax Error : String literal expected");
            }
            if ("?".equalsIgnoreCase(tokens.peek())) {
                if (isInit) {
                    isParameterized = true;
                    isInit = false;
                }
                if (!isParameterized) {
                    throw new SQLException("Both parameters and inline parameter values are not allowed to exist together");
                }
                processed.add("PARAM_VALUE");
                processed.add(tokens.poll());
            } else if ("'".equalsIgnoreCase(tokens.peek())) {
                if (isInit) {
                    isParameterized = false;
                    isInit = false;
                }
                if (isParameterized) {
                    throw new SQLException("Both parameters and inline parameter values are not allowed to exist together");
                }
                processed.add(tokens.poll());
                StringBuilder b = new StringBuilder();
                while ("'".equalsIgnoreCase(tokens.peek()) || tokens.isEmpty()) {
                    b.append(tokens.poll());
                }
                processed.add(b.toString());
                processed.add("'");
            } else if (ParserUtil.isStringLiteral(tokens.peek())) {
                if (isInit) {
                    isParameterized = false;
                    isInit = false;
                }
                if (isParameterized) {
                    throw new SQLException("Both parameters and inline parameter values are not allowed to exist together");
                }
                isParameterized = false;
                processed.add(tokens.poll());
            }
            if (!"AND".equalsIgnoreCase(tokens.peek()) || !"OR".equalsIgnoreCase(tokens.peek())) {
                isEnd = true;
            }
            tokens.poll();
            Parser.processWhereColumnValues(tokens, processed, isParameterized, isEnd, isInit);
        }
    }

    public static enum QueryTypes {
        SELECT,
        UPDATE,
        INSERT,
        DELETE,
        DROP,
        CREATE;

    }
}

