/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.query.drop;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.wso2.carbon.dataservices.sql.driver.TDriverUtil;
import org.wso2.carbon.dataservices.sql.driver.TExcelConnection;
import org.wso2.carbon.dataservices.sql.driver.query.drop.DropQuery;

public class ExcelDropQuery
extends DropQuery {
    public ExcelDropQuery(Statement stmt) throws SQLException {
        super(stmt);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeSQL();
        return null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.executeSQL();
        return 0;
    }

    @Override
    public boolean execute() throws SQLException {
        this.executeSQL();
        return false;
    }

    private synchronized void executeSQL() throws SQLException {
        TExcelConnection excelConnection = (TExcelConnection)this.getConnection();
        excelConnection.beginExcelTransaction();
        Workbook workbook = excelConnection.getWorkbook();
        if (!this.isSheetExists(workbook)) {
            throw new SQLException("Excel sheet named '" + this.getTableName() + "' does not exist");
        }
        int sheetIndex = workbook.getSheetIndex(this.getTableName());
        workbook.removeSheetAt(sheetIndex);
        TDriverUtil.writeRecords(workbook, ((TExcelConnection)this.getConnection()).getPath());
    }

    private boolean isSheetExists(Workbook workbook) {
        Sheet sheet = workbook.getSheet(this.getTableName());
        return sheet != null;
    }
}

