/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.query.select;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.wso2.carbon.dataservices.sql.driver.TResultSet;
import org.wso2.carbon.dataservices.sql.driver.parser.ParserUtil;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataReaderFactory;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataRow;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataTable;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.FixedDataTable;
import org.wso2.carbon.dataservices.sql.driver.query.ColumnInfo;
import org.wso2.carbon.dataservices.sql.driver.query.ConditionalQuery;

public abstract class SelectQuery
extends ConditionalQuery {
    private ColumnInfo[] targetColumns;
    private String targetTableName;
    private DataTable targetTable;
    private boolean isAllColumnsSelected = this.checkAllColumnsSelected(this.getProcessedTokens());

    public SelectQuery(Statement stmt) throws SQLException {
        super(stmt);
        this.targetColumns = this.extractTargetColumns(this.getProcessedTokens());
        this.targetTableName = this.extractTargetTableName(this.getProcessedTokens());
        this.populateConditions(this.getProcessedTokens());
        this.targetTable = DataReaderFactory.createDataReader(this.getConnection()).getDataTable(this.getTargetTableName());
        if (this.isAllColumnsSelected()) {
            this.targetColumns = this.getTargetTable().getHeaders();
        }
        this.processTargetColumnIds();
    }

    @Override
    public int executeUpdate() throws SQLException {
        throw new SQLException("'executeUpdate() is only allowed to be used with DML statements such as INSERT, UPDATE and DELETE");
    }

    public synchronized ResultSet executeSQL() throws SQLException {
        FixedDataTable table = new FixedDataTable(this.getTargetTableName(), this.getTargetTable().getHeaders());
        Map<Integer, DataRow> result = this.getCondition().getLhs() == null && this.getCondition().getRhs() == null ? this.getTargetTable().getRows() : this.getCondition().process(this.getTargetTable());
        table.setData(this.filterColumns(result));
        return new TResultSet(this.getStatement(), table, this.getTargetColumns());
    }

    private Map<Integer, DataRow> filterColumns(Map<Integer, DataRow> rows) throws SQLException {
        HashMap<Integer, DataRow> filteredData = new HashMap<Integer, DataRow>();
        for (Map.Entry<Integer, DataRow> entry : rows.entrySet()) {
            DataRow row = entry.getValue();
            DataRow filteredRow = new DataRow(entry.getValue().getRowId());
            for (ColumnInfo column : this.getTargetColumns()) {
                filteredRow.addCell(column.getOrdinal(), row.getCell(column.getId()));
            }
            filteredData.put(filteredRow.getRowId(), filteredRow);
        }
        return filteredData;
    }

    private ColumnInfo[] extractTargetColumns(Queue<String> tokens) throws SQLException {
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        if (this.isAllColumnsSelected()) {
            tokens.poll();
        } else {
            this.processTargetColumns(tokens, 1, columns);
        }
        return columns.toArray(new ColumnInfo[columns.size()]);
    }

    private boolean checkAllColumnsSelected(Queue<String> tokens) {
        tokens.poll();
        return "*".equalsIgnoreCase(tokens.peek());
    }

    private String extractTargetTableName(Queue<String> tokens) throws SQLException {
        tokens.poll();
        if (!"TABLE".equals(tokens.peek())) {
            throw new SQLException("'TABLE' keyword is expected");
        }
        tokens.poll();
        if (!ParserUtil.isStringLiteral(tokens.peek())) {
            throw new SQLException("Syntax Error : String literal is expected");
        }
        return tokens.poll();
    }

    private void populateConditions(Queue<String> tokens) throws SQLException {
        if (tokens.isEmpty()) {
            return;
        }
        if (!"WHERE".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("Syntax Error : 'WHERE' keyword is expected");
        }
        tokens.poll();
        this.processConditions(tokens, this.getCondition());
    }

    private void processTargetColumnIds() throws SQLException {
        for (ColumnInfo column : this.getTargetColumns()) {
            ColumnInfo header = this.getTargetTable().getHeader(column.getName());
            column.setId(header.getId());
        }
    }

    private void processTargetColumns(Queue<String> tokens, int count, List<ColumnInfo> columns) throws SQLException {
        if (!"COLUMN".equals(tokens.peek())) {
            throw new SQLException("Syntax Error : 'COLUMN' keyword is expected");
        }
        tokens.poll();
        if (!ParserUtil.isStringLiteral(tokens.peek())) {
            throw new SQLException("Syntax Error : String literal is expected");
        }
        columns.add(new ColumnInfo(tokens.poll(), count));
        if ("COLUMN".equals(tokens.peek())) {
            this.processTargetColumns(tokens, count + 1, columns);
        }
    }

    public ColumnInfo[] getTargetColumns() {
        return this.targetColumns;
    }

    public DataTable getTargetTable() {
        return this.targetTable;
    }

    public String getTargetTableName() {
        return this.targetTableName;
    }

    public boolean isAllColumnsSelected() {
        return this.isAllColumnsSelected;
    }
}

