/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.query.delete;

import com.google.gdata.data.spreadsheet.ListEntry;
import com.google.gdata.data.spreadsheet.ListFeed;
import com.google.gdata.data.spreadsheet.SpreadsheetEntry;
import com.google.gdata.data.spreadsheet.SpreadsheetFeed;
import com.google.gdata.data.spreadsheet.WorksheetEntry;
import com.google.gdata.data.spreadsheet.WorksheetFeed;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import org.wso2.carbon.dataservices.sql.driver.TGSpreadConnection;
import org.wso2.carbon.dataservices.sql.driver.query.delete.DeleteQuery;

public class GSpreadDeleteQuery
extends DeleteQuery {
    public GSpreadDeleteQuery(Statement stmt) throws SQLException {
        super(stmt);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeSQL();
        return null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.executeSQL();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeSQL() > 0;
    }

    private synchronized int executeSQL() throws SQLException {
        int count = 0;
        TGSpreadConnection connection = (TGSpreadConnection)this.getConnection();
        SpreadsheetFeed spreadsheetFeed = connection.getSpreadSheetFeed();
        SpreadsheetEntry spreadsheet = (SpreadsheetEntry)spreadsheetFeed.getEntries().get(0);
        try {
            WorksheetFeed worksheetFeed = connection.getFeedProcessor().getFeed(spreadsheet.getWorksheetFeedUrl(), WorksheetFeed.class);
            WorksheetEntry currentWorksheet = null;
            for (WorksheetEntry tmp : worksheetFeed.getEntries()) {
                if (!this.getTargetTableName().equals(tmp.getTitle().getPlainText())) continue;
                currentWorksheet = tmp;
                break;
            }
            if (currentWorksheet == null) {
                throw new SQLException("Sheet '" + this.getTargetTableName() + "' does not exist");
            }
            ListFeed listFeed = connection.getFeedProcessor().getFeed(currentWorksheet.getListFeedUrl(), ListFeed.class);
            Set<Integer> rowKeys = this.getResultantRows().keySet();
            for (Integer rowKey : rowKeys) {
                ((ListEntry)listFeed.getEntries().get(rowKey - 1)).delete();
                ++count;
            }
        }
        catch (IOException e) {
            throw new SQLException("Error occurred while deleting the row", e);
        }
        catch (ServiceException e) {
            throw new SQLException("Error occurred while deleting the row", e);
        }
        return count;
    }
}

