/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.query.update;

import com.google.gdata.data.spreadsheet.ListEntry;
import com.google.gdata.data.spreadsheet.ListFeed;
import com.google.gdata.data.spreadsheet.WorksheetEntry;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.wso2.carbon.dataservices.sql.driver.TDriverUtil;
import org.wso2.carbon.dataservices.sql.driver.TGSpreadConnection;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataRow;
import org.wso2.carbon.dataservices.sql.driver.query.ColumnInfo;
import org.wso2.carbon.dataservices.sql.driver.query.update.UpdateQuery;

public class GSpreadUpdateQuery
extends UpdateQuery {
    public GSpreadUpdateQuery(Statement stmt) throws SQLException {
        super(stmt);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeSQL();
        return null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.executeSQL();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeSQL() > 0;
    }

    private int executeSQL() throws SQLException {
        int count = 0;
        Map<Integer, DataRow> result = this.getCondition().getLhs() == null && this.getCondition().getRhs() == null ? this.getTargetTable().getRows() : this.getCondition().process(this.getTargetTable());
        TGSpreadConnection connection = (TGSpreadConnection)this.getConnection();
        WorksheetEntry currentWorkSheet = TDriverUtil.getCurrentWorkSheetEntry(connection, this.getTargetTableName());
        if (currentWorkSheet == null) {
            throw new SQLException("WorkSheet '" + this.getTargetTableName() + "' does not exist");
        }
        ListFeed listFeed = TDriverUtil.getListFeed(connection, currentWorkSheet);
        for (Map.Entry<Integer, DataRow> row : result.entrySet()) {
            ListEntry listEntry = (ListEntry)listFeed.getEntries().get(row.getKey() - 1);
            for (ColumnInfo column : this.getTargetColumns()) {
                listEntry.getCustomElements().setValueLocal(column.getName(), column.getValue().toString());
            }
            try {
                listEntry.update();
                ++count;
            }
            catch (IOException e) {
                throw new SQLException("Error occurred while updating the record ", e);
            }
            catch (ServiceException e) {
                throw new SQLException("Error occurred while updating the record", e);
            }
        }
        return count;
    }
}

