/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.query;

import java.sql.SQLException;
import java.sql.Statement;
import org.wso2.carbon.dataservices.sql.driver.TConnection;
import org.wso2.carbon.dataservices.sql.driver.TPreparedStatement;
import org.wso2.carbon.dataservices.sql.driver.query.Query;
import org.wso2.carbon.dataservices.sql.driver.query.create.ExcelCreateQuery;
import org.wso2.carbon.dataservices.sql.driver.query.create.GSpreadCreateQuery;
import org.wso2.carbon.dataservices.sql.driver.query.delete.CustomDeleteQuery;
import org.wso2.carbon.dataservices.sql.driver.query.delete.ExcelDeleteQuery;
import org.wso2.carbon.dataservices.sql.driver.query.delete.GSpreadDeleteQuery;
import org.wso2.carbon.dataservices.sql.driver.query.drop.ExcelDropQuery;
import org.wso2.carbon.dataservices.sql.driver.query.drop.GSpreadDropQuery;
import org.wso2.carbon.dataservices.sql.driver.query.insert.CustomInsertQuery;
import org.wso2.carbon.dataservices.sql.driver.query.insert.ExcelInsertQuery;
import org.wso2.carbon.dataservices.sql.driver.query.insert.GSpreadInsertQuery;
import org.wso2.carbon.dataservices.sql.driver.query.select.CustomSelectQuery;
import org.wso2.carbon.dataservices.sql.driver.query.select.ExcelSelectQuery;
import org.wso2.carbon.dataservices.sql.driver.query.select.GSpreadSelectQuery;
import org.wso2.carbon.dataservices.sql.driver.query.update.CustomUpdateQuery;
import org.wso2.carbon.dataservices.sql.driver.query.update.ExcelUpdateQuery;
import org.wso2.carbon.dataservices.sql.driver.query.update.GSpreadUpdateQuery;

public class QueryFactory {
    public static Query createQuery(Statement stmt) throws SQLException {
        String queryType = ((TPreparedStatement)stmt).getQueryType();
        QueryFactoryTypes types = QueryFactoryTypes.valueOf(queryType);
        switch (types) {
            case SELECT: {
                return QueryFactory.createSelectQuery(stmt);
            }
            case INSERT: {
                return QueryFactory.createInsertQuery(stmt);
            }
            case UPDATE: {
                return QueryFactory.createUpdateQuery(stmt);
            }
            case DELETE: {
                return QueryFactory.createDeleteQuery(stmt);
            }
            case CREATE: {
                return QueryFactory.createCreateQuery(stmt);
            }
            case DROP: {
                return QueryFactory.createDropQuery(stmt);
            }
        }
        throw new SQLException("Unsupport query type");
    }

    private static Query createDropQuery(Statement stmt) throws SQLException {
        String connectionType = ((TConnection)((TPreparedStatement)stmt).getConnection()).getType();
        QueryTypes types = QueryTypes.valueOf(connectionType);
        switch (types) {
            case EXCEL: {
                return new ExcelDropQuery(stmt);
            }
            case GSPREAD: {
                return new GSpreadDropQuery(stmt);
            }
        }
        throw new SQLException("Unsupported type");
    }

    private static Query createCreateQuery(Statement stmt) throws SQLException {
        String connectionType = ((TConnection)((TPreparedStatement)stmt).getConnection()).getType();
        QueryTypes types = QueryTypes.valueOf(connectionType);
        switch (types) {
            case EXCEL: {
                return new ExcelCreateQuery(stmt);
            }
            case GSPREAD: {
                return new GSpreadCreateQuery(stmt);
            }
        }
        throw new SQLException("Unsupported type");
    }

    private static Query createDeleteQuery(Statement stmt) throws SQLException {
        String connectionType = ((TConnection)((TPreparedStatement)stmt).getConnection()).getType();
        QueryTypes types = QueryTypes.valueOf(connectionType);
        switch (types) {
            case EXCEL: {
                return new ExcelDeleteQuery(stmt);
            }
            case GSPREAD: {
                return new GSpreadDeleteQuery(stmt);
            }
            case CUSTOM: {
                return new CustomDeleteQuery(stmt);
            }
        }
        throw new SQLException("Unsupported type");
    }

    public static Query createInsertQuery(Statement stmt) throws SQLException {
        String connectionType = ((TConnection)((TPreparedStatement)stmt).getConnection()).getType();
        QueryTypes types = QueryTypes.valueOf(connectionType);
        switch (types) {
            case EXCEL: {
                return new ExcelInsertQuery(stmt);
            }
            case GSPREAD: {
                return new GSpreadInsertQuery(stmt);
            }
            case CUSTOM: {
                return new CustomInsertQuery(stmt);
            }
        }
        throw new SQLException("Unsupported type");
    }

    private static Query createSelectQuery(Statement stmt) throws SQLException {
        String connectionType = ((TConnection)((TPreparedStatement)stmt).getConnection()).getType();
        QueryTypes types = QueryTypes.valueOf(connectionType);
        switch (types) {
            case EXCEL: {
                return new ExcelSelectQuery(stmt);
            }
            case GSPREAD: {
                return new GSpreadSelectQuery(stmt);
            }
            case CUSTOM: {
                return new CustomSelectQuery(stmt);
            }
        }
        throw new SQLException("Unsupported type");
    }

    private static Query createUpdateQuery(Statement stmt) throws SQLException {
        String connectionType = ((TConnection)((TPreparedStatement)stmt).getConnection()).getType();
        QueryTypes types = QueryTypes.valueOf(connectionType);
        switch (types) {
            case EXCEL: {
                return new ExcelUpdateQuery(stmt);
            }
            case GSPREAD: {
                return new GSpreadUpdateQuery(stmt);
            }
            case CUSTOM: {
                return new CustomUpdateQuery(stmt);
            }
        }
        throw new SQLException("Unsupported type");
    }

    public static enum QueryTypes {
        EXCEL,
        GSPREAD,
        CUSTOM;

    }

    public static enum QueryFactoryTypes {
        SELECT,
        INSERT,
        UPDATE,
        DELETE,
        CREATE,
        DROP;

    }
}

