/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.query.delete;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.wso2.carbon.dataservices.sql.driver.TCustomConnection;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataTable;
import org.wso2.carbon.dataservices.sql.driver.query.delete.DeleteQuery;

public class CustomDeleteQuery
extends DeleteQuery {
    public CustomDeleteQuery(Statement stmt) throws SQLException {
        super(stmt);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeUpdate();
        return null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (!(this.getConnection() instanceof TCustomConnection)) {
            throw new SQLException("Connection does not refer to a Custom connection");
        }
        DataTable table = ((TCustomConnection)this.getConnection()).getDataSource().getDataTable(this.getTargetTableName());
        if (table == null) {
            throw new SQLException("The custom data table '" + this.getTargetTableName() + "' does not exist");
        }
        Integer[] ids = this.getResultantRows().keySet().toArray(new Integer[0]);
        int[] intIds = new int[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            intIds[i] = ids[i];
        }
        table.deleteRows(intIds);
        return intIds.length;
    }

    @Override
    public boolean execute() throws SQLException {
        this.executeUpdate();
        return true;
    }
}

