/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.query.insert;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.spreadsheet.ListEntry;
import com.google.gdata.data.spreadsheet.ListFeed;
import com.google.gdata.data.spreadsheet.WorksheetEntry;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.wso2.carbon.dataservices.sql.driver.TDriverUtil;
import org.wso2.carbon.dataservices.sql.driver.TGSpreadConnection;
import org.wso2.carbon.dataservices.sql.driver.query.ColumnInfo;
import org.wso2.carbon.dataservices.sql.driver.query.ParamInfo;
import org.wso2.carbon.dataservices.sql.driver.query.insert.InsertQuery;

public class GSpreadInsertQuery
extends InsertQuery {
    ColumnInfo[] columns = TDriverUtil.getHeaders(this.getConnection(), this.getTargetTableName());

    public GSpreadInsertQuery(Statement stmt) throws SQLException {
        super(stmt);
        this.processParameters(this.columns);
    }

    private void processParameters(ColumnInfo[] columns) {
        for (ColumnInfo column : columns) {
            for (ParamInfo param : this.getParameters()) {
                if (param.getOrdinal() != column.getId()) continue;
                param.setName(column.getName());
            }
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeSQL();
        return null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.executeSQL();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeSQL() > 0;
    }

    private synchronized int executeSQL() throws SQLException {
        int count = 1;
        TGSpreadConnection connection = (TGSpreadConnection)this.getConnection();
        WorksheetEntry currentWorkSheet = TDriverUtil.getCurrentWorkSheetEntry(connection, this.getTargetTableName());
        if (currentWorkSheet == null) {
            throw new SQLException("WorkSheet '" + this.getTargetTableName() + "' does not exist");
        }
        ListFeed listFeed = TDriverUtil.getListFeed(connection, currentWorkSheet);
        ListEntry row = new ListEntry();
        for (ColumnInfo column : TDriverUtil.getHeaders(this.getConnection(), this.getTargetTableName())) {
            ParamInfo matchingParam = TDriverUtil.findParam(column, this.getParameters());
            if (matchingParam != null) {
                row.getCustomElements().setValueLocal(column.getName(), matchingParam.getValue().toString());
                continue;
            }
            row.getCustomElements().setValueLocal(column.getName(), null);
        }
        try {
            listFeed.insert((BaseEntry)row);
        }
        catch (ServiceException e) {
            throw new SQLException("Error occurred while writing the record to GSpread worksheet", e);
        }
        catch (IOException e) {
            throw new SQLException("Error occurred while writing the record to GSpread worksheet", e);
        }
        return count;
    }
}

