/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.sql.driver.TConnectionFactory;
import org.wso2.carbon.dataservices.sql.driver.TDriverUtil;

public class TDriver
implements Driver {
    private boolean isFilePath;
    private static final Log log = LogFactory.getLog(Driver.class);

    public boolean isFilePath() {
        return this.isFilePath;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Properties props = this.getProperties(url, info);
        String conType = props.getProperty("dsType");
        return TConnectionFactory.createConnection(conType, props);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return false;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    private Properties getProperties(String url, Properties info) throws SQLException {
        String dsType;
        if (url == null) {
            throw new SQLException("JDBC URL cannot be NULL");
        }
        Properties props = new Properties();
        Enumeration<?> e = info.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = info.getProperty(key);
            if (value == null) continue;
            props.setProperty(key.toUpperCase(), value);
        }
        int pos = 0;
        StringBuilder token = new StringBuilder();
        pos = this.getNextTokenPos(url, pos, token);
        if (!"jdbc".equalsIgnoreCase(token.toString())) {
            throw new SQLException("Malformed URL");
        }
        pos = this.getNextTokenPos(url, pos, token);
        if (!"wso2".equalsIgnoreCase(token.toString())) {
            throw new SQLException("Malformed URL");
        }
        pos = this.getNextTokenPos(url, pos, token);
        if (!"excel".equalsIgnoreCase(token.toString()) && !"gspread".equalsIgnoreCase(token.toString())) {
            throw new SQLException("Malformed URL");
        }
        props.setProperty("dsType", token.toString());
        pos = this.getNextTokenPos(url, pos, token);
        if ("filePath".equals(token.toString())) {
            this.isFilePath = true;
            pos = this.getNextTokenPos(url, pos, token);
            String propValue = token.toString();
            if (propValue == null || "".equals(propValue)) {
                throw new SQLException("File path attribute is missing");
            }
            props.setProperty("filePath", propValue);
        }
        if ((dsType = props.getProperty("dsType")) != null && "gspread".equals(dsType.toString())) {
            pos = this.getNextTokenPos(url, pos, token);
            if ("sheetName".equals(token.toString())) {
                pos = this.getNextTokenPos(url, pos, token);
                String propValue = token.toString();
                if (propValue == null || "".equals(propValue)) {
                    throw new SQLException("Sheet name attribute is missing");
                }
                props.setProperty("sheetName", propValue);
            }
        }
        Properties optionalProps = this.getOptionalProperties(url, pos, token);
        this.checkForHasHeaderProperty(optionalProps);
        Enumeration<?> e2 = optionalProps.propertyNames();
        while (e2.hasMoreElements()) {
            String key = (String)e2.nextElement();
            props.setProperty(key, optionalProps.getProperty(key));
        }
        return props;
    }

    private Properties getOptionalProperties(String url, int pos, StringBuilder token) throws SQLException {
        Properties optionalProps = new Properties();
        token.setLength(0);
        while (pos < url.length()) {
            char c;
            if ((c = url.charAt(pos++)) != ';') {
                token.append(c);
                continue;
            }
            this.addProperty(optionalProps, token);
            token.setLength(0);
        }
        if (token.length() > 0) {
            this.addProperty(optionalProps, token);
            token.setLength(0);
        }
        return optionalProps;
    }

    private void checkForHasHeaderProperty(Properties optionalProps) throws SQLException {
        String hasHeader = (String)optionalProps.get("hasHeader");
        if (hasHeader != null && !Boolean.parseBoolean(hasHeader)) {
            String maxColumns = (String)optionalProps.get("maxColumns");
            if (maxColumns == null) {
                throw new SQLException("'hasHeader' attribute should be accompanied by the attribute 'maxColumns'");
            }
            try {
                Integer.parseInt(maxColumns);
            }
            catch (Exception e) {
                throw new SQLException("Invalid value specified for the attribute 'maxColumns'", e);
            }
        }
    }

    private void addProperty(Properties props, StringBuilder token) throws SQLException {
        String propName = token.substring(0, token.indexOf("="));
        if (!TDriverUtil.getAvailableDriverProperties().contains(propName)) {
            throw new SQLException("Invalid driver property '" + propName + "' specified");
        }
        String propValue = token.substring(token.indexOf("=") + 1, token.length());
        props.setProperty(propName, propValue);
    }

    private int getNextTokenPos(String url, int pos, StringBuilder token) {
        char c;
        token.setLength(0);
        while (pos < url.length() && ((c = url.charAt(pos++)) != ':' || this.isFilePath())) {
            if (c == ';') {
                if (!this.isFilePath()) break;
                this.isFilePath = false;
                break;
            }
            if (c == '/' && !this.isFilePath() || c == '=' && !this.isFilePath()) break;
            token.append(c);
        }
        if ("".equals(token.toString()) && pos < url.length()) {
            return this.getNextTokenPos(url, pos, token);
        }
        return pos;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("This method is not supported");
    }

    static {
        try {
            DriverManager.registerDriver(new TDriver());
        }
        catch (SQLException e) {
            log.error((Object)"Error in registering the driver", (Throwable)e);
        }
    }
}

